/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

import com.contentful.java.cda.LocalizedResource;
import com.contentful.java.cda.image.ImageOption;
import java.util.LinkedHashMap;
import java.util.Map;

public class CDAAsset
extends LocalizedResource {
    public String title() {
        return (String)this.getField("title");
    }

    public String url() {
        return (String)this.fileField("url");
    }

    public String urlForImageWith(ImageOption ... options) {
        if (options == null || options.length == 0) {
            throw new IllegalArgumentException("Do not use empty options argument. If you want to manipulate the url by hand, please use `CDAAsset.url()` instead.");
        }
        String mimeType = this.mimeType();
        if (mimeType == null || !mimeType.startsWith("image")) {
            throw new IllegalStateException("Asset does not have an image mime type.");
        }
        LinkedHashMap<String, ImageOption> mappedOptions = new LinkedHashMap<String, ImageOption>(options.length);
        for (ImageOption option : options) {
            mappedOptions.put(option.getOperation(), option);
        }
        String url = this.url();
        for (ImageOption option : mappedOptions.values()) {
            url = option.apply(url);
        }
        return url;
    }

    public String mimeType() {
        return (String)this.fileField("contentType");
    }

    public <T> T fileField(String key) {
        T result = null;
        Map file = (Map)this.getField("file");
        if (file != null) {
            result = (T)file.get(key);
        }
        return result;
    }

    public String toString() {
        return "CDAAsset{id='" + this.id() + '\'' + ", title='" + this.title() + '\'' + '}';
    }
}

