/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

import com.contentful.java.cda.CDAResource;
import com.contentful.java.cda.CDAType;
import com.contentful.java.cda.Constants;
import com.contentful.java.cda.LocalizedResource;
import com.contentful.java.cda.Util;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Collections;

final class ResourceDeserializer
implements JsonDeserializer<CDAResource> {
    ResourceDeserializer() {
    }

    public CDAResource deserialize(JsonElement json, Type classType, JsonDeserializationContext context) throws JsonParseException {
        CDAType cdaType = this.extractType(json);
        CDAResource result = (CDAResource)context.deserialize(json, Util.classForType(cdaType));
        if (CDAType.ASSET.equals((Object)cdaType) || CDAType.ENTRY.equals((Object)cdaType)) {
            LocalizedResource localized = (LocalizedResource)result;
            if (localized.fields == null) {
                localized.fields = Collections.emptyMap();
            }
        }
        return result;
    }

    private CDAType extractType(JsonElement json) {
        String type = json.getAsJsonObject().get("sys").getAsJsonObject().get("type").getAsString();
        return CDAType.valueOf(type.toUpperCase(Constants.LOCALE));
    }
}

