/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda.image;

import java.util.Locale;

public class ImageOption {
    private final String operation;
    private final String argument;

    public static ImageOption formatOf(Format format) {
        return new ImageOption("fm", format.name());
    }

    public static ImageOption jpegQualityOf(int quality) {
        if (quality < 1 || quality > 100) {
            throw new IllegalArgumentException("Quality has to be in the range from 1 to 100.");
        }
        return new ImageOption("q", Integer.toString(quality));
    }

    public static ImageOption widthOf(int width) {
        if (width <= 0) {
            throw new IllegalArgumentException("Width has to be positive.");
        }
        return new ImageOption("w", Integer.toString(width));
    }

    public static ImageOption heightOf(int height) {
        if (height <= 0) {
            throw new IllegalArgumentException("Height has to be positive.");
        }
        return new ImageOption("h", Integer.toString(height));
    }

    public static ImageOption fitOf(Resize resize) {
        return new ImageOption("fit", resize.name());
    }

    public static ImageOption focusOn(Focus focus) {
        return new ImageOption("f", focus.name());
    }

    public static ImageOption roundedCornerRadiusOf(float radius) {
        if (radius < 0.0f) {
            throw new IllegalArgumentException("Radius is negative.");
        }
        return new ImageOption("r", Float.toString(radius));
    }

    public static ImageOption backgroundColorOf(int color) {
        if (color < 0 || color > 0xFFFFFF) {
            throw new IllegalArgumentException("Color must be in rgb hex range of 0x0 to 0xFFFFFF.");
        }
        return new ImageOption("bg", "rgb:" + String.format(Locale.getDefault(), "%06X", color));
    }

    public static ImageOption backgroundColorOf(int r, int g, int b) {
        if (r > 255 || r < 0) {
            throw new IllegalArgumentException("Red component out of range: " + r);
        }
        if (g > 255 || g < 0) {
            throw new IllegalArgumentException("Green component out of range: " + g);
        }
        if (b > 255 || b < 0) {
            throw new IllegalArgumentException("Blue component out of range: " + b);
        }
        return new ImageOption("bg", "rgb:" + String.format(Locale.getDefault(), "%02X%02X%02X", r, g, b));
    }

    public static ImageOption blackBackgroundColor() {
        return ImageOption.backgroundColorOf(0);
    }

    public static ImageOption http() {
        return new ImageOption("http", ""){

            @Override
            public String apply(String url) {
                if (url.startsWith("//")) {
                    return "http:" + url;
                }
                return url;
            }
        };
    }

    public static ImageOption https() {
        return new ImageOption("https", ""){

            @Override
            public String apply(String url) {
                if (url.startsWith("//")) {
                    return "https:" + url;
                }
                return url;
            }
        };
    }

    private ImageOption(String operation, String argument) {
        this.operation = operation;
        this.argument = argument;
    }

    public String apply(String url) {
        return String.format(Locale.getDefault(), "%s%s%s=%s", url, this.concatenationOperator(url), this.operation, this.argument);
    }

    public String getOperation() {
        return this.operation;
    }

    private String concatenationOperator(String url) {
        return url.contains("?") ? "&" : "?";
    }

    public static enum Focus {
        top,
        left,
        right,
        bottom,
        top_left,
        top_right,
        bottom_left,
        bottom_right,
        face,
        faces;

    }

    public static enum Resize {
        pad,
        crop,
        fill,
        thumb,
        scale;

    }

    public static enum Format {
        jpg,
        png,
        webp;

    }
}

