/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import com.contentstack.sdk.APIService;
import com.contentstack.sdk.Config;
import com.contentstack.sdk.Constants;
import com.contentstack.sdk.IRequestModelHTTP;
import com.contentstack.sdk.IURLRequestHTTP;
import com.contentstack.sdk.ResultCallBack;
import com.contentstack.sdk.Stack;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import okhttp3.Request;
import okhttp3.ResponseBody;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Response;

public class CSHttpConnection
implements IURLRequestHTTP {
    protected static final Logger logger = Logger.getLogger(CSHttpConnection.class.getName());
    private final String urlPath;
    private final IRequestModelHTTP connectionRequest;
    private String controller;
    private LinkedHashMap<String, Object> headers;
    private String info;
    private APIService service;
    private Config config;
    private Stack stackInstance;
    private ResultCallBack callBackObject;
    private JSONObject responseJSON;
    private HashMap<String, Object> formParams;
    private final String utfType = String.valueOf(StandardCharsets.UTF_8);

    public CSHttpConnection(String urlToCall, IRequestModelHTTP csConnectionRequest) {
        this.urlPath = urlToCall;
        this.connectionRequest = csConnectionRequest;
    }

    public void setFormParams(HashMap<String, Object> formParams) {
        this.formParams = formParams;
    }

    @Override
    public String getController() {
        return this.controller;
    }

    @Override
    public void setController(String controller) {
        this.controller = controller;
    }

    @Override
    public void setHeaders(LinkedHashMap<String, Object> headers) {
        this.headers = headers;
    }

    @Override
    public LinkedHashMap<String, Object> getHeaders() {
        return this.headers;
    }

    @Override
    public String getInfo() {
        return this.info;
    }

    @Override
    public void setInfo(String info) {
        this.info = info;
    }

    @Override
    public ResultCallBack getCallBackObject() {
        return this.callBackObject;
    }

    @Override
    public void setCallBackObject(ResultCallBack callBackObject) {
        this.callBackObject = callBackObject;
    }

    @Override
    public JSONObject getResponse() {
        return this.responseJSON;
    }

    public String setFormParamsGET(HashMap<String, Object> params) {
        if (params != null && params.size() > 0) {
            String urlParams = null;
            String string = urlParams = this.info.equalsIgnoreCase(Constants.REQUEST_CONTROLLER.QUERY.name()) || this.info.equalsIgnoreCase(Constants.REQUEST_CONTROLLER.ENTRY.name()) ? this.getParams(params) : null;
            if (urlParams == null) {
                for (Map.Entry<String, Object> e : params.entrySet()) {
                    if (urlParams == null) {
                        urlParams = "?" + e.getKey() + "=" + e.getValue();
                        continue;
                    }
                    urlParams = urlParams + "&" + e.getKey() + "=" + e.getValue();
                }
            }
            return urlParams;
        }
        return null;
    }

    private String getParams(HashMap<String, Object> params) {
        String urlParams = "?";
        for (Map.Entry<String, Object> e : params.entrySet()) {
            String key = e.getKey();
            Object value = e.getValue();
            try {
                int i;
                JSONArray array;
                String innerKey;
                JSONObject onlyJSON;
                if (key.equalsIgnoreCase("include[]") || key.equalsIgnoreCase("only[BASE][]") || key.equalsIgnoreCase("except[BASE][]")) {
                    urlParams = this.convertUrlParam(urlParams, value, key);
                    continue;
                }
                if (key.equalsIgnoreCase("only")) {
                    onlyJSON = (JSONObject)value;
                    Iterator itrString = onlyJSON.keys();
                    while (itrString.hasNext()) {
                        innerKey = (String)itrString.next();
                        array = onlyJSON.optJSONArray(innerKey);
                        innerKey = URLEncoder.encode("only[" + innerKey + "][]", this.utfType);
                        for (i = 0; i < array.length(); ++i) {
                            urlParams = urlParams + (urlParams.equals("?") ? innerKey + "=" + array.opt(i) : "&" + innerKey + "=" + array.opt(i));
                        }
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("except")) {
                    onlyJSON = (JSONObject)value;
                    Iterator iter = onlyJSON.keys();
                    while (iter.hasNext()) {
                        innerKey = (String)iter.next();
                        array = onlyJSON.optJSONArray(innerKey);
                        innerKey = URLEncoder.encode("except[" + innerKey + "][]", this.utfType);
                        for (i = 0; i < array.length(); ++i) {
                            urlParams = urlParams + (urlParams.equals("?") ? innerKey + "=" + array.opt(i) : "&" + innerKey + "=" + array.opt(i));
                        }
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("query")) {
                    JSONObject queryJSON = (JSONObject)value;
                    urlParams = urlParams + (urlParams.equals("?") ? key + "=" + URLEncoder.encode(queryJSON.toString(), this.utfType) : "&" + key + "=" + URLEncoder.encode(queryJSON.toString(), this.utfType));
                    continue;
                }
                urlParams = urlParams + (urlParams.equals("?") ? key + "=" + value : "&" + key + "=" + value);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return urlParams;
    }

    private String convertUrlParam(String urlParams, Object value, String key) throws UnsupportedEncodingException {
        key = URLEncoder.encode(key, this.utfType);
        JSONArray array = (JSONArray)value;
        for (int i = 0; i < array.length(); ++i) {
            urlParams = urlParams + (urlParams.equals("?") ? key + "=" + array.opt(i) : "&" + key + "=" + array.opt(i));
        }
        return urlParams;
    }

    @Override
    public void send() {
        String url = "";
        String params = this.setFormParamsGET(this.formParams);
        url = params != null ? this.urlPath + params : this.urlPath;
        try {
            this.getService(url);
        }
        catch (IOException | JSONException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    private void getService(String requestUrl) throws IOException {
        Response<ResponseBody> response;
        this.headers.put("X-User-Agent", "contentstack-java/1.12.2");
        this.headers.put("User-Agent", Constants.USER_AGENT);
        this.headers.put("Content-Type", "application/json");
        Request request = null;
        if (this.config.plugins != null) {
            request = this.pluginRequestImp(requestUrl);
            this.headers.clear();
            Request finalRequest = request;
            request.headers().names().forEach(key -> this.headers.put((String)key, finalRequest.headers().get(key)));
            requestUrl = request.url().toString();
        }
        if ((response = this.service.getRequest(requestUrl, this.headers).execute()).isSuccessful()) {
            assert (response.body() != null);
            if (request != null) {
                response = this.pluginResponseImp(request, response);
            }
            this.responseJSON = new JSONObject(((ResponseBody)response.body()).string());
            if (this.config.livePreviewEntry != null && !this.config.livePreviewEntry.isEmpty()) {
                this.handleJSONArray();
            }
            this.connectionRequest.onRequestFinished(this);
        } else {
            assert (response.errorBody() != null);
            this.setError(response.errorBody().string());
        }
    }

    private Request pluginRequestImp(String requestUrl) {
        Call<ResponseBody> call = this.service.getRequest(requestUrl, this.headers);
        Request request = call.request();
        this.config.plugins.forEach(plugin -> plugin.onRequest(this.stackInstance, request));
        return request;
    }

    private Response<ResponseBody> pluginResponseImp(Request request, Response<ResponseBody> response) {
        this.config.plugins.forEach(plugin -> plugin.onResponse(this.stackInstance, request, response));
        return response;
    }

    void handleJSONArray() {
        JSONObject entry;
        if (this.responseJSON.has("entries") && !this.responseJSON.optJSONArray("entries").isEmpty()) {
            JSONArray finalEntries = this.responseJSON.optJSONArray("entries");
            IntStream.range(0, finalEntries.length()).forEach(idx -> {
                JSONObject objJSON = (JSONObject)finalEntries.get(idx);
                this.handleJSONObject(finalEntries, objJSON, idx);
            });
        }
        if (this.responseJSON.has("entry") && !this.responseJSON.optJSONObject("entry").isEmpty() && !(entry = this.responseJSON.optJSONObject("entry")).isEmpty() && entry.has("uid") && entry.opt("uid").equals(this.config.livePreviewEntry.opt("uid"))) {
            this.responseJSON = new JSONObject().put("entry", (Object)this.config.livePreviewEntry);
        }
    }

    void handleJSONObject(JSONArray arrayEntry, JSONObject jsonObj, int idx) {
        if (!jsonObj.isEmpty() && jsonObj.has("uid") && jsonObj.opt("uid").equals(this.config.livePreviewEntry.opt("uid"))) {
            arrayEntry.put(idx, (Object)this.config.livePreviewEntry);
        }
        this.responseJSON = new JSONObject().put("entries", (Object)arrayEntry);
    }

    void setError(String errResp) {
        logger.info(errResp);
        this.responseJSON = new JSONObject(errResp);
        this.responseJSON.put("error_message", (Object)this.responseJSON.optString("error_message"));
        this.responseJSON.put("error_code", (Object)this.responseJSON.optString("error_code"));
        this.responseJSON.put("errors", (Object)this.responseJSON.optString("errors"));
        int errCode = Integer.parseInt(this.responseJSON.optString("error_code"));
        this.connectionRequest.onRequestFailed(this.responseJSON, errCode, this.callBackObject);
    }

    public void setAPIService(APIService service) {
        this.service = service;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public void setStack(Stack stackInstance) {
        this.stackInstance = stackInstance;
    }
}

