/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import com.contentstack.sdk.Asset;
import com.contentstack.sdk.AssetLibrary;
import com.contentstack.sdk.CSConnectionRequest;
import com.contentstack.sdk.ContentType;
import com.contentstack.sdk.Entry;
import com.contentstack.sdk.Query;
import com.contentstack.sdk.ResultCallBack;
import com.contentstack.sdk.Stack;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

class CSBackgroundTask {
    protected CSBackgroundTask() {
    }

    protected CSBackgroundTask(Stack stackInstance, String controller, String url, HashMap<String, Object> headers, HashMap<String, Object> urlParams, String requestInfo, ResultCallBack callback) {
        this.checkHeader(headers);
        String completeUrl = stackInstance.config.getEndpoint() + url;
        CSConnectionRequest csConnectionRequest = new CSConnectionRequest(stackInstance);
        csConnectionRequest.setStackInstance(stackInstance);
        csConnectionRequest.setURLQueries(urlParams);
        csConnectionRequest.setParams(completeUrl, headers, controller, requestInfo, callback);
    }

    protected CSBackgroundTask(Query queryInstance, Stack stackInstance, String controller, String url, LinkedHashMap<String, Object> headers, HashMap<String, Object> urlQueries, String requestInfo, ResultCallBack callback) {
        this.checkHeader(headers);
        String completeUrl = stackInstance.config.getEndpoint() + url;
        CSConnectionRequest csConnectionRequest = new CSConnectionRequest(queryInstance);
        csConnectionRequest.setQueryInstance(queryInstance);
        csConnectionRequest.setURLQueries(urlQueries);
        csConnectionRequest.setParams(completeUrl, headers, controller, requestInfo, callback);
    }

    protected CSBackgroundTask(Entry entryInstance, Stack stackInstance, String controller, String url, LinkedHashMap<String, Object> headers, HashMap<String, Object> urlQueries, String requestInfo, ResultCallBack callBack) {
        this.checkHeader(headers);
        String completeUrl = stackInstance.config.getEndpoint() + url;
        CSConnectionRequest csConnectionRequest = new CSConnectionRequest(entryInstance);
        csConnectionRequest.setURLQueries(urlQueries);
        csConnectionRequest.setParams(completeUrl, headers, controller, requestInfo, callBack);
    }

    protected CSBackgroundTask(AssetLibrary assetLibrary, Stack stackInstance, String controller, String url, LinkedHashMap<String, Object> headers, HashMap<String, Object> urlQueries, String requestInfo, ResultCallBack callback) {
        this.checkHeader(headers);
        String completeUrl = stackInstance.config.getEndpoint() + url;
        CSConnectionRequest csConnectionRequest = new CSConnectionRequest(assetLibrary);
        csConnectionRequest.setURLQueries(urlQueries);
        csConnectionRequest.setParams(completeUrl, headers, controller, requestInfo, callback);
    }

    protected CSBackgroundTask(Asset asset, Stack stackInstance, String controller, String url, LinkedHashMap<String, Object> headers, HashMap<String, Object> urlQueries, String requestInfo, ResultCallBack callback) {
        this.checkHeader(headers);
        String completeUrl = stackInstance.config.getEndpoint() + url;
        CSConnectionRequest csConnectionRequest = new CSConnectionRequest(asset);
        csConnectionRequest.setURLQueries(urlQueries);
        csConnectionRequest.setParams(completeUrl, headers, controller, requestInfo, callback);
    }

    protected CSBackgroundTask(ContentType contentType, Stack stackInstance, String controller, String url, HashMap<String, Object> headers, HashMap<String, Object> urlParams, String requestInfo, ResultCallBack callback) {
        this.checkHeader(headers);
        String completeUrl = stackInstance.config.getEndpoint() + url;
        CSConnectionRequest csConnectionRequest = new CSConnectionRequest(contentType);
        csConnectionRequest.setURLQueries(urlParams);
        csConnectionRequest.setParams(completeUrl, headers, controller, requestInfo, callback);
    }

    protected void checkHeader(@NotNull Map<String, Object> headers) {
        Logger logger = Logger.getLogger("CSBackgroundTask");
        if (headers.size() == 0) {
            try {
                throw new IllegalAccessException("CSBackgroundTask Header Exception");
            }
            catch (IllegalAccessException e) {
                logger.severe(e.getLocalizedMessage());
            }
        }
    }
}

