/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import com.contentstack.sdk.Asset;
import com.contentstack.sdk.CSBackgroundTask;
import com.contentstack.sdk.Config;
import com.contentstack.sdk.Constants;
import com.contentstack.sdk.ContentType;
import com.contentstack.sdk.EntryModel;
import com.contentstack.sdk.EntryResultCallBack;
import com.contentstack.sdk.Error;
import com.contentstack.sdk.Group;
import com.contentstack.sdk.ResponseType;
import com.contentstack.sdk.ResultCallBack;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

public class Entry {
    protected static final Logger logger = Logger.getLogger(Entry.class.getSimpleName());
    protected JSONObject params;
    protected LinkedHashMap<String, Object> headers = null;
    protected HashMap<String, Object> owner = null;
    protected String uid = null;
    protected JSONObject publishDetails;
    protected JSONObject resultJson = null;
    protected String title = null;
    protected String url = null;
    protected String language = null;
    protected String contentTypeUid;
    protected ContentType contentType = null;
    protected String[] tags = null;
    protected JSONArray referenceArray;
    protected JSONArray objectUidForOnly;
    protected JSONArray exceptFieldArray;
    protected JSONObject onlyJsonObject;
    protected JSONObject exceptJsonObject;
    protected String rteContent = null;

    protected Entry() throws IllegalAccessException {
        throw new IllegalAccessException("Can Not Access Private Modifier");
    }

    protected Entry(String contentTypeName) {
        this.contentTypeUid = contentTypeName;
        this.params = new JSONObject();
    }

    protected void setContentType(@NotNull ContentType contentType, @NotNull LinkedHashMap<String, Object> header) {
        this.contentType = contentType;
        this.headers = header;
    }

    public Entry configure(JSONObject jsonObject) {
        EntryModel model = new EntryModel(jsonObject);
        this.resultJson = model.jsonObject;
        this.title = model.title;
        this.url = model.url;
        this.language = model.language;
        this.rteContent = model.rteContent;
        this.uid = model.uid;
        this.publishDetails = model.publishDetails;
        this.setTags(model.tags);
        return this;
    }

    public void setHeader(String key, String value) {
        if (!key.isEmpty() && !value.isEmpty()) {
            this.headers.put(key, value);
        }
    }

    public void removeHeader(String key) {
        if (!key.isEmpty()) {
            this.headers.remove(key);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getURL() {
        return this.url;
    }

    public String[] getTags() {
        return this.tags;
    }

    protected void setTags(String[] tags) {
        this.tags = tags;
    }

    public String getContentType() {
        return this.contentTypeUid;
    }

    public String getUid() {
        return this.uid;
    }

    protected void setUid(String uid) {
        this.uid = uid;
    }

    public String getLocale() {
        return this.language;
    }

    public Entry setLocale(@NotNull String locale) {
        this.params.put("locale", (Object)locale);
        return this;
    }

    @Deprecated
    public Map<String, Object> getOwner() {
        return this.owner;
    }

    public JSONObject toJSON() {
        return this.resultJson;
    }

    public Object get(@NotNull String key) {
        return this.resultJson.opt(key);
    }

    public String getString(@NotNull String key) {
        Object value = this.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public Boolean getBoolean(@NotNull String key) {
        Object value = this.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    public JSONArray getJSONArray(@NotNull String key) {
        Object value = this.get(key);
        if (value instanceof JSONArray) {
            return (JSONArray)value;
        }
        return null;
    }

    public JSONObject getJSONObject(@NotNull String key) {
        Object value = this.get(key);
        if (value instanceof JSONObject) {
            return (JSONObject)value;
        }
        return null;
    }

    public Number getNumber(@NotNull String key) {
        Object value = this.get(key);
        if (value instanceof Number) {
            return (Number)value;
        }
        return null;
    }

    public int getInt(@NotNull String key) {
        Number value = this.getNumber(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return 0;
    }

    public float getFloat(@NotNull String key) {
        Number value = this.getNumber(key);
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        return 0.0f;
    }

    public double getDouble(@NotNull String key) {
        Number value = this.getNumber(key);
        if (value != null) {
            return value.doubleValue();
        }
        return 0.0;
    }

    public long getLong(@NotNull String key) {
        Number value = this.getNumber(key);
        if (value != null) {
            return value.longValue();
        }
        return 0L;
    }

    public short getShort(@NotNull String key) {
        Number value = this.getNumber(key);
        if (value != null) {
            return value.shortValue();
        }
        return 0;
    }

    public Calendar getDate(@NotNull String key) {
        try {
            String value = this.getString(key);
            return Constants.parseDate(value, null);
        }
        catch (Exception e) {
            logger.severe(e.getLocalizedMessage());
            return null;
        }
    }

    public Calendar getCreateAt() {
        try {
            String value = this.getString("created_at");
            return Constants.parseDate(value, null);
        }
        catch (Exception e) {
            logger.severe(e.getLocalizedMessage());
            return null;
        }
    }

    public String getCreatedBy() {
        return this.getString("created_by");
    }

    public Calendar getUpdateAt() {
        try {
            String value = this.getString("updated_at");
            return Constants.parseDate(value, null);
        }
        catch (Exception e) {
            logger.severe(e.getLocalizedMessage());
            return null;
        }
    }

    public String getUpdatedBy() {
        return this.getString("updated_by");
    }

    public Calendar getDeleteAt() {
        try {
            String value = this.getString("deleted_at");
            return Constants.parseDate(value, null);
        }
        catch (Exception e) {
            logger.severe(e.getLocalizedMessage());
            return null;
        }
    }

    public String getDeletedBy() {
        return this.getString("deleted_by");
    }

    public Asset getAsset(String key) {
        JSONObject assetObject = this.getJSONObject(key);
        return this.contentType.stackInstance.asset().configure(assetObject);
    }

    public List<Asset> getAssets(String key) {
        ArrayList<Asset> assets = new ArrayList<Asset>();
        JSONArray assetArray = this.getJSONArray(key);
        assetArray.forEach(model -> {
            if (model instanceof JSONObject) {
                JSONObject newModel = (JSONObject)model;
                Asset asset = this.contentType.stackInstance.asset().configure(newModel);
                assets.add(asset);
            }
        });
        return assets;
    }

    public Group getGroup(String key) {
        if (!key.isEmpty() && this.resultJson.has(key) && this.resultJson.opt(key) instanceof JSONObject) {
            return new Group(this.contentType.stackInstance, this.resultJson.optJSONObject(key));
        }
        return null;
    }

    public List<Group> getGroups(String key) {
        ArrayList<Group> groupList = new ArrayList<Group>();
        if (!key.isEmpty() && this.resultJson.has(key) && this.resultJson.opt(key) instanceof JSONArray) {
            JSONArray array = this.resultJson.optJSONArray(key);
            array.forEach(model -> {
                JSONObject groupModel = (JSONObject)model;
                Group group = new Group(this.contentType.stackInstance, groupModel);
                groupList.add(group);
            });
        }
        return groupList;
    }

    public ArrayList<Entry> getAllEntries(String refKey, String refContentType) {
        Object resultArr;
        ArrayList<Entry> entryContainer = new ArrayList<Entry>();
        if (this.resultJson != null && (resultArr = this.resultJson.opt(refKey)) instanceof JSONArray) {
            JSONArray resultArrList = (JSONArray)resultArr;
            resultArrList.forEach(result -> {
                JSONObject newResult = (JSONObject)result;
                EntryModel model = new EntryModel(newResult);
                Entry entryInstance = null;
                try {
                    entryInstance = this.contentType.stackInstance.contentType(refContentType).entry();
                }
                catch (Exception e) {
                    entryInstance = new Entry(refContentType);
                    logger.severe(e.getLocalizedMessage());
                }
                entryInstance.setUid(model.uid);
                entryInstance.resultJson = model.jsonObject;
                entryInstance.setTags(model.tags);
                entryContainer.add(entryInstance);
            });
        }
        return entryContainer;
    }

    public Entry except(@NotNull String[] fieldUid) {
        if (fieldUid.length > 0) {
            if (this.exceptFieldArray == null) {
                this.exceptFieldArray = new JSONArray();
            }
            for (String s : fieldUid) {
                this.exceptFieldArray.put((Object)s);
            }
        }
        return this;
    }

    public Entry includeReference(@NotNull String referenceField) {
        if (!referenceField.isEmpty()) {
            if (this.referenceArray == null) {
                this.referenceArray = new JSONArray();
            }
            this.referenceArray.put((Object)referenceField);
            this.params.put("include[]", (Object)this.referenceArray);
        }
        return this;
    }

    public Entry includeReference(@NotNull String[] referenceFields) {
        if (referenceFields.length > 0) {
            if (this.referenceArray == null) {
                this.referenceArray = new JSONArray();
            }
            for (String field : referenceFields) {
                this.referenceArray.put((Object)field);
            }
            this.params.put("include[]", (Object)this.referenceArray);
        }
        return this;
    }

    public Entry only(String[] fieldUid) {
        if (fieldUid != null && fieldUid.length > 0) {
            if (this.objectUidForOnly == null) {
                this.objectUidForOnly = new JSONArray();
            }
            for (String field : fieldUid) {
                this.objectUidForOnly.put((Object)field);
            }
        }
        return this;
    }

    public Entry onlyWithReferenceUid(@NotNull ArrayList<String> fieldUid, @NotNull String referenceFieldUid) {
        if (this.onlyJsonObject == null) {
            this.onlyJsonObject = new JSONObject();
        }
        JSONArray fieldValueArray = new JSONArray();
        fieldUid.forEach(field -> fieldValueArray.put(field));
        this.onlyJsonObject.put(referenceFieldUid, (Object)fieldValueArray);
        this.includeReference(referenceFieldUid);
        return this;
    }

    public Entry exceptWithReferenceUid(@NotNull ArrayList<String> fieldUid, @NotNull String referenceFieldUid) {
        if (this.exceptJsonObject == null) {
            this.exceptJsonObject = new JSONObject();
        }
        JSONArray fieldValueArray = new JSONArray();
        fieldUid.forEach(field -> fieldValueArray.put(field));
        this.exceptJsonObject.put(referenceFieldUid, (Object)fieldValueArray);
        this.includeReference(referenceFieldUid);
        return this;
    }

    public void fetch(EntryResultCallBack callback) {
        if (this.uid.isEmpty()) {
            try {
                throw new IllegalAccessException("Entry Uid is required");
            }
            catch (IllegalAccessException e) {
                logger.severe(e.getLocalizedMessage());
            }
        }
        String urlString = "content_types/" + this.contentTypeUid + "/entries/" + this.uid;
        JSONObject urlQueries = new JSONObject();
        urlQueries.put("environment", this.headers.get("environment"));
        this.checkLivePreview(this.headers, urlQueries);
        this.fetchFromNetwork(urlString, urlQueries, callback);
    }

    private void fetchFromNetwork(String urlString, JSONObject urlQueries, EntryResultCallBack callBack) {
        try {
            JSONObject mainJson = new JSONObject();
            this.setIncludeJSON(urlQueries, callBack);
            mainJson.put("query", (Object)urlQueries);
            LinkedHashMap<String, Object> urlParams = this.getUrlParams(mainJson);
            new CSBackgroundTask(this, this.contentType.stackInstance, "getEntry", urlString, this.headers, urlParams, Constants.REQUEST_CONTROLLER.ENTRY.toString(), (ResultCallBack)callBack);
        }
        catch (Exception e) {
            this.throwException(null, e, callBack);
        }
    }

    private void checkLivePreview(LinkedHashMap<String, Object> headers, JSONObject urlQueries) {
        Config configInstance = this.contentType.stackInstance.config;
        if (configInstance.enableLivePreview && configInstance.livePreviewContentType.equalsIgnoreCase(this.contentTypeUid)) {
            configInstance.setHost(configInstance.livePreviewHost);
            headers.remove("access_token");
            headers.remove("environment");
            if (configInstance.livePreviewHash == null || configInstance.livePreviewHash.isEmpty()) {
                configInstance.livePreviewHash = "init";
            }
            headers.put("live_preview", configInstance.livePreviewHash);
            headers.put("authorization", configInstance.managementToken);
            urlQueries.remove("environment");
        }
    }

    private LinkedHashMap<String, Object> getUrlParams(JSONObject jsonMain) {
        JSONObject queryJSON = jsonMain.optJSONObject("query");
        LinkedHashMap<String, Object> hashMap = new LinkedHashMap<String, Object>();
        if (queryJSON != null && queryJSON.length() > 0) {
            Iterator iter = queryJSON.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Object value = queryJSON.opt(key);
                hashMap.put(key, value);
            }
        }
        return hashMap;
    }

    private void setIncludeJSON(JSONObject mainJson, ResultCallBack callBack) {
        try {
            Iterator iterator = this.params.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                Object value = this.params.get(key);
                mainJson.put(key, value);
            }
            if (this.objectUidForOnly != null && this.objectUidForOnly.length() > 0) {
                mainJson.put("only[BASE][]", (Object)this.objectUidForOnly);
                this.objectUidForOnly = null;
            }
            if (this.exceptFieldArray != null && this.exceptFieldArray.length() > 0) {
                mainJson.put("except[BASE][]", (Object)this.exceptFieldArray);
                this.exceptFieldArray = null;
            }
            if (this.exceptJsonObject != null && this.exceptJsonObject.length() > 0) {
                mainJson.put("except", (Object)this.exceptJsonObject);
                this.exceptJsonObject = null;
            }
            if (this.onlyJsonObject != null && this.onlyJsonObject.length() > 0) {
                mainJson.put("only", (Object)this.onlyJsonObject);
                this.onlyJsonObject = null;
            }
        }
        catch (Exception e) {
            this.throwException(null, e, (EntryResultCallBack)callBack);
        }
    }

    private void throwException(String errorMsg, Exception e, EntryResultCallBack callBack) {
        Error error = new Error();
        if (errorMsg != null) {
            error.setErrorMessage(errorMsg);
        } else {
            error.setErrorMessage(e.toString());
        }
        callBack.onRequestFail(ResponseType.UNKNOWN, error);
    }

    public Entry addParam(@NotNull String key, @NotNull String value) {
        this.params.put(key, (Object)value);
        return this;
    }

    public Entry includeReferenceContentTypeUID() {
        this.params.put("include_reference_content_type_uid", (Object)"true");
        return this;
    }

    public Entry includeContentType() {
        this.params.remove("include_schema");
        this.params.put("include_content_type", true);
        this.params.put("include_global_field_schema", true);
        return this;
    }

    public Entry includeFallback() {
        this.params.put("include_fallback", true);
        return this;
    }

    public Entry includeEmbeddedItems() {
        this.params.put("include_embedded_items[]", (Object)"BASE");
        return this;
    }

    public Entry includeBranch() {
        this.params.put("include_branch", true);
        return this;
    }
}

