/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import com.contentstack.sdk.Asset;
import com.contentstack.sdk.Constants;
import com.contentstack.sdk.Entry;
import com.contentstack.sdk.EntryModel;
import com.contentstack.sdk.Stack;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class Group {
    protected static final Logger logger = Logger.getLogger(Group.class.getSimpleName());
    private final JSONObject resultJson;
    private final Stack stackInstance;

    protected Group(Stack stack, JSONObject jsonObject) {
        this.resultJson = jsonObject;
        this.stackInstance = stack;
    }

    public JSONObject toJSON() {
        return this.resultJson;
    }

    public Object get(String key) {
        if (this.resultJson != null && key != null) {
            return this.resultJson.get(key);
        }
        return null;
    }

    public String getString(String key) {
        Object value = this.get(key);
        if (value != null) {
            return (String)value;
        }
        return null;
    }

    public Boolean getBoolean(String key) {
        Object value = this.get(key);
        if (value != null) {
            return (Boolean)value;
        }
        return false;
    }

    public JSONArray getJSONArray(String key) {
        Object value = this.get(key);
        if (value != null) {
            return (JSONArray)value;
        }
        return null;
    }

    public JSONObject getJSONObject(String key) {
        Object value = this.get(key);
        if (value != null) {
            return (JSONObject)value;
        }
        return null;
    }

    public Number getNumber(String key) {
        Object value = this.get(key);
        if (value != null) {
            return (Number)value;
        }
        return null;
    }

    public int getInt(String key) {
        Number value = this.getNumber(key);
        if (value != null) {
            return value.intValue();
        }
        return 0;
    }

    public float getFloat(String key) {
        Number value = this.getNumber(key);
        if (value != null) {
            return value.floatValue();
        }
        return 0.0f;
    }

    public double getDouble(String key) {
        Number value = this.getNumber(key);
        if (value != null) {
            return value.doubleValue();
        }
        return 0.0;
    }

    public long getLong(String key) {
        Number value = this.getNumber(key);
        if (value != null) {
            return value.longValue();
        }
        return 0L;
    }

    public short getShort(String key) {
        Number value = this.getNumber(key);
        if (value != null) {
            return value.shortValue();
        }
        return 0;
    }

    public Calendar getDate(String key) {
        try {
            String value = this.getString(key);
            return Constants.parseDate(value, null);
        }
        catch (Exception e) {
            logger.severe(e.getLocalizedMessage());
            return null;
        }
    }

    public Asset getAsset(String key) {
        JSONObject assetObject = this.getJSONObject(key);
        return this.stackInstance.asset().configure(assetObject);
    }

    public List<Asset> getAssets(String key) {
        ArrayList<Asset> assets = new ArrayList<Asset>();
        JSONArray assetArray = this.getJSONArray(key);
        for (int i = 0; i < assetArray.length(); ++i) {
            if (!(assetArray.opt(i) instanceof JSONObject)) continue;
            Asset asset = this.stackInstance.asset().configure(assetArray.optJSONObject(i));
            assets.add(asset);
        }
        return assets;
    }

    public Group getGroup(String key) {
        if (!key.isEmpty() && this.resultJson.has(key) && this.resultJson.opt(key) instanceof JSONObject) {
            return new Group(this.stackInstance, this.resultJson.optJSONObject(key));
        }
        return null;
    }

    public List<Group> getGroups(String key) {
        ArrayList<Group> groupList = new ArrayList<Group>();
        if (!key.isEmpty() && this.resultJson.has(key) && this.resultJson.opt(key) instanceof JSONArray) {
            JSONArray array = this.resultJson.optJSONArray(key);
            array.forEach(model -> {
                JSONObject newModel = (JSONObject)model;
                Group group = new Group(this.stackInstance, newModel);
                groupList.add(group);
            });
        }
        return groupList;
    }

    public ArrayList<Entry> getAllEntries(String refKey, String refContentType) {
        ArrayList<Entry> entryContainer;
        block5: {
            entryContainer = new ArrayList<Entry>();
            try {
                if (this.resultJson == null || !(this.resultJson.get(refKey) instanceof JSONArray)) break block5;
                int count = ((JSONArray)this.resultJson.get(refKey)).length();
                for (int i = 0; i < count; ++i) {
                    EntryModel model = new EntryModel(((JSONArray)this.resultJson.get(refKey)).getJSONObject(i));
                    Entry entryInstance = null;
                    try {
                        entryInstance = this.stackInstance.contentType(refContentType).entry();
                    }
                    catch (Exception e) {
                        entryInstance = new Entry(refContentType);
                        logger.severe(e.getLocalizedMessage());
                    }
                    entryInstance.setUid(model.uid);
                    entryInstance.resultJson = model.jsonObject;
                    entryInstance.setTags(model.tags);
                    entryContainer.add(entryInstance);
                }
                return entryContainer;
            }
            catch (Exception e) {
                logger.severe(e.getLocalizedMessage());
                return entryContainer;
            }
        }
        return entryContainer;
    }
}

