/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import com.contentstack.sdk.CSBackgroundTask;
import com.contentstack.sdk.Config;
import com.contentstack.sdk.Constants;
import com.contentstack.sdk.ContentType;
import com.contentstack.sdk.Entry;
import com.contentstack.sdk.EntryModel;
import com.contentstack.sdk.Error;
import com.contentstack.sdk.INotifyClass;
import com.contentstack.sdk.QueryResult;
import com.contentstack.sdk.QueryResultsCallBack;
import com.contentstack.sdk.ResponseType;
import com.contentstack.sdk.ResultCallBack;
import com.contentstack.sdk.SingleQueryResultCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

public class Query
implements INotifyClass {
    protected static final Logger logger = Logger.getLogger(Query.class.getSimpleName());
    protected ContentType contentTypeInstance = null;
    protected LinkedHashMap<String, Object> headers = null;
    protected JSONObject urlQueries;
    protected JSONObject mainJSON;
    protected String contentTypeUid;
    protected QueryResultsCallBack queryResultCallback;
    protected SingleQueryResultCallback singleQueryResultCallback;
    protected JSONObject queryValueJSON;
    protected JSONObject queryValue;
    protected JSONArray objectUidForInclude = null;
    protected JSONArray objectUidForExcept = null;
    protected JSONArray objectUidForOnly = null;
    private boolean isJsonProper = true;
    private String errorString;
    private JSONObject onlyJsonObject;
    private JSONObject exceptJsonObject;

    protected Query(String formName) {
        this.contentTypeUid = formName;
        this.urlQueries = new JSONObject();
        this.queryValue = new JSONObject();
        this.queryValueJSON = new JSONObject();
        this.mainJSON = new JSONObject();
    }

    protected void setContentTypeInstance(ContentType contentTypeInstance) {
        this.contentTypeInstance = contentTypeInstance;
    }

    public void setHeader(@NotNull String key, @NotNull String value) {
        if (!key.isEmpty() && !value.isEmpty()) {
            this.headers.put(key, value);
        }
    }

    public void removeHeader(@NotNull String key) {
        if (!key.isEmpty()) {
            this.headers.remove(key);
        }
    }

    public String getContentType() {
        return this.contentTypeInstance.contentTypeUid;
    }

    public Query where(@NotNull String key, Object value) {
        this.queryValueJSON.put(key, value);
        return this;
    }

    public Query addQuery(@NotNull String key, String value) {
        if (value != null) {
            this.urlQueries.put(key, (Object)value);
        }
        return this;
    }

    public Query removeQuery(@NotNull String key) {
        if (this.urlQueries.has(key)) {
            this.urlQueries.remove(key);
        }
        return this;
    }

    public Query and(@NotNull ArrayList<Query> queryObjects) {
        if (!queryObjects.isEmpty()) {
            JSONArray orValueJson = new JSONArray();
            queryObjects.forEach(obj -> orValueJson.put((Object)obj.queryValueJSON));
            this.queryValueJSON.put("$and", (Object)orValueJson);
        } else {
            this.throwException("and", "Can not process with blank query objects", null);
        }
        return this;
    }

    public Query or(ArrayList<Query> queryObjects) {
        if (queryObjects != null && !queryObjects.isEmpty()) {
            try {
                JSONArray orValueJson = new JSONArray();
                for (Query queryObject : queryObjects) {
                    orValueJson.put((Object)queryObject.queryValueJSON);
                }
                this.queryValueJSON.put("$or", (Object)orValueJson);
            }
            catch (Exception e) {
                this.throwException("or", "Please provide valid params.", e);
            }
        }
        return this;
    }

    public Query lessThan(@NotNull String key, @NotNull Object value) {
        if (this.queryValueJSON.isNull(key)) {
            if (this.queryValue.length() > 0) {
                this.queryValue = new JSONObject();
            }
            this.queryValue.put("$lt", value);
            this.queryValueJSON.put(key, (Object)this.queryValue);
        } else if (this.queryValueJSON.has(key)) {
            this.queryValue.put("$lt", value);
            this.queryValueJSON.put(key, (Object)this.queryValue);
        }
        return this;
    }

    public Query lessThanOrEqualTo(@NotNull String key, Object value) {
        if (this.queryValueJSON.isNull(key)) {
            if (this.queryValue.length() > 0) {
                this.queryValue = new JSONObject();
            }
            this.queryValue.put("$lte", value);
            this.queryValueJSON.put(key, (Object)this.queryValue);
        } else if (this.queryValueJSON.has(key)) {
            this.queryValue.put("$lte", value);
            this.queryValueJSON.put(key, (Object)this.queryValue);
        }
        return this;
    }

    public Query greaterThan(@NotNull String key, Object value) {
        if (this.queryValueJSON.isNull(key)) {
            if (this.queryValue.length() > 0) {
                this.queryValue = new JSONObject();
            }
            this.queryValue.put("$gt", value);
            this.queryValueJSON.put(key, (Object)this.queryValue);
        } else if (this.queryValueJSON.has(key)) {
            this.queryValue.put("$gt", value);
            this.queryValueJSON.put(key, (Object)this.queryValue);
        }
        return this;
    }

    public Query greaterThanOrEqualTo(String key, Object value) {
        if (this.queryValueJSON.isNull(key)) {
            if (this.queryValue.length() > 0) {
                this.queryValue = new JSONObject();
            }
            this.queryValue.put("$gte", value);
            this.queryValueJSON.put(key, (Object)this.queryValue);
        } else if (this.queryValueJSON.has(key)) {
            this.queryValue.put("$gte", value);
            this.queryValueJSON.put(key, (Object)this.queryValue);
        }
        return this;
    }

    public Query notEqualTo(@NotNull String key, Object value) {
        if (this.queryValueJSON.isNull(key)) {
            if (this.queryValue.length() > 0) {
                this.queryValue = new JSONObject();
            }
            this.queryValue.put("$ne", value);
            this.queryValueJSON.put(key, (Object)this.queryValue);
        } else if (this.queryValueJSON.has(key)) {
            this.queryValue.put("$ne", value);
            this.queryValueJSON.put(key, (Object)this.queryValue);
        }
        return this;
    }

    public Query containedIn(@NotNull String key, Object[] values) {
        JSONArray valuesArray = new JSONArray();
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            valuesArray.put(values[i]);
        }
        if (this.queryValueJSON.isNull(key)) {
            if (this.queryValue.length() > 0) {
                this.queryValue = new JSONObject();
            }
            this.queryValue.put("$in", (Object)valuesArray);
            this.queryValueJSON.put(key, (Object)this.queryValue);
        } else if (this.queryValueJSON.has(key)) {
            this.queryValue.put("$in", (Object)valuesArray);
            this.queryValueJSON.put(key, (Object)this.queryValue);
        }
        return this;
    }

    public Query notContainedIn(@NotNull String key, Object[] values) {
        JSONArray valuesArray = new JSONArray();
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            valuesArray.put(values[i]);
        }
        if (this.queryValueJSON.isNull(key)) {
            if (this.queryValue.length() > 0) {
                this.queryValue = new JSONObject();
            }
            this.queryValue.put("$nin", (Object)valuesArray);
            this.queryValueJSON.put(key, (Object)this.queryValue);
        } else if (this.queryValueJSON.has(key)) {
            this.queryValue.put("$nin", (Object)valuesArray);
            this.queryValueJSON.put(key, (Object)this.queryValue);
        }
        return this;
    }

    public Query exists(@NotNull String key) {
        if (this.queryValueJSON.isNull(key)) {
            if (this.queryValue.length() > 0) {
                this.queryValue = new JSONObject();
            }
            this.queryValue.put("$exists", true);
            this.queryValueJSON.put(key, (Object)this.queryValue);
        } else if (this.queryValueJSON.has(key)) {
            this.queryValue.put("$exists", true);
            this.queryValueJSON.put(key, (Object)this.queryValue);
        }
        return this;
    }

    public Query notExists(@NotNull String key) {
        if (this.queryValueJSON.isNull(key)) {
            if (this.queryValue.length() > 0) {
                this.queryValue = new JSONObject();
            }
            this.queryValue.put("$exists", false);
            this.queryValueJSON.put(key, (Object)this.queryValue);
        } else if (this.queryValueJSON.has(key)) {
            this.queryValue.put("$exists", false);
            this.queryValueJSON.put(key, (Object)this.queryValue);
        }
        return this;
    }

    public Query includeReference(String key) {
        if (this.objectUidForInclude == null) {
            this.objectUidForInclude = new JSONArray();
        }
        this.objectUidForInclude.put((Object)key);
        return this;
    }

    public Query tags(@NotNull String[] tags) {
        String tagsvalue = null;
        int count = tags.length;
        for (int i = 0; i < count; ++i) {
            tagsvalue = tagsvalue + "," + tags[i];
        }
        this.urlQueries.put("tags", tagsvalue);
        return this;
    }

    public Query ascending(@NotNull String key) {
        this.urlQueries.put("asc", (Object)key);
        return this;
    }

    public Query descending(@NotNull String key) {
        this.urlQueries.put("desc", (Object)key);
        return this;
    }

    public Query except(@NotNull ArrayList<String> fieldUid) {
        if (!fieldUid.isEmpty()) {
            if (this.objectUidForExcept == null) {
                this.objectUidForExcept = new JSONArray();
            }
            for (String s : fieldUid) {
                this.objectUidForExcept.put((Object)s);
            }
        }
        return this;
    }

    public Query except(@NotNull String[] fieldIds) {
        if (fieldIds.length > 0) {
            if (this.objectUidForExcept == null) {
                this.objectUidForExcept = new JSONArray();
            }
            for (String fieldId : fieldIds) {
                this.objectUidForExcept.put((Object)fieldId);
            }
        }
        return this;
    }

    public Query only(@NotNull String[] fieldUid) {
        if (fieldUid.length > 0) {
            if (this.objectUidForOnly == null) {
                this.objectUidForOnly = new JSONArray();
            }
            for (String s : fieldUid) {
                this.objectUidForOnly.put((Object)s);
            }
        }
        return this;
    }

    public Query onlyWithReferenceUid(@NotNull ArrayList<String> fieldUid, @NotNull String referenceFieldUid) {
        if (this.onlyJsonObject == null) {
            this.onlyJsonObject = new JSONObject();
        }
        JSONArray fieldValueArray = new JSONArray();
        for (String s : fieldUid) {
            fieldValueArray.put((Object)s);
        }
        this.onlyJsonObject.put(referenceFieldUid, (Object)fieldValueArray);
        if (this.objectUidForInclude == null) {
            this.objectUidForInclude = new JSONArray();
        }
        this.objectUidForInclude.put((Object)referenceFieldUid);
        return this;
    }

    public Query exceptWithReferenceUid(@NotNull ArrayList<String> fieldUid, @NotNull String referenceFieldUid) {
        if (this.exceptJsonObject == null) {
            this.exceptJsonObject = new JSONObject();
        }
        JSONArray fieldValueArray = new JSONArray();
        for (String s : fieldUid) {
            fieldValueArray.put((Object)s);
        }
        this.exceptJsonObject.put(referenceFieldUid, (Object)fieldValueArray);
        if (this.objectUidForInclude == null) {
            this.objectUidForInclude = new JSONArray();
        }
        this.objectUidForInclude.put((Object)referenceFieldUid);
        return this;
    }

    public Query count() {
        this.urlQueries.put("count", (Object)"true");
        return this;
    }

    public Query includeCount() {
        this.urlQueries.put("include_count", (Object)"true");
        return this;
    }

    public Query includeContentType() {
        if (this.urlQueries.has("include_schema")) {
            this.urlQueries.remove("include_schema");
        }
        this.urlQueries.put("include_content_type", true);
        this.urlQueries.put("include_global_field_schema", true);
        return this;
    }

    public Query includeOwner() {
        this.urlQueries.put("include_owner", true);
        return this;
    }

    public Query skip(int number) {
        this.urlQueries.put("skip", number);
        return this;
    }

    public Query limit(int number) {
        this.urlQueries.put("limit", number);
        return this;
    }

    public Query regex(@NotNull String key, @NotNull String regex) {
        if (this.queryValueJSON.isNull(key)) {
            if (!this.queryValue.isEmpty()) {
                this.queryValue = new JSONObject();
            }
            this.queryValue.put("$regex", (Object)regex);
            this.queryValueJSON.put(key, (Object)this.queryValue);
        } else if (this.queryValueJSON.has(key)) {
            this.queryValue.put("$regex", (Object)regex);
            this.queryValueJSON.put(key, (Object)this.queryValue);
        }
        return this;
    }

    public Query regex(@NotNull String key, @NotNull String regex, String modifiers) {
        try {
            if (this.queryValueJSON.isNull(key)) {
                if (this.queryValue.length() > 0) {
                    this.queryValue = new JSONObject();
                }
                this.queryValue.put("$regex", (Object)regex);
                if (modifiers != null) {
                    this.queryValue.put("$options", (Object)modifiers);
                }
                this.queryValueJSON.put(key, (Object)this.queryValue);
            } else if (this.queryValueJSON.has(key)) {
                this.queryValue.put("$regex", (Object)regex);
                if (modifiers != null) {
                    this.queryValue.put("$options", (Object)modifiers);
                }
                this.queryValueJSON.put(key, (Object)this.queryValue);
            }
        }
        catch (Exception e) {
            this.throwException("$options", "Please provide valid params.", e);
        }
        return this;
    }

    public Query locale(@NotNull String locale) {
        this.urlQueries.put("locale", (Object)locale);
        return this;
    }

    public Query search(@NotNull String value) {
        if (this.urlQueries.isNull(value)) {
            this.urlQueries.put("typeahead", (Object)value);
        }
        return this;
    }

    public Query find(QueryResultsCallBack callback) {
        Error error = null;
        if (this.isJsonProper) {
            if (!this.contentTypeUid.isEmpty()) {
                this.execQuery(null, callback);
            } else {
                this.throwException("find", "Please set contentType name.", null);
                error = new Error();
                error.setErrorMessage(this.errorString);
            }
        } else {
            error = new Error();
            error.setErrorMessage(this.errorString);
        }
        return this;
    }

    public Query findOne(SingleQueryResultCallback callBack) {
        if (this.isJsonProper) {
            if (!this.contentTypeUid.isEmpty()) {
                int limit = -1;
                if (this.urlQueries != null && this.urlQueries.has("limit")) {
                    limit = (Integer)this.urlQueries.get("limit");
                }
                if (this.urlQueries != null) {
                    this.urlQueries.put("limit", 1);
                    this.execQuery(callBack, null);
                    if (limit != -1) {
                        this.urlQueries.put("limit", limit);
                    }
                }
            } else {
                this.throwException("find", "Please set contentType name.", null);
            }
        }
        return this;
    }

    private void throwException(String queryName, String messageString, Exception e) {
        HashMap<String, String> errorHashMap = new HashMap<String, String>();
        this.isJsonProper = false;
        this.errorString = messageString;
        if (e != null) {
            errorHashMap.put(queryName, e.getLocalizedMessage());
        }
        errorHashMap.put("detail", messageString);
        logger.warning(messageString);
    }

    protected void setQueryJson() {
        if (this.queryValueJSON != null && this.queryValueJSON.length() > 0) {
            this.urlQueries.put("query", (Object)this.queryValueJSON);
        }
        if (this.objectUidForExcept != null && this.objectUidForExcept.length() > 0) {
            this.urlQueries.put("except[BASE][]", (Object)this.objectUidForExcept);
            this.objectUidForExcept = null;
        }
        if (this.objectUidForOnly != null && this.objectUidForOnly.length() > 0) {
            this.urlQueries.put("only[BASE][]", (Object)this.objectUidForOnly);
            this.objectUidForOnly = null;
        }
        if (this.onlyJsonObject != null && this.onlyJsonObject.length() > 0) {
            this.urlQueries.put("only", (Object)this.onlyJsonObject);
            this.onlyJsonObject = null;
        }
        if (this.exceptJsonObject != null && this.exceptJsonObject.length() > 0) {
            this.urlQueries.put("except", (Object)this.exceptJsonObject);
            this.exceptJsonObject = null;
        }
        if (this.objectUidForInclude != null && this.objectUidForInclude.length() > 0) {
            this.urlQueries.put("include[]", (Object)this.objectUidForInclude);
            this.objectUidForInclude = null;
        }
    }

    protected void execQuery(SingleQueryResultCallback callBack, QueryResultsCallBack callback) {
        try {
            String urlString = "content_types/" + this.contentTypeUid + "/entries";
            this.queryResultCallback = callback;
            this.singleQueryResultCallback = callBack;
            this.setQueryJson();
            this.urlQueries.put("environment", this.headers.get("environment"));
            this.includeLivePreview();
            this.mainJSON.put("query", (Object)this.urlQueries);
            this.fetchFromNetwork(urlString, this.mainJSON, callback, callBack);
        }
        catch (Exception e) {
            logger.severe(e.getLocalizedMessage());
            this.throwException("find", "Please provide valid params.", e);
        }
    }

    private void includeLivePreview() {
        Config configInstance = this.contentTypeInstance.stackInstance.config;
        if (configInstance.enableLivePreview && configInstance.livePreviewContentType.equalsIgnoreCase(this.contentTypeUid)) {
            configInstance.setHost(configInstance.livePreviewHost);
            this.headers.remove("access_token");
            this.urlQueries.remove("environment");
            this.headers.remove("environment");
            if (configInstance.livePreviewHash == null || configInstance.livePreviewHash.isEmpty()) {
                configInstance.livePreviewHash = "init";
            }
            this.headers.put("live_preview", configInstance.livePreviewHash);
            this.headers.put("authorization", configInstance.managementToken);
        }
    }

    private void fetchFromNetwork(String urlString, JSONObject jsonMain, ResultCallBack callback, SingleQueryResultCallback resultCallback) {
        LinkedHashMap<String, Object> urlParams = this.getUrlParams(jsonMain);
        if (resultCallback != null) {
            new CSBackgroundTask(this, this.contentTypeInstance.stackInstance, "getSingleQueryEntries", urlString, this.headers, urlParams, Constants.REQUEST_CONTROLLER.QUERY.toString(), (ResultCallBack)resultCallback);
        } else {
            new CSBackgroundTask(this, this.contentTypeInstance.stackInstance, "getQueryEntries", urlString, this.headers, urlParams, Constants.REQUEST_CONTROLLER.QUERY.toString(), callback);
        }
    }

    private LinkedHashMap<String, Object> getUrlParams(JSONObject jsonMain) {
        LinkedHashMap<String, Object> hashMap = new LinkedHashMap<String, Object>();
        JSONObject queryJSON = jsonMain.optJSONObject("query");
        if (queryJSON != null && queryJSON.length() > 0) {
            Iterator iter = queryJSON.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Object value = queryJSON.opt(key);
                hashMap.put(key, value);
            }
        }
        return hashMap;
    }

    @Override
    public void getResult(Object object, String controller) {
    }

    @Override
    public void getResultObject(List<Object> objects, JSONObject jsonObject, boolean isSingleEntry) {
        ArrayList<Entry> objectList = new ArrayList<Entry>();
        int countObject = objects.size();
        for (int i = 0; i < countObject; ++i) {
            Entry entry = null;
            try {
                entry = this.contentTypeInstance.stackInstance.contentType(this.contentTypeUid).entry(((EntryModel)objects.get((int)i)).uid);
            }
            catch (Exception e) {
                entry = new Entry(this.contentTypeUid);
            }
            entry.setUid(((EntryModel)objects.get((int)i)).uid);
            entry.resultJson = ((EntryModel)objects.get((int)i)).jsonObject;
            entry.title = ((EntryModel)objects.get((int)i)).title;
            entry.url = ((EntryModel)objects.get((int)i)).url;
            entry.setTags(((EntryModel)objects.get((int)i)).tags);
            objectList.add(entry);
        }
        if (isSingleEntry) {
            Entry entry = this.contentTypeInstance.entry();
            if (!objectList.isEmpty()) {
                entry = (Entry)objectList.get(0);
            }
            if (this.singleQueryResultCallback != null) {
                this.singleQueryResultCallback.onRequestFinish(ResponseType.NETWORK, entry);
            }
        } else {
            QueryResult queryResultObject = new QueryResult();
            queryResultObject.setJSON(jsonObject, objectList);
            if (this.queryResultCallback != null) {
                this.queryResultCallback.onRequestFinish(ResponseType.NETWORK, queryResultObject);
            }
        }
    }

    public Query addParam(@NotNull String paramKey, @NotNull String paramValue) {
        this.urlQueries.put(paramKey, (Object)paramValue);
        return this;
    }

    public Query includeReferenceContentTypUid() {
        this.urlQueries.put("include_reference_content_type_uid", (Object)"true");
        return this;
    }

    public Query whereIn(@NotNull String key, Query queryObject) {
        JSONObject inQueryObj = new JSONObject();
        inQueryObj.put("$in_query", (Object)queryObject.queryValueJSON.toString());
        this.queryValueJSON.put(key, (Object)inQueryObj);
        return this;
    }

    public Query whereNotIn(@NotNull String key, Query queryObject) {
        JSONObject inQueryObj = new JSONObject();
        inQueryObj.put("$nin_query", (Object)queryObject.queryValueJSON.toString());
        this.queryValueJSON.put(key, (Object)inQueryObj);
        return this;
    }

    public Query includeFallback() {
        this.urlQueries.put("include_fallback", true);
        return this;
    }

    public Query includeEmbeddedItems() {
        this.urlQueries.put("include_embedded_items[]", (Object)"BASE");
        return this;
    }

    public Query includeBranch() {
        this.urlQueries.put("include_branch", true);
        return this;
    }
}

