/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import com.contentstack.sdk.Asset;
import com.contentstack.sdk.AssetLibrary;
import com.contentstack.sdk.CSBackgroundTask;
import com.contentstack.sdk.Config;
import com.contentstack.sdk.Constants;
import com.contentstack.sdk.ContentType;
import com.contentstack.sdk.ContentTypesCallback;
import com.contentstack.sdk.SyncResultCallBack;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

public class Stack {
    private final Logger logger = Logger.getLogger(Stack.class.getSimpleName());
    protected LinkedHashMap<String, Object> headers;
    protected Config config;
    protected String contentType;
    protected String apiKey;
    protected JSONObject syncParams = null;

    protected Stack() throws IllegalAccessException {
        throw new IllegalAccessException("Can Not Access Private Modifier");
    }

    protected Stack(@NotNull String apiKey) {
        this.apiKey = apiKey;
        this.headers = new LinkedHashMap();
    }

    protected void setConfig(Config config) {
        this.config = config;
        String urlDomain = config.host;
        if (!config.region.name().isEmpty()) {
            String region = config.region.name().toLowerCase();
            if (region.equalsIgnoreCase("eu")) {
                if (urlDomain.equalsIgnoreCase("cdn.contentstack.io")) {
                    urlDomain = "cdn.contentstack.com";
                }
                config.host = region + "-" + urlDomain;
            } else if (region.equalsIgnoreCase("azure_na")) {
                if (urlDomain.equalsIgnoreCase("cdn.contentstack.io")) {
                    urlDomain = "cdn.contentstack.com";
                }
                config.host = "azure-na-" + urlDomain;
            }
        }
        this.includeLivePreview();
        String endpoint = config.scheme + config.host;
        this.config.setEndpoint(endpoint);
    }

    private void includeLivePreview() {
        try {
            if (this.config.enableLivePreview) {
                if (this.config.managementToken == null || this.config.managementToken.isEmpty()) {
                    throw new IllegalAccessException("managementToken is required");
                }
                if (this.config.livePreviewHost == null || this.config.livePreviewHost.isEmpty()) {
                    throw new IllegalAccessException("host is required");
                }
                this.config.host = this.config.livePreviewHost;
            }
        }
        catch (Exception e) {
            String info = "To enable live preview, managementToken and host are required";
            this.logger.warning(info);
            throw new IllegalArgumentException(e.getLocalizedMessage());
        }
    }

    public Stack livePreviewQuery(Map<String, String> query) {
        if (this.config.enableLivePreview) {
            this.config.livePreviewHash = query.get("live_preview");
            this.config.livePreviewContentType = query.get("content_type_uid");
        }
        return this;
    }

    public ContentType contentType(String contentTypeUid) {
        this.contentType = contentTypeUid;
        ContentType ct = new ContentType(contentTypeUid);
        ct.setStackInstance(this);
        return ct;
    }

    public Asset asset(@NotNull String uid) {
        Asset asset = new Asset(uid);
        asset.setStackInstance(this);
        return asset;
    }

    protected Asset asset() {
        Asset asset = new Asset();
        asset.setStackInstance(this);
        return asset;
    }

    public AssetLibrary assetLibrary() {
        AssetLibrary library = new AssetLibrary();
        library.setStackInstance(this);
        return library;
    }

    public String getApplicationKey() {
        return this.apiKey;
    }

    @Deprecated
    public String getAccessToken() {
        return (String)this.headers.get("access_token");
    }

    public String getDeliveryToken() {
        return (String)this.headers.get("access_token");
    }

    public void removeHeader(String headerKey) {
        this.headers.remove(headerKey);
    }

    public void setHeader(@NotNull String headerKey, @NotNull String headerValue) {
        if (!headerKey.isEmpty() && !headerValue.isEmpty()) {
            this.headers.put(headerKey, headerValue);
        }
    }

    public String imageTransform(@NotNull String imageUrl, @NotNull Map<String, Object> parameters) {
        if (parameters.size() == 0) {
            return imageUrl;
        }
        String query = this.getQueryParam(parameters);
        imageUrl = imageUrl.contains("?") ? imageUrl + "&" + query : imageUrl + "?" + query;
        return imageUrl;
    }

    protected String getQueryParam(Map<String, Object> params) {
        return params.entrySet().stream().map(e -> (String)e.getKey() + "=" + e.getValue()).collect(Collectors.joining("&"));
    }

    public void getContentTypes(@NotNull JSONObject params, ContentTypesCallback callback) {
        Iterator keys = params.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = params.opt(key);
            params.put(key, value);
        }
        if (this.headers.containsKey("environment")) {
            params.put("environment", this.headers.get("environment"));
            params.put("include_count", true);
        }
        this.fetchContentTypes("content_types", params, this.headers, callback);
    }

    public void sync(SyncResultCallBack syncCallBack) {
        this.syncParams = new JSONObject();
        this.syncParams.put("init", true);
        this.requestSync(syncCallBack);
    }

    public void syncPaginationToken(@NotNull String paginationToken, SyncResultCallBack syncCallBack) {
        this.sync(null);
        this.syncParams.put("pagination_token", (Object)paginationToken);
        this.requestSync(syncCallBack);
    }

    public void syncToken(String syncToken, SyncResultCallBack syncCallBack) {
        this.sync(null);
        this.syncParams.put("sync_token", (Object)syncToken);
        this.requestSync(syncCallBack);
    }

    public void syncFromDate(@NotNull Date fromDate, SyncResultCallBack syncCallBack) {
        String newFromDate = this.convertUTCToISO(fromDate);
        this.sync(null);
        this.syncParams.put("start_from", (Object)newFromDate);
        this.requestSync(syncCallBack);
    }

    protected String convertUTCToISO(Date date) {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
        dateFormat.setTimeZone(tz);
        return dateFormat.format(date);
    }

    public void syncContentType(@NotNull String contentType, SyncResultCallBack syncCallBack) {
        this.sync(null);
        this.syncParams.put("content_type_uid", (Object)contentType);
        this.requestSync(syncCallBack);
    }

    public void syncLocale(String localeCode, SyncResultCallBack syncCallBack) {
        this.sync(null);
        this.syncParams.put("locale", (Object)localeCode);
        this.requestSync(syncCallBack);
    }

    public void syncPublishType(PublishType publishType, SyncResultCallBack syncCallBack) {
        this.sync(null);
        this.syncParams.put("type", (Object)publishType.name());
        this.requestSync(syncCallBack);
    }

    public void sync(String contentType, Date fromDate, String localeCode, PublishType publishType, SyncResultCallBack syncCallBack) {
        String newDate = this.convertUTCToISO(fromDate);
        this.sync(null);
        this.syncParams.put("start_from", (Object)newDate);
        this.syncParams.put("content_type_uid", (Object)contentType);
        this.syncParams.put("type", (Object)publishType.name());
        this.syncParams.put("locale", (Object)localeCode);
        this.requestSync(syncCallBack);
    }

    private void requestSync(SyncResultCallBack callback) {
        if (this.headers.containsKey("environment")) {
            this.syncParams.put("environment", this.headers.get("environment"));
        }
        this.fetchFromNetwork("stacks/sync", this.syncParams, this.headers, callback);
    }

    private void fetchContentTypes(String urlString, JSONObject contentTypeParam, HashMap<String, Object> headers, ContentTypesCallback callback) {
        if (callback != null) {
            HashMap<String, Object> queryParam = this.getUrlParams(contentTypeParam);
            String requestInfo = Constants.REQUEST_CONTROLLER.CONTENTTYPES.toString();
            new CSBackgroundTask(this, "getContentTypes", urlString, headers, queryParam, requestInfo, callback);
        }
    }

    private void fetchFromNetwork(String urlString, JSONObject urlQueries, HashMap<String, Object> headers, SyncResultCallBack callback) {
        if (callback != null) {
            HashMap<String, Object> urlParams = this.getUrlParams(urlQueries);
            String requestInfo = Constants.REQUEST_CONTROLLER.SYNC.toString();
            new CSBackgroundTask(this, "getSync", urlString, headers, urlParams, requestInfo, callback);
        }
    }

    private HashMap<String, Object> getUrlParams(JSONObject jsonQuery) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (jsonQuery != null && jsonQuery.length() > 0) {
            Iterator iteString = jsonQuery.keys();
            while (iteString.hasNext()) {
                String key = (String)iteString.next();
                Object value = jsonQuery.opt(key);
                hashMap.put(key, value);
            }
        }
        return hashMap;
    }

    public static enum PublishType {
        asset_deleted,
        asset_published,
        asset_unpublished,
        content_type_deleted,
        entry_deleted,
        entry_published,
        entry_unpublished;

    }
}

