/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import com.contentstack.sdk.Config;
import com.contentstack.sdk.Stack;
import java.util.Objects;

public class Contentstack {
    protected Contentstack() throws IllegalAccessException {
        throw new IllegalAccessException("Can Not Access Private Modifier");
    }

    public static Stack stack(String stackApiKey, String deliveryToken, String environment) throws IllegalAccessException {
        Contentstack.validateCredentials(stackApiKey, deliveryToken, environment);
        Config config = new Config();
        return Contentstack.initializeStack(stackApiKey, deliveryToken, environment, config);
    }

    public static Stack stack(String stackApiKey, String deliveryToken, String environment, Config config) throws IllegalAccessException {
        Contentstack.validateCredentials(stackApiKey, deliveryToken, environment);
        return Contentstack.initializeStack(stackApiKey, deliveryToken, environment, config);
    }

    private static void validateCredentials(String stackApiKey, String deliveryToken, String environment) throws IllegalAccessException {
        Objects.requireNonNull(stackApiKey, "API Key can not be null");
        Objects.requireNonNull(deliveryToken, "Delivery Token can not be null");
        Objects.requireNonNull(environment, "Environment can not be null");
        if (stackApiKey.isEmpty()) {
            throw new IllegalAccessException("API Key can not be empty");
        }
        if (deliveryToken.isEmpty()) {
            throw new IllegalAccessException("Delivery Token can not be empty");
        }
        if (environment.isEmpty()) {
            throw new IllegalAccessException("Environment can not be empty");
        }
    }

    private static Stack initializeStack(String stackApiKey, String deliveryToken, String environment, Config config) {
        Stack stack = new Stack(stackApiKey.trim());
        stack.setHeader("api_key", stackApiKey);
        stack.setHeader("access_token", deliveryToken);
        stack.setHeader("environment", environment);
        if (config.getBranch() != null && !config.getBranch().isEmpty()) {
            stack.setHeader("branch", config.getBranch());
        }
        if (config.getEarlyAccess() != null && config.getEarlyAccess().length > 0) {
            String eaValues = String.join((CharSequence)",", config.earlyAccess).replace("\"", "");
            stack.setHeader("x-header-ea", eaValues);
        }
        stack.setConfig(config);
        return stack;
    }
}

