/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import com.slack.api.bolt.App;
import com.slack.api.methods.SlackApiException;
import com.slack.api.methods.response.chat.ChatPostMessageResponse;
import com.slack.api.methods.response.files.FilesUploadV2Response;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class SanityReport {
    private static final String PROPERTIES_FILE = "src/test/resources/.env";

    public void generateTestSummaryAndSendToSlack(File reportFile) throws IOException, SlackApiException {
        Properties properties = this.loadProperties(PROPERTIES_FILE);
        String slackToken = properties.getProperty("SLACK_BOT_TOKEN");
        String slackChannelID = properties.getProperty("SLACK_CHANNEL_ID");
        String signingSecret = properties.getProperty("SLACK_SIGNING_SECRET");
        String slackChannel = properties.getProperty("SLACK_CHANNEL");
        if (slackToken == null || slackChannelID == null) {
            System.err.println("Missing Slack credentials in properties.");
            return;
        }
        if (!reportFile.exists()) {
            System.err.println("Surefire report file not found at: " + reportFile.getAbsolutePath());
            return;
        }
        String message = this.generateTestSummary(reportFile);
        App app = this.configureSlackApp(slackToken, signingSecret);
        this.sendMessageToSlack(app, slackChannel, message);
        this.uploadReportToSlack(app, slackChannelID, reportFile);
    }

    private Properties loadProperties(String filePath) {
        Properties properties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(filePath);){
            properties.load(inputStream);
        }
        catch (IOException e) {
            System.err.println("Failed to load properties: " + e.getMessage());
        }
        return properties;
    }

    private App configureSlackApp(String token, String secret) {
        App app = new App();
        app.config().setSigningSecret(secret);
        app.config().setSingleTeamBotToken(token);
        return app;
    }

    private void sendMessageToSlack(App app, String channel, String message) throws IOException, SlackApiException {
        ChatPostMessageResponse response = app.client().chatPostMessage(r -> r.channel(channel).text(message));
        if (response.isOk()) {
            System.out.println("Message sent successfully!");
        } else {
            System.err.println("Failed to send message: " + response.getError());
        }
    }

    private void uploadReportToSlack(App app, String channelID, File file) throws IOException, SlackApiException {
        FilesUploadV2Response response = app.client().filesUploadV2(fuvr -> fuvr.channel(channelID).initialComment("Here is the report generated").filename(file.getName()).file(file));
        if (response.isOk()) {
            System.out.println("Report uploaded successfully!");
        } else {
            System.err.println("Failed to upload report: " + response.getError());
        }
    }

    private String generateTestSummary(File surefireReportFile) throws IOException {
        Elements cells;
        Document doc = Jsoup.parse((File)surefireReportFile, (String)"UTF-8");
        Elements summaryRows = doc.select("table.table tr.b");
        Element summaryRow = summaryRows.first();
        int totalTests = 0;
        int errors = 0;
        int failures = 0;
        int skipped = 0;
        int failedSuites = 0;
        String duration = "0m 0s";
        if (summaryRow != null && (cells = summaryRow.select("td")).size() >= 6) {
            totalTests = Integer.parseInt(((Element)cells.get(0)).text());
            errors = Integer.parseInt(((Element)cells.get(1)).text());
            failures = Integer.parseInt(((Element)cells.get(2)).text());
            skipped = Integer.parseInt(((Element)cells.get(3)).text());
            String timeText = ((Element)cells.get(5)).text();
            if (timeText.contains("s")) {
                double seconds = Double.parseDouble(timeText.replace(" s", ""));
                duration = (int)seconds / 60 + "m " + (int)seconds % 60 + "s";
            }
        }
        Elements testSuiteRows = doc.select("table:contains(Class) tr");
        int totalSuites = testSuiteRows.size() - 1;
        for (Element row : testSuiteRows) {
            Elements errorCells = row.select("td:nth-child(4)");
            Elements failureCells = row.select("td:nth-child(5)");
            if (errorCells.isEmpty() || failureCells.isEmpty()) continue;
            try {
                if (Integer.parseInt(errorCells.text()) <= 0 && Integer.parseInt(failureCells.text()) <= 0) continue;
                ++failedSuites;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        int passedTests = totalTests - failures - errors - skipped;
        return "*Java CDA Test Report*\n\u2022 Total Suites: " + totalSuites + "\n\u2022 Total Tests: " + totalTests + "\n\u2022 Passed Tests: " + passedTests + "\n\u2022 Failed Suites: " + failedSuites + "\n\u2022 Failed Tests: " + failures + "\n\u2022 Skipped Tests: " + skipped + "\n\u2022 Duration: " + duration;
    }

    public static void main(String[] args) {
        File reportFile = new File("target/reports/surefire.html");
        try {
            new SanityReport().generateTestSummaryAndSendToSlack(reportFile);
        }
        catch (SlackApiException | IOException e) {
            System.err.println("Error: " + e.getMessage());
        }
    }
}

