/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import com.contentstack.sdk.Asset;
import com.contentstack.sdk.AssetModel;
import com.contentstack.sdk.CSBackgroundTask;
import com.contentstack.sdk.Constants;
import com.contentstack.sdk.FetchAssetsCallback;
import com.contentstack.sdk.INotifyClass;
import com.contentstack.sdk.ResponseType;
import com.contentstack.sdk.ResultCallBack;
import com.contentstack.sdk.Stack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

public class AssetLibrary
implements INotifyClass {
    protected static final Logger logger = Logger.getLogger(AssetLibrary.class.getSimpleName());
    protected final JSONObject urlQueries = new JSONObject();
    protected Stack stackInstance;
    protected LinkedHashMap<String, Object> headers;
    protected FetchAssetsCallback callback;
    protected int count;

    protected AssetLibrary() {
    }

    protected void setStackInstance(@NotNull Stack stack) {
        this.stackInstance = stack;
        this.headers = stack.headers;
    }

    private boolean isValidKey(String key) {
        return key.matches("^[a-zA-Z0-9_.]+(\\[\\])?$");
    }

    private boolean isValidValue(Object value) {
        if (value instanceof String) {
            return ((String)value).matches("^[a-zA-Z0-9_.\\-\\s]+$");
        }
        return true;
    }

    private boolean isValidValueList(Object[] values) {
        for (Object value : values) {
            if (!(value instanceof String) || ((String)value).matches("^[a-zA-Z0-9_.\\-\\s]+$")) continue;
            return false;
        }
        return true;
    }

    public void setHeader(@NotNull String headerKey, @NotNull String headerValue) {
        this.headers.put(headerKey, headerValue);
    }

    public void removeHeader(@NotNull String headerKey) {
        if (!headerKey.isEmpty()) {
            this.headers.remove(headerKey);
        }
    }

    public AssetLibrary sort(String keyOrderBy, ORDERBY orderby) {
        if (orderby == ORDERBY.ASCENDING) {
            this.urlQueries.put("asc", (Object)keyOrderBy);
        } else {
            this.urlQueries.put("desc", (Object)keyOrderBy);
        }
        return this;
    }

    public AssetLibrary includeCount() {
        this.urlQueries.put("include_count", (Object)"true");
        return this;
    }

    public AssetLibrary includeRelativeUrl() {
        this.urlQueries.put("relative_urls", (Object)"true");
        return this;
    }

    public AssetLibrary includeFallback() {
        this.urlQueries.put("include_fallback", true);
        return this;
    }

    public AssetLibrary includeMetadata() {
        this.urlQueries.put("include_metadata", true);
        return this;
    }

    public int getCount() {
        return this.count;
    }

    public AssetLibrary addParam(@NotNull String paramKey, @NotNull Object paramValue) {
        if (this.isValidKey(paramKey) && this.isValidValue(paramValue)) {
            this.urlQueries.put(paramKey, paramValue);
        } else if (!this.isValidKey(paramKey)) {
            logger.warning("Invalid parameter key. Use only alphanumeric characters, underscores, and dots.");
        } else {
            logger.warning("Invalid parameter value. Remove unsupported characters and try again.");
        }
        return this;
    }

    public AssetLibrary removeParam(@NotNull String paramKey) {
        if (this.isValidKey(paramKey)) {
            if (this.urlQueries.has(paramKey)) {
                this.urlQueries.remove(paramKey);
            }
        } else {
            logger.warning("Invalid key");
        }
        return this;
    }

    public AssetLibrary skip(@NotNull int number) {
        this.urlQueries.put("skip", number);
        return this;
    }

    public AssetLibrary limit(@NotNull int number) {
        this.urlQueries.put("limit", number);
        return this;
    }

    public AssetLibrary assetFields(String ... fields) {
        if (fields != null && fields.length > 0) {
            JSONArray array = new JSONArray();
            for (String field : fields) {
                array.put((Object)field);
            }
            if (!array.isEmpty()) {
                this.urlQueries.put("asset_fields[]", (Object)array);
            }
        }
        return this;
    }

    public void fetchAll(FetchAssetsCallback callback) {
        this.callback = callback;
        this.urlQueries.put("environment", this.headers.get("environment"));
        this.fetchFromNetwork("assets", this.urlQueries, this.headers, callback);
    }

    private void fetchFromNetwork(String url, JSONObject urlQueries, LinkedHashMap<String, Object> headers, FetchAssetsCallback callback) {
        if (callback != null) {
            HashMap<String, Object> urlParams = this.getUrlParams(urlQueries);
            new CSBackgroundTask(this, this.stackInstance, "getAllAssets", url, headers, urlParams, Constants.REQUEST_CONTROLLER.ASSETLIBRARY.toString(), (ResultCallBack)callback);
        }
    }

    private HashMap<String, Object> getUrlParams(JSONObject urlQueriesJSON) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (urlQueriesJSON != null && urlQueriesJSON.length() > 0) {
            Iterator iter = urlQueriesJSON.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Object value = urlQueriesJSON.opt(key);
                if (!this.isValidKey(key) || !this.isValidValue(value)) continue;
                hashMap.put(key, value);
            }
        }
        return hashMap;
    }

    @Override
    public void getResult(Object object, String controller) {
        logger.warning("No implementation required");
    }

    @Override
    public void getResultObject(List<Object> objects, JSONObject jsonObject, boolean isSingleEntry) {
        if (jsonObject != null && jsonObject.has("count")) {
            this.count = jsonObject.optInt("count");
        }
        ArrayList<Asset> assets = new ArrayList<Asset>();
        if (objects == null || objects.isEmpty()) {
            logger.warning("Missing assets list. Provide a valid list of assets and try again.");
            return;
        }
        if (objects != null && !objects.isEmpty()) {
            for (Object object : objects) {
                AssetModel model = (AssetModel)object;
                Asset asset = this.stackInstance.asset();
                asset.contentType = model.contentType;
                asset.fileSize = model.fileSize;
                asset.uploadUrl = model.uploadUrl;
                asset.fileName = model.fileName;
                asset.json = model.json;
                asset.assetUid = model.uploadedUid;
                asset.setTags(model.tags);
                assets.add(asset);
            }
        } else {
            logger.warning("Invalid object type. Use an AssetModel object and try again.");
        }
        if (this.callback != null) {
            this.callback.onRequestFinish(ResponseType.NETWORK, assets);
        }
    }

    public AssetLibrary where(String key, String value) {
        if (!this.isValidKey(key) || !this.isValidValue(value)) {
            if (!this.isValidKey(key)) {
                throw new IllegalArgumentException("Invalid parameter key. Use only alphanumeric characters, underscores, and dots.");
            }
            throw new IllegalArgumentException("Invalid parameter value. Remove unsupported characters and try again.");
        }
        JSONObject queryParams = new JSONObject();
        queryParams.put(key, (Object)value);
        this.urlQueries.put("query", (Object)queryParams);
        return this;
    }

    public static enum ORDERBY {
        ASCENDING,
        DESCENDING;

    }
}

