/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import com.contentstack.sdk.Config;
import com.contentstack.sdk.Stack;
import java.util.Objects;

public class Contentstack {
    protected Contentstack() throws IllegalAccessException {
        throw new IllegalAccessException("Direct instantiation of Stack is not allowed. Use Contentstack.stack() to create an instance.");
    }

    public static Stack stack(String stackApiKey, String deliveryToken, String environment) throws IllegalAccessException {
        Contentstack.validateCredentials(stackApiKey, deliveryToken, environment);
        Config config = new Config();
        return Contentstack.initializeStack(stackApiKey, deliveryToken, environment, config);
    }

    public static Stack stack(String stackApiKey, String deliveryToken, String environment, Config config) throws IllegalAccessException {
        Contentstack.validateCredentials(stackApiKey, deliveryToken, environment);
        return Contentstack.initializeStack(stackApiKey, deliveryToken, environment, config);
    }

    private static void validateCredentials(String stackApiKey, String deliveryToken, String environment) throws IllegalAccessException {
        Objects.requireNonNull(stackApiKey, "API Key can not be null");
        Objects.requireNonNull(deliveryToken, "Delivery Token can not be null");
        Objects.requireNonNull(environment, "Environment can not be null");
        if (stackApiKey.isEmpty()) {
            throw new IllegalAccessException("Missing API key. Provide a valid key from your Contentstack stack settings and try again.");
        }
        if (deliveryToken.isEmpty()) {
            throw new IllegalAccessException("Missing delivery token. Provide a valid token from your Contentstack stack settings and try again.");
        }
        if (environment.isEmpty()) {
            throw new IllegalAccessException("Missing environment. Provide a valid environment name and try again.");
        }
    }

    private static Stack initializeStack(String stackApiKey, String deliveryToken, String environment, Config config) {
        Stack stack = new Stack(stackApiKey.trim());
        stack.setHeader("api_key", stackApiKey);
        stack.setHeader("access_token", deliveryToken);
        stack.setHeader("environment", environment);
        if (config.getBranch() != null && !config.getBranch().isEmpty()) {
            stack.setHeader("branch", config.getBranch());
        }
        if (config.getEarlyAccess() != null && config.getEarlyAccess().length > 0) {
            String eaValues = String.join((CharSequence)",", config.earlyAccess).replace("\"", "");
            stack.setHeader("x-header-ea", eaValues);
        }
        stack.setConfig(config);
        return stack;
    }
}

