/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import com.contentstack.sdk.RetryOptions;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Logger;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class RetryInterceptor
implements Interceptor {
    private static final Logger logger = Logger.getLogger(RetryInterceptor.class.getName());
    private final RetryOptions retryOptions;

    public RetryInterceptor(RetryOptions retryOptions) {
        if (retryOptions == null) {
            throw new NullPointerException("RetryOptions cannot be null");
        }
        this.retryOptions = retryOptions;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Response response = null;
        IOException lastException = null;
        if (!this.retryOptions.isRetryEnabled()) {
            return chain.proceed(request);
        }
        int attempt = 0;
        int maxAttempts = this.retryOptions.getRetryLimit() + 1;
        while (attempt < maxAttempts) {
            try {
                if (response != null) {
                    response.close();
                }
                if (this.shouldRetry((response = chain.proceed(request)).code()) && attempt + 1 < maxAttempts) {
                    logger.fine("Retry attempt " + (attempt + 1) + " for status " + response.code() + " on " + request.url());
                    long delay = this.calculateDelay(attempt, response.code(), null);
                    Thread.sleep(delay);
                    ++attempt;
                    continue;
                }
                return response;
            }
            catch (IOException e) {
                lastException = e;
                if (attempt + 1 < maxAttempts) {
                    try {
                        long delay = this.calculateDelay(attempt, -1, e);
                        Thread.sleep(delay);
                        ++attempt;
                        continue;
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        throw new IOException("Retry interrupted", ie);
                    }
                }
                throw e;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (response != null) {
                    response.close();
                }
                throw new IOException("Retry interrupted", e);
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        return response;
    }

    private boolean shouldRetry(int statusCode) {
        return Arrays.stream(this.retryOptions.getRetryableStatusCodes()).anyMatch(code -> code == statusCode);
    }

    private long calculateDelay(int attempt, int statusCode, IOException exception) {
        if (this.retryOptions.hasCustomBackoff()) {
            return this.retryOptions.getCustomBackoffStrategy().calculateDelay(attempt, statusCode, exception);
        }
        long baseDelay = this.retryOptions.getRetryDelay();
        switch (this.retryOptions.getBackoffStrategy()) {
            case FIXED: {
                break;
            }
            case LINEAR: {
                baseDelay = this.retryOptions.getRetryDelay() * (long)(attempt + 1);
                break;
            }
            case EXPONENTIAL: {
                baseDelay = (long)((double)this.retryOptions.getRetryDelay() * Math.pow(2.0, attempt));
                break;
            }
        }
        return baseDelay;
    }
}

