/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import com.contentstack.sdk.CustomBackoffStrategy;
import java.util.Arrays;
import java.util.Objects;

public class RetryOptions {
    private static final int DEFAULT_RETRY_LIMIT = 3;
    private static final long DEFAULT_RETRY_DELAY_MS = 1000L;
    private static final int MAX_RETRY_LIMIT = 10;
    private static final int[] DEFAULT_RETRYABLE_STATUS_CODES = new int[]{408, 429, 502, 503, 504};
    private int retryLimit = 3;
    private long retryDelayMs = 1000L;
    private BackoffStrategy backoffStrategy = BackoffStrategy.EXPONENTIAL;
    private int[] retryableStatusCodes = (int[])DEFAULT_RETRYABLE_STATUS_CODES.clone();
    private boolean retryEnabled = true;
    private CustomBackoffStrategy customBackoffStrategy = null;

    public RetryOptions setRetryLimit(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("Retry limit cannot be negative. Provided: " + limit);
        }
        if (limit > 10) {
            throw new IllegalArgumentException("Retry limit cannot exceed 10. Provided: " + limit);
        }
        this.retryLimit = limit;
        return this;
    }

    public RetryOptions setRetryDelay(long delayMs) {
        if (delayMs < 0L) {
            throw new IllegalArgumentException("Retry delay cannot be negative. Provided: " + delayMs);
        }
        this.retryDelayMs = delayMs;
        return this;
    }

    public RetryOptions setBackoffStrategy(BackoffStrategy strategy) {
        this.backoffStrategy = Objects.requireNonNull(strategy, "Backoff strategy cannot be null");
        return this;
    }

    public RetryOptions setRetryableStatusCodes(int ... codes) {
        if (codes == null || codes.length == 0) {
            this.retryableStatusCodes = new int[0];
            return this;
        }
        for (int code : codes) {
            if (code >= 100 && code <= 599) continue;
            throw new IllegalArgumentException("Invalid HTTP status code: " + code + ". Must be between 100 and 599.");
        }
        this.retryableStatusCodes = (int[])codes.clone();
        return this;
    }

    public RetryOptions setRetryEnabled(boolean enabled) {
        this.retryEnabled = enabled;
        return this;
    }

    public RetryOptions setCustomBackoffStrategy(CustomBackoffStrategy customStrategy) {
        this.customBackoffStrategy = Objects.requireNonNull(customStrategy, "Custom backoff strategy cannot be null");
        this.backoffStrategy = BackoffStrategy.CUSTOM;
        return this;
    }

    public CustomBackoffStrategy getCustomBackoffStrategy() {
        return this.customBackoffStrategy;
    }

    public boolean hasCustomBackoff() {
        return this.customBackoffStrategy != null;
    }

    public int getRetryLimit() {
        return this.retryLimit;
    }

    public long getRetryDelay() {
        return this.retryDelayMs;
    }

    public BackoffStrategy getBackoffStrategy() {
        return this.backoffStrategy;
    }

    public int[] getRetryableStatusCodes() {
        return (int[])this.retryableStatusCodes.clone();
    }

    public boolean isRetryEnabled() {
        return this.retryEnabled;
    }

    public String toString() {
        return "RetryOptions{enabled=" + this.retryEnabled + ", limit=" + this.retryLimit + ", delay=" + this.retryDelayMs + "ms, strategy=" + (Object)((Object)this.backoffStrategy) + ", retryableCodes=" + Arrays.toString(this.retryableStatusCodes) + '}';
    }

    public static enum BackoffStrategy {
        FIXED,
        LINEAR,
        EXPONENTIAL,
        CUSTOM;

    }
}

