/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.AccountStorageCredentialsImpl;
import com.databricks.sdk.service.catalog.AccountStorageCredentialsService;
import com.databricks.sdk.service.catalog.AccountsCreateStorageCredential;
import com.databricks.sdk.service.catalog.AccountsStorageCredentialInfo;
import com.databricks.sdk.service.catalog.AccountsUpdateStorageCredential;
import com.databricks.sdk.service.catalog.DeleteAccountStorageCredentialRequest;
import com.databricks.sdk.service.catalog.GetAccountStorageCredentialRequest;
import com.databricks.sdk.service.catalog.ListAccountStorageCredentialsRequest;
import com.databricks.sdk.service.catalog.ListAccountStorageCredentialsResponse;
import com.databricks.sdk.service.catalog.StorageCredentialInfo;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class AccountStorageCredentialsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(AccountStorageCredentialsAPI.class);
    private final AccountStorageCredentialsService impl;

    public AccountStorageCredentialsAPI(ApiClient apiClient) {
        this.impl = new AccountStorageCredentialsImpl(apiClient);
    }

    public AccountStorageCredentialsAPI(AccountStorageCredentialsService mock) {
        this.impl = mock;
    }

    public AccountsStorageCredentialInfo create(String metastoreId) {
        return this.create(new AccountsCreateStorageCredential().setMetastoreId(metastoreId));
    }

    public AccountsStorageCredentialInfo create(AccountsCreateStorageCredential request) {
        return this.impl.create(request);
    }

    public void delete(String metastoreId, String storageCredentialName) {
        this.delete(new DeleteAccountStorageCredentialRequest().setMetastoreId(metastoreId).setStorageCredentialName(storageCredentialName));
    }

    public void delete(DeleteAccountStorageCredentialRequest request) {
        this.impl.delete(request);
    }

    public AccountsStorageCredentialInfo get(String metastoreId, String storageCredentialName) {
        return this.get(new GetAccountStorageCredentialRequest().setMetastoreId(metastoreId).setStorageCredentialName(storageCredentialName));
    }

    public AccountsStorageCredentialInfo get(GetAccountStorageCredentialRequest request) {
        return this.impl.get(request);
    }

    public Iterable<StorageCredentialInfo> list(String metastoreId) {
        return this.list(new ListAccountStorageCredentialsRequest().setMetastoreId(metastoreId));
    }

    public Iterable<StorageCredentialInfo> list(ListAccountStorageCredentialsRequest request) {
        return new Paginator(request, this.impl::list, ListAccountStorageCredentialsResponse::getStorageCredentials, response -> null);
    }

    public AccountsStorageCredentialInfo update(String metastoreId, String storageCredentialName) {
        return this.update(new AccountsUpdateStorageCredential().setMetastoreId(metastoreId).setStorageCredentialName(storageCredentialName));
    }

    public AccountsStorageCredentialInfo update(AccountsUpdateStorageCredential request) {
        return this.impl.update(request);
    }

    public AccountStorageCredentialsService impl() {
        return this.impl;
    }
}

