/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.compute;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.compute.ChangeClusterOwner;
import com.databricks.sdk.service.compute.ChangeClusterOwnerResponse;
import com.databricks.sdk.service.compute.ClusterDetails;
import com.databricks.sdk.service.compute.ClusterPermissions;
import com.databricks.sdk.service.compute.ClusterPermissionsRequest;
import com.databricks.sdk.service.compute.ClustersService;
import com.databricks.sdk.service.compute.CreateCluster;
import com.databricks.sdk.service.compute.CreateClusterResponse;
import com.databricks.sdk.service.compute.DeleteCluster;
import com.databricks.sdk.service.compute.DeleteClusterResponse;
import com.databricks.sdk.service.compute.EditCluster;
import com.databricks.sdk.service.compute.EditClusterResponse;
import com.databricks.sdk.service.compute.GetClusterPermissionLevelsRequest;
import com.databricks.sdk.service.compute.GetClusterPermissionLevelsResponse;
import com.databricks.sdk.service.compute.GetClusterPermissionsRequest;
import com.databricks.sdk.service.compute.GetClusterRequest;
import com.databricks.sdk.service.compute.GetEvents;
import com.databricks.sdk.service.compute.GetEventsResponse;
import com.databricks.sdk.service.compute.GetSparkVersionsResponse;
import com.databricks.sdk.service.compute.ListAvailableZonesResponse;
import com.databricks.sdk.service.compute.ListClustersRequest;
import com.databricks.sdk.service.compute.ListClustersResponse;
import com.databricks.sdk.service.compute.ListNodeTypesResponse;
import com.databricks.sdk.service.compute.PermanentDeleteCluster;
import com.databricks.sdk.service.compute.PermanentDeleteClusterResponse;
import com.databricks.sdk.service.compute.PinCluster;
import com.databricks.sdk.service.compute.PinClusterResponse;
import com.databricks.sdk.service.compute.ResizeCluster;
import com.databricks.sdk.service.compute.ResizeClusterResponse;
import com.databricks.sdk.service.compute.RestartCluster;
import com.databricks.sdk.service.compute.RestartClusterResponse;
import com.databricks.sdk.service.compute.StartCluster;
import com.databricks.sdk.service.compute.StartClusterResponse;
import com.databricks.sdk.service.compute.UnpinCluster;
import com.databricks.sdk.service.compute.UnpinClusterResponse;
import com.databricks.sdk.service.compute.UpdateCluster;
import com.databricks.sdk.service.compute.UpdateClusterResponse;
import com.databricks.sdk.support.Generated;
import java.util.HashMap;

@Generated
class ClustersImpl
implements ClustersService {
    private final ApiClient apiClient;

    public ClustersImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public void changeOwner(ChangeClusterOwner request) {
        String path = "/api/2.1/clusters/change-owner";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        this.apiClient.POST(path, request, ChangeClusterOwnerResponse.class, headers);
    }

    @Override
    public CreateClusterResponse create(CreateCluster request) {
        String path = "/api/2.1/clusters/create";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, CreateClusterResponse.class, headers);
    }

    @Override
    public void delete(DeleteCluster request) {
        String path = "/api/2.1/clusters/delete";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        this.apiClient.POST(path, request, DeleteClusterResponse.class, headers);
    }

    @Override
    public void edit(EditCluster request) {
        String path = "/api/2.1/clusters/edit";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        this.apiClient.POST(path, request, EditClusterResponse.class, headers);
    }

    @Override
    public GetEventsResponse events(GetEvents request) {
        String path = "/api/2.1/clusters/events";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, GetEventsResponse.class, headers);
    }

    @Override
    public ClusterDetails get(GetClusterRequest request) {
        String path = "/api/2.1/clusters/get";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ClusterDetails.class, headers);
    }

    @Override
    public GetClusterPermissionLevelsResponse getPermissionLevels(GetClusterPermissionLevelsRequest request) {
        String path = String.format("/api/2.0/permissions/clusters/%s/permissionLevels", request.getClusterId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, GetClusterPermissionLevelsResponse.class, headers);
    }

    @Override
    public ClusterPermissions getPermissions(GetClusterPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/clusters/%s", request.getClusterId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ClusterPermissions.class, headers);
    }

    @Override
    public ListClustersResponse list(ListClustersRequest request) {
        String path = "/api/2.1/clusters/list";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ListClustersResponse.class, headers);
    }

    @Override
    public ListNodeTypesResponse listNodeTypes() {
        String path = "/api/2.1/clusters/list-node-types";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, ListNodeTypesResponse.class, headers);
    }

    @Override
    public ListAvailableZonesResponse listZones() {
        String path = "/api/2.1/clusters/list-zones";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, ListAvailableZonesResponse.class, headers);
    }

    @Override
    public void permanentDelete(PermanentDeleteCluster request) {
        String path = "/api/2.1/clusters/permanent-delete";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        this.apiClient.POST(path, request, PermanentDeleteClusterResponse.class, headers);
    }

    @Override
    public void pin(PinCluster request) {
        String path = "/api/2.1/clusters/pin";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        this.apiClient.POST(path, request, PinClusterResponse.class, headers);
    }

    @Override
    public void resize(ResizeCluster request) {
        String path = "/api/2.1/clusters/resize";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        this.apiClient.POST(path, request, ResizeClusterResponse.class, headers);
    }

    @Override
    public void restart(RestartCluster request) {
        String path = "/api/2.1/clusters/restart";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        this.apiClient.POST(path, request, RestartClusterResponse.class, headers);
    }

    @Override
    public ClusterPermissions setPermissions(ClusterPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/clusters/%s", request.getClusterId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.PUT(path, request, ClusterPermissions.class, headers);
    }

    @Override
    public GetSparkVersionsResponse sparkVersions() {
        String path = "/api/2.1/clusters/spark-versions";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, GetSparkVersionsResponse.class, headers);
    }

    @Override
    public void start(StartCluster request) {
        String path = "/api/2.1/clusters/start";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        this.apiClient.POST(path, request, StartClusterResponse.class, headers);
    }

    @Override
    public void unpin(UnpinCluster request) {
        String path = "/api/2.1/clusters/unpin";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        this.apiClient.POST(path, request, UnpinClusterResponse.class, headers);
    }

    @Override
    public void update(UpdateCluster request) {
        String path = "/api/2.1/clusters/update";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        this.apiClient.POST(path, request, UpdateClusterResponse.class, headers);
    }

    @Override
    public ClusterPermissions updatePermissions(ClusterPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/clusters/%s", request.getClusterId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.PATCH(path, request, ClusterPermissions.class, headers);
    }
}

