/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.oauth;

import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.commons.CommonsHttpClient;
import com.databricks.sdk.core.http.HttpClient;
import com.databricks.sdk.core.oauth.AuthParameterPosition;
import com.databricks.sdk.core.oauth.SessionCredentials;
import com.databricks.sdk.core.oauth.Token;
import com.databricks.sdk.core.oauth.TokenEndpointClient;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.awt.Desktop;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Consent
implements Serializable {
    private static final Long serialVersionUID = -3832904096215095559L;
    private transient HttpClient hc;
    private final String authUrl;
    private final String verifier;
    private final String state;
    private final String tokenUrl;
    private final String redirectUrl;
    private final String clientId;
    private final String clientSecret;

    private Consent(Builder builder) {
        this.hc = Objects.requireNonNull(builder.hc);
        this.authUrl = Objects.requireNonNull(builder.authUrl);
        this.verifier = Objects.requireNonNull(builder.verifier);
        this.state = Objects.requireNonNull(builder.state);
        this.tokenUrl = Objects.requireNonNull(builder.tokenUrl);
        this.redirectUrl = Objects.requireNonNull(builder.redirectUrl);
        this.clientId = Objects.requireNonNull(builder.clientId);
        this.clientSecret = builder.clientSecret;
    }

    public Consent setHttpClient(HttpClient hc) {
        this.hc = hc;
        return this;
    }

    public String getAuthUrl() {
        return this.authUrl;
    }

    public String getVerifier() {
        return this.verifier;
    }

    public String getState() {
        return this.state;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public SessionCredentials launchExternalBrowser() throws IOException {
        Map<String, String> params = this.getOAuthCallbackParameters();
        return this.exchangeCallbackParameters(params);
    }

    public SessionCredentials exchangeCallbackParameters(Map<String, String> query) {
        this.validateCallbackParameters(query);
        Token token = this.exchange(query.get("code"), query.get("state"));
        return new SessionCredentials.Builder().withHttpClient(this.hc).withClientId(this.clientId).withClientSecret(this.clientSecret).withTokenUrl(this.tokenUrl).withToken(token).build();
    }

    Token getTokenFromExternalBrowser() throws IOException {
        Map<String, String> params = this.getOAuthCallbackParameters();
        this.validateCallbackParameters(params);
        return this.exchange(params.get("code"), params.get("state"));
    }

    protected void desktopBrowser() throws IOException {
        Desktop.getDesktop().browse(URI.create(this.authUrl));
    }

    private Map<String, String> getOAuthCallbackParameters() throws IOException {
        URL redirect = new URL(this.getRedirectUrl());
        if (!Arrays.asList("localhost", "127.0.0.1").contains(redirect.getHost())) {
            throw new IllegalArgumentException("cannot listen on " + redirect.getHost() + ", redirectUrl host must be one of: localhost, 127.0.0.1");
        }
        CallbackResponseHandler handler = new CallbackResponseHandler();
        HttpServer httpServer = HttpServer.create(new InetSocketAddress(redirect.getHost(), redirect.getPort()), 0);
        httpServer.createContext("/", handler);
        httpServer.start();
        this.desktopBrowser();
        Map<String, String> params = handler.getParams();
        httpServer.stop(0);
        return params;
    }

    private void validateCallbackParameters(Map<String, String> query) {
        if (query.containsKey("error")) {
            throw new DatabricksException(query.get("error") + ": " + query.get("error_description"));
        }
        if (!query.containsKey("code") || !query.containsKey("state")) {
            throw new DatabricksException("No code returned in callback");
        }
    }

    private Token exchange(String code, String state) {
        if (!this.state.equals(state)) {
            throw new DatabricksException("state mismatch: original state: " + this.state + "; retrieved state: " + state);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("grant_type", "authorization_code");
        params.put("code", code);
        params.put("code_verifier", this.verifier);
        params.put("redirect_uri", this.redirectUrl);
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.tokenUrl.contains("microsoft")) {
            headers.put("Origin", this.redirectUrl);
        }
        Token token = TokenEndpointClient.retrieveToken(this.hc, this.clientId, this.clientSecret, this.tokenUrl, params, headers, AuthParameterPosition.BODY);
        return token;
    }

    static class CallbackResponseHandler
    implements HttpHandler {
        private final Logger LOG = LoggerFactory.getLogger((String)this.getClass().getName());
        private final Object lock = new Object();
        private volatile Map<String, String> params;

        CallbackResponseHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) {
            try {
                this.handleInner(exchange);
            }
            catch (IOException e) {
                this.LOG.error("Unable to handle callback request", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleInner(HttpExchange exchange) throws IOException {
            if (!"GET".equals(exchange.getRequestMethod())) {
                this.sendError(exchange, 400, "Unsupported method", "Unsupported method " + exchange.getRequestMethod() + "; only GET is supported");
                return;
            }
            String query = exchange.getRequestURI().getQuery();
            if (query == null || query.isEmpty()) {
                this.sendError(exchange, 400, "Missing Query", "No query received for the current request");
                return;
            }
            String decodedQueryString = URLDecoder.decode(query, StandardCharsets.UTF_8.name());
            HashMap<String, String> theseParams = new HashMap<String, String>();
            Arrays.stream(decodedQueryString.split("&")).forEach(param -> {
                String[] keyValue = param.split("=");
                String key = keyValue[0];
                String value = keyValue.length > 1 ? keyValue[1] : "";
                theseParams.put(key, value);
            });
            this.sendSuccess(exchange);
            Object object = this.lock;
            synchronized (object) {
                this.params = theseParams;
                this.lock.notify();
            }
        }

        private void sendError(HttpExchange exchange, int statusCode, String message, String description) throws IOException {
            InputStream failureRespStream = this.getClass().getClassLoader().getResourceAsStream("oauth/failed_response.html.tmpl");
            String body = IOUtils.toString((InputStream)Objects.requireNonNull(failureRespStream), (Charset)StandardCharsets.UTF_8);
            HashMap<String, String> replacements = new HashMap<String, String>();
            replacements.put("{{code}}", String.valueOf(statusCode));
            replacements.put("{{message}}", message);
            replacements.put("{{explain}}", description);
            for (Map.Entry e : replacements.entrySet()) {
                body = body.replaceAll((String)e.getKey(), (String)e.getValue());
            }
            Headers respHeaders = exchange.getResponseHeaders();
            respHeaders.set("Connection", "close");
            respHeaders.set("Content-Type", "text/html;charset=utf-8");
            exchange.sendResponseHeaders(200, body.length());
            OutputStream out = exchange.getResponseBody();
            out.write(body.getBytes(StandardCharsets.UTF_8));
            exchange.close();
        }

        private void sendSuccess(HttpExchange exchange) throws IOException {
            InputStream successRespStream = this.getClass().getClassLoader().getResourceAsStream("oauth/successful_response.html");
            String body = IOUtils.toString((InputStream)Objects.requireNonNull(successRespStream), (Charset)StandardCharsets.UTF_8);
            Headers respHeaders = exchange.getResponseHeaders();
            respHeaders.set("Content-Type", "text/html;charset=utf-8");
            exchange.sendResponseHeaders(200, body.length());
            OutputStream out = exchange.getResponseBody();
            out.write(body.getBytes(StandardCharsets.UTF_8));
            exchange.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, String> getParams() {
            Object object = this.lock;
            synchronized (object) {
                if (this.params == null) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        throw new DatabricksException("Interrupted while waiting for parameters: " + e.getMessage(), e);
                    }
                }
                return this.params;
            }
        }
    }

    public static class Builder {
        private HttpClient hc = new CommonsHttpClient.Builder().withTimeoutSeconds(30).build();
        private String authUrl;
        private String verifier;
        private String state;
        private String tokenUrl;
        private String redirectUrl;
        private String clientId;
        private String clientSecret;

        public Builder withHttpClient(HttpClient hc) {
            this.hc = hc;
            return this;
        }

        public Builder withAuthUrl(String authUrl) {
            this.authUrl = authUrl;
            return this;
        }

        public Builder withVerifier(String verifier) {
            this.verifier = verifier;
            return this;
        }

        public Builder withState(String state) {
            this.state = state;
            return this;
        }

        public Builder withTokenUrl(String tokenUrl) {
            this.tokenUrl = tokenUrl;
            return this;
        }

        public Builder withRedirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
            return this;
        }

        public Builder withClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder withClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Consent build() {
            return new Consent(this);
        }
    }
}

