/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.aibuilder;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.aibuilder.AiBuilderImpl;
import com.databricks.sdk.service.aibuilder.AiBuilderService;
import com.databricks.sdk.service.aibuilder.CancelCustomLlmOptimizationRunRequest;
import com.databricks.sdk.service.aibuilder.CreateCustomLlmRequest;
import com.databricks.sdk.service.aibuilder.CustomLlm;
import com.databricks.sdk.service.aibuilder.DeleteCustomLlmRequest;
import com.databricks.sdk.service.aibuilder.GetCustomLlmRequest;
import com.databricks.sdk.service.aibuilder.StartCustomLlmOptimizationRunRequest;
import com.databricks.sdk.service.aibuilder.UpdateCustomLlmRequest;
import com.databricks.sdk.support.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class AiBuilderAPI {
    private static final Logger LOG = LoggerFactory.getLogger(AiBuilderAPI.class);
    private final AiBuilderService impl;

    public AiBuilderAPI(ApiClient apiClient) {
        this.impl = new AiBuilderImpl(apiClient);
    }

    public AiBuilderAPI(AiBuilderService mock) {
        this.impl = mock;
    }

    public void cancelOptimize(String id) {
        this.cancelOptimize(new CancelCustomLlmOptimizationRunRequest().setId(id));
    }

    public void cancelOptimize(CancelCustomLlmOptimizationRunRequest request) {
        this.impl.cancelOptimize(request);
    }

    public CustomLlm createCustomLlm(String name, String instructions) {
        return this.createCustomLlm(new CreateCustomLlmRequest().setName(name).setInstructions(instructions));
    }

    public CustomLlm createCustomLlm(CreateCustomLlmRequest request) {
        return this.impl.createCustomLlm(request);
    }

    public void deleteCustomLlm(String id) {
        this.deleteCustomLlm(new DeleteCustomLlmRequest().setId(id));
    }

    public void deleteCustomLlm(DeleteCustomLlmRequest request) {
        this.impl.deleteCustomLlm(request);
    }

    public CustomLlm getCustomLlm(String id) {
        return this.getCustomLlm(new GetCustomLlmRequest().setId(id));
    }

    public CustomLlm getCustomLlm(GetCustomLlmRequest request) {
        return this.impl.getCustomLlm(request);
    }

    public CustomLlm startOptimize(String id) {
        return this.startOptimize(new StartCustomLlmOptimizationRunRequest().setId(id));
    }

    public CustomLlm startOptimize(StartCustomLlmOptimizationRunRequest request) {
        return this.impl.startOptimize(request);
    }

    public CustomLlm updateCustomLlm(String id, CustomLlm customLlm, String updateMask) {
        return this.updateCustomLlm(new UpdateCustomLlmRequest().setId(id).setCustomLlm(customLlm).setUpdateMask(updateMask));
    }

    public CustomLlm updateCustomLlm(UpdateCustomLlmRequest request) {
        return this.impl.updateCustomLlm(request);
    }

    public AiBuilderService impl() {
        return this.impl;
    }
}

