/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.CreateExternalMetadataRequest;
import com.databricks.sdk.service.catalog.DeleteExternalMetadataRequest;
import com.databricks.sdk.service.catalog.ExternalMetadata;
import com.databricks.sdk.service.catalog.ExternalMetadataImpl;
import com.databricks.sdk.service.catalog.ExternalMetadataService;
import com.databricks.sdk.service.catalog.GetExternalMetadataRequest;
import com.databricks.sdk.service.catalog.ListExternalMetadataRequest;
import com.databricks.sdk.service.catalog.ListExternalMetadataResponse;
import com.databricks.sdk.service.catalog.UpdateExternalMetadataRequest;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class ExternalMetadataAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalMetadataAPI.class);
    private final ExternalMetadataService impl;

    public ExternalMetadataAPI(ApiClient apiClient) {
        this.impl = new ExternalMetadataImpl(apiClient);
    }

    public ExternalMetadataAPI(ExternalMetadataService mock) {
        this.impl = mock;
    }

    public ExternalMetadata createExternalMetadata(ExternalMetadata externalMetadata) {
        return this.createExternalMetadata(new CreateExternalMetadataRequest().setExternalMetadata(externalMetadata));
    }

    public ExternalMetadata createExternalMetadata(CreateExternalMetadataRequest request) {
        return this.impl.createExternalMetadata(request);
    }

    public void deleteExternalMetadata(String name) {
        this.deleteExternalMetadata(new DeleteExternalMetadataRequest().setName(name));
    }

    public void deleteExternalMetadata(DeleteExternalMetadataRequest request) {
        this.impl.deleteExternalMetadata(request);
    }

    public ExternalMetadata getExternalMetadata(String name) {
        return this.getExternalMetadata(new GetExternalMetadataRequest().setName(name));
    }

    public ExternalMetadata getExternalMetadata(GetExternalMetadataRequest request) {
        return this.impl.getExternalMetadata(request);
    }

    public Iterable<ExternalMetadata> listExternalMetadata(ListExternalMetadataRequest request) {
        return new Paginator(request, this.impl::listExternalMetadata, ListExternalMetadataResponse::getExternalMetadata, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public ExternalMetadata updateExternalMetadata(String name, ExternalMetadata externalMetadata, String updateMask) {
        return this.updateExternalMetadata(new UpdateExternalMetadataRequest().setName(name).setExternalMetadata(externalMetadata).setUpdateMask(updateMask));
    }

    public ExternalMetadata updateExternalMetadata(UpdateExternalMetadataRequest request) {
        return this.impl.updateExternalMetadata(request);
    }

    public ExternalMetadataService impl() {
        return this.impl;
    }
}

