/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.CreateMetastore;
import com.databricks.sdk.service.catalog.CreateMetastoreAssignment;
import com.databricks.sdk.service.catalog.DeleteMetastoreRequest;
import com.databricks.sdk.service.catalog.GetMetastoreRequest;
import com.databricks.sdk.service.catalog.GetMetastoreSummaryResponse;
import com.databricks.sdk.service.catalog.ListMetastoresRequest;
import com.databricks.sdk.service.catalog.ListMetastoresResponse;
import com.databricks.sdk.service.catalog.MetastoreAssignment;
import com.databricks.sdk.service.catalog.MetastoreInfo;
import com.databricks.sdk.service.catalog.MetastoresImpl;
import com.databricks.sdk.service.catalog.MetastoresService;
import com.databricks.sdk.service.catalog.UnassignRequest;
import com.databricks.sdk.service.catalog.UpdateMetastore;
import com.databricks.sdk.service.catalog.UpdateMetastoreAssignment;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class MetastoresAPI {
    private static final Logger LOG = LoggerFactory.getLogger(MetastoresAPI.class);
    private final MetastoresService impl;

    public MetastoresAPI(ApiClient apiClient) {
        this.impl = new MetastoresImpl(apiClient);
    }

    public MetastoresAPI(MetastoresService mock) {
        this.impl = mock;
    }

    public void assign(long workspaceId, String metastoreId, String defaultCatalogName) {
        this.assign(new CreateMetastoreAssignment().setWorkspaceId(workspaceId).setMetastoreId(metastoreId).setDefaultCatalogName(defaultCatalogName));
    }

    public void assign(CreateMetastoreAssignment request) {
        this.impl.assign(request);
    }

    public MetastoreInfo create(String name) {
        return this.create(new CreateMetastore().setName(name));
    }

    public MetastoreInfo create(CreateMetastore request) {
        return this.impl.create(request);
    }

    public MetastoreAssignment current() {
        return this.impl.current();
    }

    public void delete(String id) {
        this.delete(new DeleteMetastoreRequest().setId(id));
    }

    public void delete(DeleteMetastoreRequest request) {
        this.impl.delete(request);
    }

    public MetastoreInfo get(String id) {
        return this.get(new GetMetastoreRequest().setId(id));
    }

    public MetastoreInfo get(GetMetastoreRequest request) {
        return this.impl.get(request);
    }

    public Iterable<MetastoreInfo> list(ListMetastoresRequest request) {
        return new Paginator(request, this.impl::list, ListMetastoresResponse::getMetastores, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public GetMetastoreSummaryResponse summary() {
        return this.impl.summary();
    }

    public void unassign(long workspaceId, String metastoreId) {
        this.unassign(new UnassignRequest().setWorkspaceId(workspaceId).setMetastoreId(metastoreId));
    }

    public void unassign(UnassignRequest request) {
        this.impl.unassign(request);
    }

    public MetastoreInfo update(String id) {
        return this.update(new UpdateMetastore().setId(id));
    }

    public MetastoreInfo update(UpdateMetastore request) {
        return this.impl.update(request);
    }

    public void updateAssignment(long workspaceId) {
        this.updateAssignment(new UpdateMetastoreAssignment().setWorkspaceId(workspaceId));
    }

    public void updateAssignment(UpdateMetastoreAssignment request) {
        this.impl.updateAssignment(request);
    }

    public MetastoresService impl() {
        return this.impl;
    }
}

