/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.iam;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.iam.DeleteUserRequest;
import com.databricks.sdk.service.iam.GetPasswordPermissionLevelsResponse;
import com.databricks.sdk.service.iam.GetUserRequest;
import com.databricks.sdk.service.iam.ListUsersRequest;
import com.databricks.sdk.service.iam.ListUsersResponse;
import com.databricks.sdk.service.iam.PartialUpdate;
import com.databricks.sdk.service.iam.PasswordPermissions;
import com.databricks.sdk.service.iam.PasswordPermissionsRequest;
import com.databricks.sdk.service.iam.User;
import com.databricks.sdk.service.iam.UsersImpl;
import com.databricks.sdk.service.iam.UsersService;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class UsersAPI {
    private static final Logger LOG = LoggerFactory.getLogger(UsersAPI.class);
    private final UsersService impl;

    public UsersAPI(ApiClient apiClient) {
        this.impl = new UsersImpl(apiClient);
    }

    public UsersAPI(UsersService mock) {
        this.impl = mock;
    }

    public User create(User request) {
        return this.impl.create(request);
    }

    public void delete(String id) {
        this.delete(new DeleteUserRequest().setId(id));
    }

    public void delete(DeleteUserRequest request) {
        this.impl.delete(request);
    }

    public User get(String id) {
        return this.get(new GetUserRequest().setId(id));
    }

    public User get(GetUserRequest request) {
        return this.impl.get(request);
    }

    public GetPasswordPermissionLevelsResponse getPermissionLevels() {
        return this.impl.getPermissionLevels();
    }

    public PasswordPermissions getPermissions() {
        return this.impl.getPermissions();
    }

    public Iterable<User> list(ListUsersRequest request) {
        request.setStartIndex(1L);
        if (request.getCount() == null) {
            request.setCount(10000L);
        }
        return new Paginator<ListUsersRequest, ListUsersResponse, User>(request, this.impl::list, ListUsersResponse::getResources, response -> {
            Long offset = request.getStartIndex();
            if (offset == null) {
                offset = 0L;
            }
            offset = offset + (long)response.getResources().size();
            return request.setStartIndex(offset);
        }).withDedupe(User::getId);
    }

    public void patch(String id) {
        this.patch(new PartialUpdate().setId(id));
    }

    public void patch(PartialUpdate request) {
        this.impl.patch(request);
    }

    public PasswordPermissions setPermissions(PasswordPermissionsRequest request) {
        return this.impl.setPermissions(request);
    }

    public void update(String id) {
        this.update(new User().setId(id));
    }

    public void update(User request) {
        this.impl.update(request);
    }

    public PasswordPermissions updatePermissions(PasswordPermissionsRequest request) {
        return this.impl.updatePermissions(request);
    }

    public UsersService impl() {
        return this.impl;
    }
}

