/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.ml;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.ml.CreateOnlineStoreRequest;
import com.databricks.sdk.service.ml.DeleteOnlineStoreRequest;
import com.databricks.sdk.service.ml.FeatureStoreImpl;
import com.databricks.sdk.service.ml.FeatureStoreService;
import com.databricks.sdk.service.ml.GetOnlineStoreRequest;
import com.databricks.sdk.service.ml.ListOnlineStoresRequest;
import com.databricks.sdk.service.ml.ListOnlineStoresResponse;
import com.databricks.sdk.service.ml.OnlineStore;
import com.databricks.sdk.service.ml.PublishSpec;
import com.databricks.sdk.service.ml.PublishTableRequest;
import com.databricks.sdk.service.ml.PublishTableResponse;
import com.databricks.sdk.service.ml.UpdateOnlineStoreRequest;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class FeatureStoreAPI {
    private static final Logger LOG = LoggerFactory.getLogger(FeatureStoreAPI.class);
    private final FeatureStoreService impl;

    public FeatureStoreAPI(ApiClient apiClient) {
        this.impl = new FeatureStoreImpl(apiClient);
    }

    public FeatureStoreAPI(FeatureStoreService mock) {
        this.impl = mock;
    }

    public OnlineStore createOnlineStore(OnlineStore onlineStore) {
        return this.createOnlineStore(new CreateOnlineStoreRequest().setOnlineStore(onlineStore));
    }

    public OnlineStore createOnlineStore(CreateOnlineStoreRequest request) {
        return this.impl.createOnlineStore(request);
    }

    public void deleteOnlineStore(String name) {
        this.deleteOnlineStore(new DeleteOnlineStoreRequest().setName(name));
    }

    public void deleteOnlineStore(DeleteOnlineStoreRequest request) {
        this.impl.deleteOnlineStore(request);
    }

    public OnlineStore getOnlineStore(String name) {
        return this.getOnlineStore(new GetOnlineStoreRequest().setName(name));
    }

    public OnlineStore getOnlineStore(GetOnlineStoreRequest request) {
        return this.impl.getOnlineStore(request);
    }

    public Iterable<OnlineStore> listOnlineStores(ListOnlineStoresRequest request) {
        return new Paginator(request, this.impl::listOnlineStores, ListOnlineStoresResponse::getOnlineStores, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public PublishTableResponse publishTable(String sourceTableName, PublishSpec publishSpec) {
        return this.publishTable(new PublishTableRequest().setSourceTableName(sourceTableName).setPublishSpec(publishSpec));
    }

    public PublishTableResponse publishTable(PublishTableRequest request) {
        return this.impl.publishTable(request);
    }

    public OnlineStore updateOnlineStore(String name, OnlineStore onlineStore, String updateMask) {
        return this.updateOnlineStore(new UpdateOnlineStoreRequest().setName(name).setOnlineStore(onlineStore).setUpdateMask(updateMask));
    }

    public OnlineStore updateOnlineStore(UpdateOnlineStoreRequest request) {
        return this.impl.updateOnlineStore(request);
    }

    public FeatureStoreService impl() {
        return this.impl;
    }
}

