/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.ml;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.ml.CreateFeatureTagRequest;
import com.databricks.sdk.service.ml.DeleteFeatureTagRequest;
import com.databricks.sdk.service.ml.FeatureLineage;
import com.databricks.sdk.service.ml.FeatureTag;
import com.databricks.sdk.service.ml.GetFeatureLineageRequest;
import com.databricks.sdk.service.ml.GetFeatureTagRequest;
import com.databricks.sdk.service.ml.ListFeatureTagsRequest;
import com.databricks.sdk.service.ml.ListFeatureTagsResponse;
import com.databricks.sdk.service.ml.MaterializedFeaturesImpl;
import com.databricks.sdk.service.ml.MaterializedFeaturesService;
import com.databricks.sdk.service.ml.UpdateFeatureTagRequest;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class MaterializedFeaturesAPI {
    private static final Logger LOG = LoggerFactory.getLogger(MaterializedFeaturesAPI.class);
    private final MaterializedFeaturesService impl;

    public MaterializedFeaturesAPI(ApiClient apiClient) {
        this.impl = new MaterializedFeaturesImpl(apiClient);
    }

    public MaterializedFeaturesAPI(MaterializedFeaturesService mock) {
        this.impl = mock;
    }

    public FeatureTag createFeatureTag(String tableName, String featureName, FeatureTag featureTag) {
        return this.createFeatureTag(new CreateFeatureTagRequest().setTableName(tableName).setFeatureName(featureName).setFeatureTag(featureTag));
    }

    public FeatureTag createFeatureTag(CreateFeatureTagRequest request) {
        return this.impl.createFeatureTag(request);
    }

    public void deleteFeatureTag(String tableName, String featureName, String key) {
        this.deleteFeatureTag(new DeleteFeatureTagRequest().setTableName(tableName).setFeatureName(featureName).setKey(key));
    }

    public void deleteFeatureTag(DeleteFeatureTagRequest request) {
        this.impl.deleteFeatureTag(request);
    }

    public FeatureLineage getFeatureLineage(String tableName, String featureName) {
        return this.getFeatureLineage(new GetFeatureLineageRequest().setTableName(tableName).setFeatureName(featureName));
    }

    public FeatureLineage getFeatureLineage(GetFeatureLineageRequest request) {
        return this.impl.getFeatureLineage(request);
    }

    public FeatureTag getFeatureTag(String tableName, String featureName, String key) {
        return this.getFeatureTag(new GetFeatureTagRequest().setTableName(tableName).setFeatureName(featureName).setKey(key));
    }

    public FeatureTag getFeatureTag(GetFeatureTagRequest request) {
        return this.impl.getFeatureTag(request);
    }

    public Iterable<FeatureTag> listFeatureTags(String tableName, String featureName) {
        return this.listFeatureTags(new ListFeatureTagsRequest().setTableName(tableName).setFeatureName(featureName));
    }

    public Iterable<FeatureTag> listFeatureTags(ListFeatureTagsRequest request) {
        return new Paginator(request, this.impl::listFeatureTags, ListFeatureTagsResponse::getFeatureTags, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public FeatureTag updateFeatureTag(String tableName, String featureName, String key, FeatureTag featureTag) {
        return this.updateFeatureTag(new UpdateFeatureTagRequest().setTableName(tableName).setFeatureName(featureName).setKey(key).setFeatureTag(featureTag));
    }

    public FeatureTag updateFeatureTag(UpdateFeatureTagRequest request) {
        return this.impl.updateFeatureTag(request);
    }

    public MaterializedFeaturesService impl() {
        return this.impl;
    }
}

