/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.catalog.CreateStorageCredential;
import com.databricks.sdk.service.catalog.DeleteStorageCredentialRequest;
import com.databricks.sdk.service.catalog.GetStorageCredentialRequest;
import com.databricks.sdk.service.catalog.ListStorageCredentialsRequest;
import com.databricks.sdk.service.catalog.ListStorageCredentialsResponse;
import com.databricks.sdk.service.catalog.StorageCredentialInfo;
import com.databricks.sdk.service.catalog.StorageCredentialsService;
import com.databricks.sdk.service.catalog.UpdateStorageCredential;
import com.databricks.sdk.service.catalog.ValidateStorageCredential;
import com.databricks.sdk.service.catalog.ValidateStorageCredentialResponse;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class StorageCredentialsImpl
implements StorageCredentialsService {
    private final ApiClient apiClient;

    public StorageCredentialsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public StorageCredentialInfo create(CreateStorageCredential request) {
        String path = "/api/2.1/unity-catalog/storage-credentials";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, StorageCredentialInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteStorageCredentialRequest request) {
        String path = String.format("/api/2.1/unity-catalog/storage-credentials/%s", request.getName());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public StorageCredentialInfo get(GetStorageCredentialRequest request) {
        String path = String.format("/api/2.1/unity-catalog/storage-credentials/%s", request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, StorageCredentialInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListStorageCredentialsResponse list(ListStorageCredentialsRequest request) {
        String path = "/api/2.1/unity-catalog/storage-credentials";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListStorageCredentialsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public StorageCredentialInfo update(UpdateStorageCredential request) {
        String path = String.format("/api/2.1/unity-catalog/storage-credentials/%s", request.getName());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, StorageCredentialInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ValidateStorageCredentialResponse validate(ValidateStorageCredential request) {
        String path = "/api/2.1/unity-catalog/validate-storage-credentials";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, ValidateStorageCredentialResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

