/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.oauth;

import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.HttpClient;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.core.http.Response;
import com.databricks.sdk.core.oauth.IDToken;
import com.databricks.sdk.core.oauth.IDTokenSource;
import com.databricks.sdk.support.InternalApi;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import java.io.IOException;

@InternalApi
public class GithubIDTokenSource
implements IDTokenSource {
    private final String actionsIDTokenRequestURL;
    private final String actionsIDTokenRequestToken;
    private final HttpClient httpClient;
    private static final ObjectMapper mapper = new ObjectMapper();

    public GithubIDTokenSource(String actionsIDTokenRequestURL, String actionsIDTokenRequestToken, HttpClient httpClient) {
        this.actionsIDTokenRequestURL = actionsIDTokenRequestURL;
        this.actionsIDTokenRequestToken = actionsIDTokenRequestToken;
        this.httpClient = httpClient;
    }

    @Override
    public IDToken getIDToken(String audience) {
        ObjectNode jsonResp;
        Response resp;
        if (Strings.isNullOrEmpty((String)this.actionsIDTokenRequestURL)) {
            throw new DatabricksException("Missing ActionsIDTokenRequestURL");
        }
        if (Strings.isNullOrEmpty((String)this.actionsIDTokenRequestToken)) {
            throw new DatabricksException("Missing ActionsIDTokenRequestToken");
        }
        if (this.httpClient == null) {
            throw new DatabricksException("HttpClient cannot be null");
        }
        String requestUrl = this.actionsIDTokenRequestURL;
        if (!Strings.isNullOrEmpty((String)audience)) {
            requestUrl = String.format("%s&audience=%s", requestUrl, audience);
        }
        Request req = new Request("GET", requestUrl).withHeader("Authorization", "Bearer " + this.actionsIDTokenRequestToken);
        try {
            resp = this.httpClient.execute(req);
        }
        catch (IOException e) {
            throw new DatabricksException("Failed to request ID token from " + requestUrl + ": " + e.getMessage(), e);
        }
        if (resp.getStatusCode() != 200) {
            throw new DatabricksException("Failed to request ID token: status code " + resp.getStatusCode() + ", response body: " + resp.getBody().toString());
        }
        try {
            jsonResp = (ObjectNode)mapper.readValue(resp.getBody(), ObjectNode.class);
        }
        catch (IOException e) {
            throw new DatabricksException("Failed to request ID token: corrupted token: " + e.getMessage());
        }
        if (!jsonResp.has("value")) {
            throw new DatabricksException("ID token response missing 'value' field");
        }
        try {
            String tokenValue = jsonResp.get("value").textValue();
            return new IDToken(tokenValue);
        }
        catch (IllegalArgumentException e) {
            throw new DatabricksException("Received empty ID token from GitHub Actions");
        }
    }
}

