/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.CreateEntityTagAssignmentRequest;
import com.databricks.sdk.service.catalog.DeleteEntityTagAssignmentRequest;
import com.databricks.sdk.service.catalog.EntityTagAssignment;
import com.databricks.sdk.service.catalog.EntityTagAssignmentsImpl;
import com.databricks.sdk.service.catalog.EntityTagAssignmentsService;
import com.databricks.sdk.service.catalog.GetEntityTagAssignmentRequest;
import com.databricks.sdk.service.catalog.ListEntityTagAssignmentsRequest;
import com.databricks.sdk.service.catalog.ListEntityTagAssignmentsResponse;
import com.databricks.sdk.service.catalog.UpdateEntityTagAssignmentRequest;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class EntityTagAssignmentsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(EntityTagAssignmentsAPI.class);
    private final EntityTagAssignmentsService impl;

    public EntityTagAssignmentsAPI(ApiClient apiClient) {
        this.impl = new EntityTagAssignmentsImpl(apiClient);
    }

    public EntityTagAssignmentsAPI(EntityTagAssignmentsService mock) {
        this.impl = mock;
    }

    public EntityTagAssignment create(CreateEntityTagAssignmentRequest request) {
        return this.impl.create(request);
    }

    public void delete(String entityType, String entityName, String tagKey) {
        this.delete(new DeleteEntityTagAssignmentRequest().setEntityType(entityType).setEntityName(entityName).setTagKey(tagKey));
    }

    public void delete(DeleteEntityTagAssignmentRequest request) {
        this.impl.delete(request);
    }

    public EntityTagAssignment get(String entityType, String entityName, String tagKey) {
        return this.get(new GetEntityTagAssignmentRequest().setEntityType(entityType).setEntityName(entityName).setTagKey(tagKey));
    }

    public EntityTagAssignment get(GetEntityTagAssignmentRequest request) {
        return this.impl.get(request);
    }

    public Iterable<EntityTagAssignment> list(String entityType, String entityName) {
        return this.list(new ListEntityTagAssignmentsRequest().setEntityType(entityType).setEntityName(entityName));
    }

    public Iterable<EntityTagAssignment> list(ListEntityTagAssignmentsRequest request) {
        return new Paginator(request, this.impl::list, ListEntityTagAssignmentsResponse::getTagAssignments, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public EntityTagAssignment update(UpdateEntityTagAssignmentRequest request) {
        return this.impl.update(request);
    }

    public EntityTagAssignmentsService impl() {
        return this.impl;
    }
}

