/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.catalog.EffectivePermissionsList;
import com.databricks.sdk.service.catalog.GetEffectiveRequest;
import com.databricks.sdk.service.catalog.GetGrantRequest;
import com.databricks.sdk.service.catalog.GetPermissionsResponse;
import com.databricks.sdk.service.catalog.GrantsService;
import com.databricks.sdk.service.catalog.UpdatePermissions;
import com.databricks.sdk.service.catalog.UpdatePermissionsResponse;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class GrantsImpl
implements GrantsService {
    private final ApiClient apiClient;

    public GrantsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public GetPermissionsResponse get(GetGrantRequest request) {
        String path = String.format("/api/2.1/unity-catalog/permissions/%s/%s", request.getSecurableType(), request.getFullName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, GetPermissionsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public EffectivePermissionsList getEffective(GetEffectiveRequest request) {
        String path = String.format("/api/2.1/unity-catalog/effective-permissions/%s/%s", request.getSecurableType(), request.getFullName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, EffectivePermissionsList.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public UpdatePermissionsResponse update(UpdatePermissions request) {
        String path = String.format("/api/2.1/unity-catalog/permissions/%s/%s", request.getSecurableType(), request.getFullName());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, UpdatePermissionsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

