/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.catalog.GetBindingsRequest;
import com.databricks.sdk.service.catalog.GetCatalogWorkspaceBindingsResponse;
import com.databricks.sdk.service.catalog.GetWorkspaceBindingRequest;
import com.databricks.sdk.service.catalog.GetWorkspaceBindingsResponse;
import com.databricks.sdk.service.catalog.UpdateCatalogWorkspaceBindingsResponse;
import com.databricks.sdk.service.catalog.UpdateWorkspaceBindings;
import com.databricks.sdk.service.catalog.UpdateWorkspaceBindingsParameters;
import com.databricks.sdk.service.catalog.UpdateWorkspaceBindingsResponse;
import com.databricks.sdk.service.catalog.WorkspaceBindingsService;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class WorkspaceBindingsImpl
implements WorkspaceBindingsService {
    private final ApiClient apiClient;

    public WorkspaceBindingsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public GetCatalogWorkspaceBindingsResponse get(GetWorkspaceBindingRequest request) {
        String path = String.format("/api/2.1/unity-catalog/workspace-bindings/catalogs/%s", request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, GetCatalogWorkspaceBindingsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetWorkspaceBindingsResponse getBindings(GetBindingsRequest request) {
        String path = String.format("/api/2.1/unity-catalog/bindings/%s/%s", request.getSecurableType(), request.getSecurableName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, GetWorkspaceBindingsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public UpdateCatalogWorkspaceBindingsResponse update(UpdateWorkspaceBindings request) {
        String path = String.format("/api/2.1/unity-catalog/workspace-bindings/catalogs/%s", request.getName());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, UpdateCatalogWorkspaceBindingsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public UpdateWorkspaceBindingsResponse updateBindings(UpdateWorkspaceBindingsParameters request) {
        String path = String.format("/api/2.1/unity-catalog/bindings/%s/%s", request.getSecurableType(), request.getSecurableName());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, UpdateWorkspaceBindingsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

