/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.networking;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.networking.CreateEndpointRequest;
import com.databricks.sdk.service.networking.DeleteEndpointRequest;
import com.databricks.sdk.service.networking.Endpoint;
import com.databricks.sdk.service.networking.EndpointsService;
import com.databricks.sdk.service.networking.GetEndpointRequest;
import com.databricks.sdk.service.networking.ListEndpointsRequest;
import com.databricks.sdk.service.networking.ListEndpointsResponse;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class EndpointsImpl
implements EndpointsService {
    private final ApiClient apiClient;

    public EndpointsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public Endpoint createEndpoint(CreateEndpointRequest request) {
        String path = String.format("/api/networking/v1/%s/endpoints", request.getParent());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request.getEndpoint()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, Endpoint.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteEndpoint(DeleteEndpointRequest request) {
        String path = String.format("/api/networking/v1/%s", request.getName());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Endpoint getEndpoint(GetEndpointRequest request) {
        String path = String.format("/api/networking/v1/%s", request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, Endpoint.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListEndpointsResponse listEndpoints(ListEndpointsRequest request) {
        String path = String.format("/api/networking/v1/%s/endpoints", request.getParent());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListEndpointsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

