/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.oauth2;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.oauth2.CreateServicePrincipalSecretRequest;
import com.databricks.sdk.service.oauth2.CreateServicePrincipalSecretResponse;
import com.databricks.sdk.service.oauth2.DeleteServicePrincipalSecretRequest;
import com.databricks.sdk.service.oauth2.ListServicePrincipalSecretsRequest;
import com.databricks.sdk.service.oauth2.ListServicePrincipalSecretsResponse;
import com.databricks.sdk.service.oauth2.ServicePrincipalSecretsProxyService;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class ServicePrincipalSecretsProxyImpl
implements ServicePrincipalSecretsProxyService {
    private final ApiClient apiClient;

    public ServicePrincipalSecretsProxyImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CreateServicePrincipalSecretResponse create(CreateServicePrincipalSecretRequest request) {
        String path = String.format("/api/2.0/accounts/servicePrincipals/%s/credentials/secrets", request.getServicePrincipalId());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, CreateServicePrincipalSecretResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteServicePrincipalSecretRequest request) {
        String path = String.format("/api/2.0/accounts/servicePrincipals/%s/credentials/secrets/%s", request.getServicePrincipalId(), request.getSecretId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListServicePrincipalSecretsResponse list(ListServicePrincipalSecretsRequest request) {
        String path = String.format("/api/2.0/accounts/servicePrincipals/%s/credentials/secrets", request.getServicePrincipalId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, ListServicePrincipalSecretsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

