/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.settingsv2;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.settingsv2.AccountSettingsV2Service;
import com.databricks.sdk.service.settingsv2.GetPublicAccountSettingRequest;
import com.databricks.sdk.service.settingsv2.GetPublicAccountUserPreferenceRequest;
import com.databricks.sdk.service.settingsv2.ListAccountSettingsMetadataRequest;
import com.databricks.sdk.service.settingsv2.ListAccountSettingsMetadataResponse;
import com.databricks.sdk.service.settingsv2.ListAccountUserPreferencesMetadataRequest;
import com.databricks.sdk.service.settingsv2.ListAccountUserPreferencesMetadataResponse;
import com.databricks.sdk.service.settingsv2.PatchPublicAccountSettingRequest;
import com.databricks.sdk.service.settingsv2.PatchPublicAccountUserPreferenceRequest;
import com.databricks.sdk.service.settingsv2.Setting;
import com.databricks.sdk.service.settingsv2.UserPreference;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class AccountSettingsV2Impl
implements AccountSettingsV2Service {
    private final ApiClient apiClient;

    public AccountSettingsV2Impl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public Setting getPublicAccountSetting(GetPublicAccountSettingRequest request) {
        String path = String.format("/api/2.1/accounts/%s/settings/%s", this.apiClient.configuredAccountID(), request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, Setting.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public UserPreference getPublicAccountUserPreference(GetPublicAccountUserPreferenceRequest request) {
        String path = String.format("/api/2.1/accounts/%s/users/%s/settings/%s", this.apiClient.configuredAccountID(), request.getUserId(), request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, UserPreference.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListAccountSettingsMetadataResponse listAccountSettingsMetadata(ListAccountSettingsMetadataRequest request) {
        String path = String.format("/api/2.1/accounts/%s/settings-metadata", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListAccountSettingsMetadataResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListAccountUserPreferencesMetadataResponse listAccountUserPreferencesMetadata(ListAccountUserPreferencesMetadataRequest request) {
        String path = String.format("/api/2.1/accounts/%s/users/%s/settings-metadata", this.apiClient.configuredAccountID(), request.getUserId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListAccountUserPreferencesMetadataResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Setting patchPublicAccountSetting(PatchPublicAccountSettingRequest request) {
        String path = String.format("/api/2.1/accounts/%s/settings/%s", this.apiClient.configuredAccountID(), request.getName());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request.getSetting()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, Setting.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public UserPreference patchPublicAccountUserPreference(PatchPublicAccountUserPreferenceRequest request) {
        String path = String.format("/api/2.1/accounts/%s/users/%s/settings/%s", this.apiClient.configuredAccountID(), request.getUserId(), request.getName());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request.getSetting()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, UserPreference.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

