/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.sharing;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.sharing.CreateFederationPolicyRequest;
import com.databricks.sdk.service.sharing.DeleteFederationPolicyRequest;
import com.databricks.sdk.service.sharing.FederationPolicy;
import com.databricks.sdk.service.sharing.GetFederationPolicyRequest;
import com.databricks.sdk.service.sharing.ListFederationPoliciesRequest;
import com.databricks.sdk.service.sharing.ListFederationPoliciesResponse;
import com.databricks.sdk.service.sharing.RecipientFederationPoliciesService;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class RecipientFederationPoliciesImpl
implements RecipientFederationPoliciesService {
    private final ApiClient apiClient;

    public RecipientFederationPoliciesImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public FederationPolicy create(CreateFederationPolicyRequest request) {
        String path = String.format("/api/2.0/data-sharing/recipients/%s/federation-policies", request.getRecipientName());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request.getPolicy()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, FederationPolicy.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteFederationPolicyRequest request) {
        String path = String.format("/api/2.0/data-sharing/recipients/%s/federation-policies/%s", request.getRecipientName(), request.getName());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public FederationPolicy getFederationPolicy(GetFederationPolicyRequest request) {
        String path = String.format("/api/2.0/data-sharing/recipients/%s/federation-policies/%s", request.getRecipientName(), request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, FederationPolicy.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListFederationPoliciesResponse list(ListFederationPoliciesRequest request) {
        String path = String.format("/api/2.0/data-sharing/recipients/%s/federation-policies", request.getRecipientName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, ListFederationPoliciesResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

