/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.workspace;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.workspace.CreateRepoRequest;
import com.databricks.sdk.service.workspace.CreateRepoResponse;
import com.databricks.sdk.service.workspace.DeleteRepoRequest;
import com.databricks.sdk.service.workspace.GetRepoPermissionLevelsRequest;
import com.databricks.sdk.service.workspace.GetRepoPermissionLevelsResponse;
import com.databricks.sdk.service.workspace.GetRepoPermissionsRequest;
import com.databricks.sdk.service.workspace.GetRepoRequest;
import com.databricks.sdk.service.workspace.GetRepoResponse;
import com.databricks.sdk.service.workspace.ListReposRequest;
import com.databricks.sdk.service.workspace.ListReposResponse;
import com.databricks.sdk.service.workspace.RepoPermissions;
import com.databricks.sdk.service.workspace.RepoPermissionsRequest;
import com.databricks.sdk.service.workspace.ReposService;
import com.databricks.sdk.service.workspace.UpdateRepoRequest;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class ReposImpl
implements ReposService {
    private final ApiClient apiClient;

    public ReposImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CreateRepoResponse create(CreateRepoRequest request) {
        String path = "/api/2.0/repos";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, CreateRepoResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteRepoRequest request) {
        String path = String.format("/api/2.0/repos/%s", request.getRepoId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetRepoResponse get(GetRepoRequest request) {
        String path = String.format("/api/2.0/repos/%s", request.getRepoId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, GetRepoResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetRepoPermissionLevelsResponse getPermissionLevels(GetRepoPermissionLevelsRequest request) {
        String path = String.format("/api/2.0/permissions/repos/%s/permissionLevels", request.getRepoId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, GetRepoPermissionLevelsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public RepoPermissions getPermissions(GetRepoPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/repos/%s", request.getRepoId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, RepoPermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListReposResponse list(ListReposRequest request) {
        String path = "/api/2.0/repos";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, ListReposResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public RepoPermissions setPermissions(RepoPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/repos/%s", request.getRepoId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, RepoPermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void update(UpdateRepoRequest request) {
        String path = String.format("/api/2.0/repos/%s", request.getRepoId());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public RepoPermissions updatePermissions(RepoPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/repos/%s", request.getRepoId());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, RepoPermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

