/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.datadog_lambda_java;

import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayV2ProxyRequestEvent;
import com.datadoghq.datadog_lambda_java.ConverterSubsegment;
import com.datadoghq.datadog_lambda_java.DDLogger;
import com.datadoghq.datadog_lambda_java.DDTraceContext;
import com.datadoghq.datadog_lambda_java.Headerable;
import com.datadoghq.datadog_lambda_java.XRayTraceContext;
import java.util.HashMap;
import java.util.Map;

public class Tracing {
    protected DDTraceContext cxt;
    protected XRayTraceContext xrt;
    protected String TRACE_ID_KEY = "dd.trace_id";
    protected String SPAN_ID_KEY = "dd.span_id";

    public Tracing() {
        this.xrt = new XRayTraceContext();
    }

    public Tracing(APIGatewayV2ProxyRequestEvent req) {
        this.cxt = Tracing.populateDDContext(req.getHeaders());
        this.xrt = new XRayTraceContext();
    }

    public Tracing(APIGatewayProxyRequestEvent req) {
        this.cxt = Tracing.populateDDContext(req.getHeaders());
        this.xrt = new XRayTraceContext();
    }

    public Tracing(Headerable req) {
        this.cxt = Tracing.populateDDContext(req.getHeaders());
        this.xrt = new XRayTraceContext();
    }

    protected Tracing(String xrayTraceInfo) {
        this.xrt = new XRayTraceContext(xrayTraceInfo);
    }

    public DDTraceContext getDDContext() {
        if (this.cxt == null) {
            return new DDTraceContext();
        }
        return this.cxt;
    }

    public XRayTraceContext getXrayContext() {
        if (this.xrt == null) {
            return new XRayTraceContext();
        }
        return this.xrt;
    }

    public Map<String, String> getLogCorrelationTraceAndSpanIDsMap() {
        if (this.cxt != null) {
            String traceID = this.cxt.getTraceID();
            String spanID = this.cxt.getParentID();
            HashMap<String, String> out = new HashMap<String, String>();
            out.put(this.TRACE_ID_KEY, traceID);
            out.put(this.SPAN_ID_KEY, spanID);
            return out;
        }
        if (this.xrt != null) {
            String traceID = this.xrt.getAPMTraceID();
            String spanID = this.xrt.getAPMParentID();
            HashMap<String, String> out = new HashMap<String, String>();
            out.put(this.TRACE_ID_KEY, traceID);
            out.put(this.SPAN_ID_KEY, spanID);
            return out;
        }
        DDLogger.getLoggerImpl().debug("No DD trace context or XRay trace context set!", new Object[0]);
        return null;
    }

    private String formatLogCorrelation(String trace, String span) {
        return String.format("[dd.trace_id=%s dd.span_id=%s]", trace, span);
    }

    private static DDTraceContext populateDDContext(Map<String, String> headers) {
        DDTraceContext ctx = null;
        try {
            ctx = new DDTraceContext(headers);
        }
        catch (Exception e) {
            DDLogger.getLoggerImpl().debug("Unable to extract DD Trace Context from event headers", new Object[0]);
        }
        return ctx;
    }

    protected boolean submitSegment() {
        if (this.cxt == null) {
            DDLogger.getLoggerImpl().debug("Cannot submit a fake span on a null context. Is the DD tracing context being initialized correctly?", new Object[0]);
            return false;
        }
        ConverterSubsegment es = new ConverterSubsegment(this.cxt, this.xrt);
        return es.sendToXRay();
    }

    protected Map<String, String> makeOutboundHttpTraceHeaders() {
        HashMap<String, String> traceHeaders = new HashMap<String, String>();
        String apmParent = null;
        if (this.xrt != null) {
            apmParent = this.xrt.getAPMParentID();
        }
        if (this.cxt == null || this.xrt == null || this.cxt.getTraceID() == null || this.cxt.getSamplingPriority() == null || apmParent == null) {
            DDLogger.getLoggerImpl().debug("Cannot make outbound trace headers -- some required fields are null", new Object[0]);
            return traceHeaders;
        }
        traceHeaders.put(this.cxt.ddTraceKey, this.cxt.getTraceID());
        traceHeaders.put(this.cxt.ddSamplingKey, this.cxt.getSamplingPriority());
        traceHeaders.put(this.cxt.ddParentKey, this.xrt.getAPMParentID());
        return traceHeaders;
    }
}

