/*
 * Decompiled with CFR 0.152.
 */
package com.deepl.api.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class StreamUtil {
    public static final int DEFAULT_BUFFER_SIZE = 1024;

    public static String readStream(InputStream inputStream) throws IOException {
        Charset charset = StandardCharsets.UTF_8;
        char[] buffer = new char[1024];
        StringBuilder sb = new StringBuilder();
        try (InputStreamReader isr = new InputStreamReader(inputStream, charset);
             BufferedReader in = new BufferedReader(isr);){
            int charsRead;
            while ((charsRead = ((Reader)in).read(buffer, 0, 1024)) > 0) {
                sb.append(buffer, 0, charsRead);
            }
        }
        return sb.toString();
    }

    public static long transferTo(InputStream inputStream, OutputStream outputStream) throws IOException {
        int read;
        long transferred = 0L;
        byte[] buffer = new byte[1024];
        while ((read = inputStream.read(buffer, 0, 1024)) >= 0) {
            outputStream.write(buffer, 0, read);
            transferred += (long)read;
        }
        return transferred;
    }
}

