/*
 * Decompiled with CFR 0.152.
 */
package com.devcycle.sdk.server.cloud.api;

import com.devcycle.sdk.server.cloud.model.DVCCloudOptions;
import com.devcycle.sdk.server.common.api.IDVCApi;
import com.devcycle.sdk.server.common.interceptor.AuthorizationHeaderInterceptor;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public final class DVCCloudApiClient {
    private final OkHttpClient.Builder okBuilder;
    private final Retrofit.Builder adapterBuilder;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String BUCKETING_URL = "https://bucketing-api.devcycle.com/";

    private DVCCloudApiClient(DVCCloudOptions options) {
        String bucketingApiUrl = System.getenv("BUCKETING_API_URL");
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.okBuilder = new OkHttpClient.Builder();
        String url = this.checkIfStringNullOrEmpty(bucketingApiUrl) != false ? BUCKETING_URL : bucketingApiUrl;
        this.adapterBuilder = new Retrofit.Builder().baseUrl(url).addConverterFactory((Converter.Factory)JacksonConverterFactory.create());
    }

    public DVCCloudApiClient(String apiKey, DVCCloudOptions options) {
        this(options);
        this.okBuilder.addInterceptor((Interceptor)new AuthorizationHeaderInterceptor(apiKey));
    }

    public IDVCApi initialize() {
        return (IDVCApi)this.adapterBuilder.client(this.okBuilder.build()).build().create(IDVCApi.class);
    }

    private Boolean checkIfStringNullOrEmpty(String stringToCheck) {
        return Objects.isNull(stringToCheck) || Objects.equals(stringToCheck, "");
    }
}

