/*
 * Decompiled with CFR 0.152.
 */
package com.devcycle.sdk.server.common.model;

import com.devcycle.sdk.server.common.model.PlatformData;
import com.devcycle.sdk.server.local.utils.LongTimestampDeserializer;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=UserBuilder.class)
public class User {
    @JsonIgnoreProperties(ignoreUnknown=true)
    @Schema(required=true, description="Unique id to identify the user")
    @JsonProperty(value="user_id")
    @NonNull
    private String userId;
    @Schema(description="User's email used to identify the user on the dashboard / target audiences")
    @JsonProperty(value="email")
    private String email;
    @Schema(description="User's name used to identify the user on the dashboard / target audiences")
    @JsonProperty(value="name")
    private String name;
    @Schema(description="User's language in ISO 639-1 format")
    @JsonProperty(value="language")
    private String language;
    @Schema(description="User's country in ISO 3166 alpha-2 format")
    @JsonProperty(value="country")
    private String country;
    @Schema(description="App Version of the running application")
    @JsonProperty(value="appVersion")
    private String appVersion;
    @Schema(description="App Build number of the running application")
    @JsonProperty(value="appBuild")
    private String appBuild;
    @Schema(description="User's custom data to target the user with, data will be logged to DevCycle for use in dashboard.")
    @JsonProperty(value="customData")
    private Object customData;
    @Schema(description="User's custom data to target the user with, data will not be logged to DevCycle only used for feature bucketing.")
    @JsonProperty(value="privateCustomData")
    private Object privateCustomData;
    @Schema(description="Date the user was created, Unix epoch timestamp format")
    @JsonProperty(value="createdDate")
    @JsonDeserialize(using=LongTimestampDeserializer.class)
    private Long createdDate;
    @Schema(description="Date the user was last seen, Unix epoch timestamp format")
    @JsonProperty(value="lastSeenDate")
    @JsonDeserialize(using=LongTimestampDeserializer.class)
    private Long lastSeenDate;
    @Schema(description="Platform the SDK is running on")
    @JsonProperty(value="platform")
    private String platform;
    @Schema(description="Version of the platform the SDK is running on")
    @JsonProperty(value="platformVersion")
    private String platformVersion;
    @Schema(description="DevCycle SDK type")
    @JsonProperty(value="sdkType")
    private PlatformData.SdkTypeEnum sdkType;
    @Schema(description="DevCycle SDK Version")
    @JsonProperty(value="sdkVersion")
    private String sdkVersion;

    public PlatformData getPlatformData() {
        return PlatformData.builder().build();
    }

    private static String $default$platform() {
        return "Java";
    }

    private static String $default$platformVersion() {
        return System.getProperty("java.version");
    }

    private static PlatformData.SdkTypeEnum $default$sdkType() {
        return PlatformData.SdkTypeEnum.SERVER;
    }

    private static String $default$sdkVersion() {
        return User.class.getPackage().getImplementationVersion();
    }

    public static UserBuilder builder() {
        return new UserBuilder();
    }

    @NonNull
    public String getUserId() {
        return this.userId;
    }

    public String getEmail() {
        return this.email;
    }

    public String getName() {
        return this.name;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getCountry() {
        return this.country;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public String getAppBuild() {
        return this.appBuild;
    }

    public Object getCustomData() {
        return this.customData;
    }

    public Object getPrivateCustomData() {
        return this.privateCustomData;
    }

    public Long getCreatedDate() {
        return this.createdDate;
    }

    public Long getLastSeenDate() {
        return this.lastSeenDate;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    public PlatformData.SdkTypeEnum getSdkType() {
        return this.sdkType;
    }

    public String getSdkVersion() {
        return this.sdkVersion;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonProperty(value="user_id")
    public void setUserId(@NonNull String userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
    }

    @JsonProperty(value="email")
    public void setEmail(String email) {
        this.email = email;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="language")
    public void setLanguage(String language) {
        this.language = language;
    }

    @JsonProperty(value="country")
    public void setCountry(String country) {
        this.country = country;
    }

    @JsonProperty(value="appVersion")
    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    @JsonProperty(value="appBuild")
    public void setAppBuild(String appBuild) {
        this.appBuild = appBuild;
    }

    @JsonProperty(value="customData")
    public void setCustomData(Object customData) {
        this.customData = customData;
    }

    @JsonProperty(value="privateCustomData")
    public void setPrivateCustomData(Object privateCustomData) {
        this.privateCustomData = privateCustomData;
    }

    @JsonProperty(value="createdDate")
    @JsonDeserialize(using=LongTimestampDeserializer.class)
    public void setCreatedDate(Long createdDate) {
        this.createdDate = createdDate;
    }

    @JsonProperty(value="lastSeenDate")
    @JsonDeserialize(using=LongTimestampDeserializer.class)
    public void setLastSeenDate(Long lastSeenDate) {
        this.lastSeenDate = lastSeenDate;
    }

    @JsonProperty(value="platform")
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    @JsonProperty(value="platformVersion")
    public void setPlatformVersion(String platformVersion) {
        this.platformVersion = platformVersion;
    }

    @JsonProperty(value="sdkType")
    public void setSdkType(PlatformData.SdkTypeEnum sdkType) {
        this.sdkType = sdkType;
    }

    @JsonProperty(value="sdkVersion")
    public void setSdkVersion(String sdkVersion) {
        this.sdkVersion = sdkVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User other = (User)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$createdDate = this.getCreatedDate();
        Long other$createdDate = other.getCreatedDate();
        if (this$createdDate == null ? other$createdDate != null : !((Object)this$createdDate).equals(other$createdDate)) {
            return false;
        }
        Long this$lastSeenDate = this.getLastSeenDate();
        Long other$lastSeenDate = other.getLastSeenDate();
        if (this$lastSeenDate == null ? other$lastSeenDate != null : !((Object)this$lastSeenDate).equals(other$lastSeenDate)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        String this$country = this.getCountry();
        String other$country = other.getCountry();
        if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
            return false;
        }
        String this$appVersion = this.getAppVersion();
        String other$appVersion = other.getAppVersion();
        if (this$appVersion == null ? other$appVersion != null : !this$appVersion.equals(other$appVersion)) {
            return false;
        }
        String this$appBuild = this.getAppBuild();
        String other$appBuild = other.getAppBuild();
        if (this$appBuild == null ? other$appBuild != null : !this$appBuild.equals(other$appBuild)) {
            return false;
        }
        Object this$customData = this.getCustomData();
        Object other$customData = other.getCustomData();
        if (this$customData == null ? other$customData != null : !this$customData.equals(other$customData)) {
            return false;
        }
        Object this$privateCustomData = this.getPrivateCustomData();
        Object other$privateCustomData = other.getPrivateCustomData();
        if (this$privateCustomData == null ? other$privateCustomData != null : !this$privateCustomData.equals(other$privateCustomData)) {
            return false;
        }
        String this$platform = this.getPlatform();
        String other$platform = other.getPlatform();
        if (this$platform == null ? other$platform != null : !this$platform.equals(other$platform)) {
            return false;
        }
        String this$platformVersion = this.getPlatformVersion();
        String other$platformVersion = other.getPlatformVersion();
        if (this$platformVersion == null ? other$platformVersion != null : !this$platformVersion.equals(other$platformVersion)) {
            return false;
        }
        PlatformData.SdkTypeEnum this$sdkType = this.getSdkType();
        PlatformData.SdkTypeEnum other$sdkType = other.getSdkType();
        if (this$sdkType == null ? other$sdkType != null : !((Object)((Object)this$sdkType)).equals((Object)other$sdkType)) {
            return false;
        }
        String this$sdkVersion = this.getSdkVersion();
        String other$sdkVersion = other.getSdkVersion();
        return !(this$sdkVersion == null ? other$sdkVersion != null : !this$sdkVersion.equals(other$sdkVersion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof User;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $createdDate = this.getCreatedDate();
        result = result * 59 + ($createdDate == null ? 43 : ((Object)$createdDate).hashCode());
        Long $lastSeenDate = this.getLastSeenDate();
        result = result * 59 + ($lastSeenDate == null ? 43 : ((Object)$lastSeenDate).hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        String $country = this.getCountry();
        result = result * 59 + ($country == null ? 43 : $country.hashCode());
        String $appVersion = this.getAppVersion();
        result = result * 59 + ($appVersion == null ? 43 : $appVersion.hashCode());
        String $appBuild = this.getAppBuild();
        result = result * 59 + ($appBuild == null ? 43 : $appBuild.hashCode());
        Object $customData = this.getCustomData();
        result = result * 59 + ($customData == null ? 43 : $customData.hashCode());
        Object $privateCustomData = this.getPrivateCustomData();
        result = result * 59 + ($privateCustomData == null ? 43 : $privateCustomData.hashCode());
        String $platform = this.getPlatform();
        result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
        String $platformVersion = this.getPlatformVersion();
        result = result * 59 + ($platformVersion == null ? 43 : $platformVersion.hashCode());
        PlatformData.SdkTypeEnum $sdkType = this.getSdkType();
        result = result * 59 + ($sdkType == null ? 43 : ((Object)((Object)$sdkType)).hashCode());
        String $sdkVersion = this.getSdkVersion();
        result = result * 59 + ($sdkVersion == null ? 43 : $sdkVersion.hashCode());
        return result;
    }

    public String toString() {
        return "User(userId=" + this.getUserId() + ", email=" + this.getEmail() + ", name=" + this.getName() + ", language=" + this.getLanguage() + ", country=" + this.getCountry() + ", appVersion=" + this.getAppVersion() + ", appBuild=" + this.getAppBuild() + ", customData=" + this.getCustomData() + ", privateCustomData=" + this.getPrivateCustomData() + ", createdDate=" + this.getCreatedDate() + ", lastSeenDate=" + this.getLastSeenDate() + ", platform=" + this.getPlatform() + ", platformVersion=" + this.getPlatformVersion() + ", sdkType=" + (Object)((Object)this.getSdkType()) + ", sdkVersion=" + this.getSdkVersion() + ")";
    }

    public User() {
        this.platform = User.$default$platform();
        this.platformVersion = User.$default$platformVersion();
        this.sdkType = User.$default$sdkType();
        this.sdkVersion = User.$default$sdkVersion();
    }

    public User(@NonNull String userId, String email, String name, String language, String country, String appVersion, String appBuild, Object customData, Object privateCustomData, Long createdDate, Long lastSeenDate, String platform, String platformVersion, PlatformData.SdkTypeEnum sdkType, String sdkVersion) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
        this.email = email;
        this.name = name;
        this.language = language;
        this.country = country;
        this.appVersion = appVersion;
        this.appBuild = appBuild;
        this.customData = customData;
        this.privateCustomData = privateCustomData;
        this.createdDate = createdDate;
        this.lastSeenDate = lastSeenDate;
        this.platform = platform;
        this.platformVersion = platformVersion;
        this.sdkType = sdkType;
        this.sdkVersion = sdkVersion;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class UserBuilder {
        private String userId;
        private String email;
        private String name;
        private String language;
        private String country;
        private String appVersion;
        private String appBuild;
        private Object customData;
        private Object privateCustomData;
        private Long createdDate;
        private Long lastSeenDate;
        private boolean platform$set;
        private String platform$value;
        private boolean platformVersion$set;
        private String platformVersion$value;
        private boolean sdkType$set;
        private PlatformData.SdkTypeEnum sdkType$value;
        private boolean sdkVersion$set;
        private String sdkVersion$value;

        UserBuilder() {
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        @JsonProperty(value="user_id")
        public UserBuilder userId(@NonNull String userId) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
            return this;
        }

        @JsonProperty(value="email")
        public UserBuilder email(String email) {
            this.email = email;
            return this;
        }

        @JsonProperty(value="name")
        public UserBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="language")
        public UserBuilder language(String language) {
            this.language = language;
            return this;
        }

        @JsonProperty(value="country")
        public UserBuilder country(String country) {
            this.country = country;
            return this;
        }

        @JsonProperty(value="appVersion")
        public UserBuilder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        @JsonProperty(value="appBuild")
        public UserBuilder appBuild(String appBuild) {
            this.appBuild = appBuild;
            return this;
        }

        @JsonProperty(value="customData")
        public UserBuilder customData(Object customData) {
            this.customData = customData;
            return this;
        }

        @JsonProperty(value="privateCustomData")
        public UserBuilder privateCustomData(Object privateCustomData) {
            this.privateCustomData = privateCustomData;
            return this;
        }

        @JsonProperty(value="createdDate")
        @JsonDeserialize(using=LongTimestampDeserializer.class)
        public UserBuilder createdDate(Long createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        @JsonProperty(value="lastSeenDate")
        @JsonDeserialize(using=LongTimestampDeserializer.class)
        public UserBuilder lastSeenDate(Long lastSeenDate) {
            this.lastSeenDate = lastSeenDate;
            return this;
        }

        @JsonProperty(value="platform")
        public UserBuilder platform(String platform) {
            this.platform$value = platform;
            this.platform$set = true;
            return this;
        }

        @JsonProperty(value="platformVersion")
        public UserBuilder platformVersion(String platformVersion) {
            this.platformVersion$value = platformVersion;
            this.platformVersion$set = true;
            return this;
        }

        @JsonProperty(value="sdkType")
        public UserBuilder sdkType(PlatformData.SdkTypeEnum sdkType) {
            this.sdkType$value = sdkType;
            this.sdkType$set = true;
            return this;
        }

        @JsonProperty(value="sdkVersion")
        public UserBuilder sdkVersion(String sdkVersion) {
            this.sdkVersion$value = sdkVersion;
            this.sdkVersion$set = true;
            return this;
        }

        public User build() {
            String platform$value = this.platform$value;
            if (!this.platform$set) {
                platform$value = User.$default$platform();
            }
            String platformVersion$value = this.platformVersion$value;
            if (!this.platformVersion$set) {
                platformVersion$value = User.$default$platformVersion();
            }
            PlatformData.SdkTypeEnum sdkType$value = this.sdkType$value;
            if (!this.sdkType$set) {
                sdkType$value = User.$default$sdkType();
            }
            String sdkVersion$value = this.sdkVersion$value;
            if (!this.sdkVersion$set) {
                sdkVersion$value = User.$default$sdkVersion();
            }
            return new User(this.userId, this.email, this.name, this.language, this.country, this.appVersion, this.appBuild, this.customData, this.privateCustomData, this.createdDate, this.lastSeenDate, platform$value, platformVersion$value, sdkType$value, sdkVersion$value);
        }

        public String toString() {
            return "User.UserBuilder(userId=" + this.userId + ", email=" + this.email + ", name=" + this.name + ", language=" + this.language + ", country=" + this.country + ", appVersion=" + this.appVersion + ", appBuild=" + this.appBuild + ", customData=" + this.customData + ", privateCustomData=" + this.privateCustomData + ", createdDate=" + this.createdDate + ", lastSeenDate=" + this.lastSeenDate + ", platform$value=" + this.platform$value + ", platformVersion$value=" + this.platformVersion$value + ", sdkType$value=" + (Object)((Object)this.sdkType$value) + ", sdkVersion$value=" + this.sdkVersion$value + ")";
        }
    }
}

