/*
 * Decompiled with CFR 0.152.
 */
package com.devcycle.sdk.server.local.model;

import com.devcycle.sdk.server.common.api.IRestOptions;
import com.devcycle.sdk.server.common.logging.DevCycleLogger;
import com.devcycle.sdk.server.common.logging.IDevCycleLogger;
import com.devcycle.sdk.server.common.model.IDevCycleOptions;
import com.fasterxml.jackson.annotation.JsonIgnore;

public class DevCycleLocalOptions
implements IDevCycleOptions {
    private int configRequestTimeoutMs = 10000;
    private int configPollingIntervalMS = 30000;
    private String configCdnBaseUrl = "https://config-cdn.devcycle.com/";
    private String eventsApiBaseUrl = "https://events.devcycle.com/";
    private int eventFlushIntervalMS = 10000;
    private int flushEventQueueSize = 1000;
    private int maxEventQueueSize = 2000;
    private int eventRequestChunkSize = 100;
    private boolean disableAutomaticEventLogging = false;
    private boolean disableRealtimeUpdates = false;
    @Deprecated
    private boolean enableBetaRealtimeUpdates = false;
    @JsonIgnore
    private IDevCycleLogger customLogger = null;
    private boolean disableCustomEventLogging = false;
    @JsonIgnore
    private IRestOptions restOptions = null;

    public DevCycleLocalOptions(int configRequestTimeoutMs, @Deprecated int configPollingIntervalMs, int configPollingIntervalMS, String configCdnBaseUrl, String eventsApiBaseUrl, int eventFlushIntervalMS, int flushEventQueueSize, int maxEventQueueSize, int eventRequestChunkSize, boolean disableAutomaticEventLogging, boolean disableCustomEventLogging, IDevCycleLogger customLogger, IRestOptions restOptions, @Deprecated boolean enableBetaRealtimeUpdates, boolean disableRealtimeUpdates) {
        this.configRequestTimeoutMs = configRequestTimeoutMs > 0 ? configRequestTimeoutMs : this.configRequestTimeoutMs;
        this.configPollingIntervalMS = this.getConfigPollingIntervalMS(configPollingIntervalMs, configPollingIntervalMS);
        this.configCdnBaseUrl = configCdnBaseUrl != null ? configCdnBaseUrl : this.configCdnBaseUrl;
        this.eventsApiBaseUrl = eventsApiBaseUrl != null ? eventsApiBaseUrl : this.eventsApiBaseUrl;
        this.eventFlushIntervalMS = eventFlushIntervalMS > 0 ? eventFlushIntervalMS : this.eventFlushIntervalMS;
        this.flushEventQueueSize = flushEventQueueSize > 0 ? flushEventQueueSize : this.flushEventQueueSize;
        this.maxEventQueueSize = maxEventQueueSize > 0 ? maxEventQueueSize : this.maxEventQueueSize;
        this.eventRequestChunkSize = eventRequestChunkSize > 0 ? eventRequestChunkSize : this.eventRequestChunkSize;
        this.disableAutomaticEventLogging = disableAutomaticEventLogging;
        this.disableCustomEventLogging = disableCustomEventLogging;
        this.customLogger = customLogger;
        this.restOptions = restOptions;
        this.enableBetaRealtimeUpdates = enableBetaRealtimeUpdates;
        this.disableRealtimeUpdates = disableRealtimeUpdates;
        if (this.flushEventQueueSize >= this.maxEventQueueSize) {
            DevCycleLogger.warning("flushEventQueueSize: " + this.flushEventQueueSize + " must be smaller than maxEventQueueSize: " + this.maxEventQueueSize);
            this.flushEventQueueSize = this.maxEventQueueSize - 1;
        }
        if (this.eventRequestChunkSize > this.flushEventQueueSize) {
            DevCycleLogger.warning("eventRequestChunkSize: " + this.eventRequestChunkSize + " must be smaller than flushEventQueueSize: " + this.flushEventQueueSize);
            this.eventRequestChunkSize = 100;
        }
        if (this.eventRequestChunkSize > this.maxEventQueueSize) {
            DevCycleLogger.warning("eventRequestChunkSize: " + this.eventRequestChunkSize + " must be smaller than maxEventQueueSize: " + this.maxEventQueueSize);
            this.eventRequestChunkSize = 100;
        }
        if (this.flushEventQueueSize > 20000) {
            DevCycleLogger.warning("flushEventQueueSize: " + this.flushEventQueueSize + " must be smaller than 20,000");
            this.flushEventQueueSize = 20000;
        }
        if (this.maxEventQueueSize > 20000) {
            DevCycleLogger.warning("maxEventQueueSize: " + this.maxEventQueueSize + " must be smaller than 20,000");
            this.maxEventQueueSize = 20000;
        }
    }

    public int getConfigPollingIntervalMS(int configPollingIntervalMs, int configPollingIntervalMS) {
        if (configPollingIntervalMS > 0) {
            return configPollingIntervalMS;
        }
        if (configPollingIntervalMs > 0) {
            return configPollingIntervalMs;
        }
        return this.configPollingIntervalMS;
    }

    public static DevCycleLocalOptionsBuilder builder() {
        return new DevCycleLocalOptionsBuilder();
    }

    public int getConfigRequestTimeoutMs() {
        return this.configRequestTimeoutMs;
    }

    public int getConfigPollingIntervalMS() {
        return this.configPollingIntervalMS;
    }

    public String getConfigCdnBaseUrl() {
        return this.configCdnBaseUrl;
    }

    public String getEventsApiBaseUrl() {
        return this.eventsApiBaseUrl;
    }

    public int getEventFlushIntervalMS() {
        return this.eventFlushIntervalMS;
    }

    public int getFlushEventQueueSize() {
        return this.flushEventQueueSize;
    }

    public int getMaxEventQueueSize() {
        return this.maxEventQueueSize;
    }

    public int getEventRequestChunkSize() {
        return this.eventRequestChunkSize;
    }

    public boolean isDisableAutomaticEventLogging() {
        return this.disableAutomaticEventLogging;
    }

    public boolean isDisableRealtimeUpdates() {
        return this.disableRealtimeUpdates;
    }

    @Deprecated
    public boolean isEnableBetaRealtimeUpdates() {
        return this.enableBetaRealtimeUpdates;
    }

    public IDevCycleLogger getCustomLogger() {
        return this.customLogger;
    }

    public boolean isDisableCustomEventLogging() {
        return this.disableCustomEventLogging;
    }

    public IRestOptions getRestOptions() {
        return this.restOptions;
    }

    public void setConfigRequestTimeoutMs(int configRequestTimeoutMs) {
        this.configRequestTimeoutMs = configRequestTimeoutMs;
    }

    public void setConfigPollingIntervalMS(int configPollingIntervalMS) {
        this.configPollingIntervalMS = configPollingIntervalMS;
    }

    public void setConfigCdnBaseUrl(String configCdnBaseUrl) {
        this.configCdnBaseUrl = configCdnBaseUrl;
    }

    public void setEventsApiBaseUrl(String eventsApiBaseUrl) {
        this.eventsApiBaseUrl = eventsApiBaseUrl;
    }

    public void setEventFlushIntervalMS(int eventFlushIntervalMS) {
        this.eventFlushIntervalMS = eventFlushIntervalMS;
    }

    public void setFlushEventQueueSize(int flushEventQueueSize) {
        this.flushEventQueueSize = flushEventQueueSize;
    }

    public void setMaxEventQueueSize(int maxEventQueueSize) {
        this.maxEventQueueSize = maxEventQueueSize;
    }

    public void setEventRequestChunkSize(int eventRequestChunkSize) {
        this.eventRequestChunkSize = eventRequestChunkSize;
    }

    public void setDisableAutomaticEventLogging(boolean disableAutomaticEventLogging) {
        this.disableAutomaticEventLogging = disableAutomaticEventLogging;
    }

    public void setDisableRealtimeUpdates(boolean disableRealtimeUpdates) {
        this.disableRealtimeUpdates = disableRealtimeUpdates;
    }

    @Deprecated
    public void setEnableBetaRealtimeUpdates(boolean enableBetaRealtimeUpdates) {
        this.enableBetaRealtimeUpdates = enableBetaRealtimeUpdates;
    }

    @JsonIgnore
    public void setCustomLogger(IDevCycleLogger customLogger) {
        this.customLogger = customLogger;
    }

    public void setDisableCustomEventLogging(boolean disableCustomEventLogging) {
        this.disableCustomEventLogging = disableCustomEventLogging;
    }

    @JsonIgnore
    public void setRestOptions(IRestOptions restOptions) {
        this.restOptions = restOptions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DevCycleLocalOptions)) {
            return false;
        }
        DevCycleLocalOptions other = (DevCycleLocalOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getConfigRequestTimeoutMs() != other.getConfigRequestTimeoutMs()) {
            return false;
        }
        if (this.getConfigPollingIntervalMS() != other.getConfigPollingIntervalMS()) {
            return false;
        }
        if (this.getEventFlushIntervalMS() != other.getEventFlushIntervalMS()) {
            return false;
        }
        if (this.getFlushEventQueueSize() != other.getFlushEventQueueSize()) {
            return false;
        }
        if (this.getMaxEventQueueSize() != other.getMaxEventQueueSize()) {
            return false;
        }
        if (this.getEventRequestChunkSize() != other.getEventRequestChunkSize()) {
            return false;
        }
        if (this.isDisableAutomaticEventLogging() != other.isDisableAutomaticEventLogging()) {
            return false;
        }
        if (this.isDisableRealtimeUpdates() != other.isDisableRealtimeUpdates()) {
            return false;
        }
        if (this.isEnableBetaRealtimeUpdates() != other.isEnableBetaRealtimeUpdates()) {
            return false;
        }
        if (this.isDisableCustomEventLogging() != other.isDisableCustomEventLogging()) {
            return false;
        }
        String this$configCdnBaseUrl = this.getConfigCdnBaseUrl();
        String other$configCdnBaseUrl = other.getConfigCdnBaseUrl();
        if (this$configCdnBaseUrl == null ? other$configCdnBaseUrl != null : !this$configCdnBaseUrl.equals(other$configCdnBaseUrl)) {
            return false;
        }
        String this$eventsApiBaseUrl = this.getEventsApiBaseUrl();
        String other$eventsApiBaseUrl = other.getEventsApiBaseUrl();
        if (this$eventsApiBaseUrl == null ? other$eventsApiBaseUrl != null : !this$eventsApiBaseUrl.equals(other$eventsApiBaseUrl)) {
            return false;
        }
        IDevCycleLogger this$customLogger = this.getCustomLogger();
        IDevCycleLogger other$customLogger = other.getCustomLogger();
        if (this$customLogger == null ? other$customLogger != null : !this$customLogger.equals(other$customLogger)) {
            return false;
        }
        IRestOptions this$restOptions = this.getRestOptions();
        IRestOptions other$restOptions = other.getRestOptions();
        return !(this$restOptions == null ? other$restOptions != null : !this$restOptions.equals(other$restOptions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DevCycleLocalOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getConfigRequestTimeoutMs();
        result = result * 59 + this.getConfigPollingIntervalMS();
        result = result * 59 + this.getEventFlushIntervalMS();
        result = result * 59 + this.getFlushEventQueueSize();
        result = result * 59 + this.getMaxEventQueueSize();
        result = result * 59 + this.getEventRequestChunkSize();
        result = result * 59 + (this.isDisableAutomaticEventLogging() ? 79 : 97);
        result = result * 59 + (this.isDisableRealtimeUpdates() ? 79 : 97);
        result = result * 59 + (this.isEnableBetaRealtimeUpdates() ? 79 : 97);
        result = result * 59 + (this.isDisableCustomEventLogging() ? 79 : 97);
        String $configCdnBaseUrl = this.getConfigCdnBaseUrl();
        result = result * 59 + ($configCdnBaseUrl == null ? 43 : $configCdnBaseUrl.hashCode());
        String $eventsApiBaseUrl = this.getEventsApiBaseUrl();
        result = result * 59 + ($eventsApiBaseUrl == null ? 43 : $eventsApiBaseUrl.hashCode());
        IDevCycleLogger $customLogger = this.getCustomLogger();
        result = result * 59 + ($customLogger == null ? 43 : $customLogger.hashCode());
        IRestOptions $restOptions = this.getRestOptions();
        result = result * 59 + ($restOptions == null ? 43 : $restOptions.hashCode());
        return result;
    }

    public String toString() {
        return "DevCycleLocalOptions(configRequestTimeoutMs=" + this.getConfigRequestTimeoutMs() + ", configPollingIntervalMS=" + this.getConfigPollingIntervalMS() + ", configCdnBaseUrl=" + this.getConfigCdnBaseUrl() + ", eventsApiBaseUrl=" + this.getEventsApiBaseUrl() + ", eventFlushIntervalMS=" + this.getEventFlushIntervalMS() + ", flushEventQueueSize=" + this.getFlushEventQueueSize() + ", maxEventQueueSize=" + this.getMaxEventQueueSize() + ", eventRequestChunkSize=" + this.getEventRequestChunkSize() + ", disableAutomaticEventLogging=" + this.isDisableAutomaticEventLogging() + ", disableRealtimeUpdates=" + this.isDisableRealtimeUpdates() + ", enableBetaRealtimeUpdates=" + this.isEnableBetaRealtimeUpdates() + ", customLogger=" + this.getCustomLogger() + ", disableCustomEventLogging=" + this.isDisableCustomEventLogging() + ", restOptions=" + this.getRestOptions() + ")";
    }

    public static class DevCycleLocalOptionsBuilder {
        private int configRequestTimeoutMs;
        private int configPollingIntervalMs;
        private int configPollingIntervalMS;
        private String configCdnBaseUrl;
        private String eventsApiBaseUrl;
        private int eventFlushIntervalMS;
        private int flushEventQueueSize;
        private int maxEventQueueSize;
        private int eventRequestChunkSize;
        private boolean disableAutomaticEventLogging;
        private boolean disableCustomEventLogging;
        private IDevCycleLogger customLogger;
        private IRestOptions restOptions;
        private boolean enableBetaRealtimeUpdates;
        private boolean disableRealtimeUpdates;

        DevCycleLocalOptionsBuilder() {
        }

        public DevCycleLocalOptionsBuilder configRequestTimeoutMs(int configRequestTimeoutMs) {
            this.configRequestTimeoutMs = configRequestTimeoutMs;
            return this;
        }

        @Deprecated
        public DevCycleLocalOptionsBuilder configPollingIntervalMs(int configPollingIntervalMs) {
            this.configPollingIntervalMs = configPollingIntervalMs;
            return this;
        }

        public DevCycleLocalOptionsBuilder configPollingIntervalMS(int configPollingIntervalMS) {
            this.configPollingIntervalMS = configPollingIntervalMS;
            return this;
        }

        public DevCycleLocalOptionsBuilder configCdnBaseUrl(String configCdnBaseUrl) {
            this.configCdnBaseUrl = configCdnBaseUrl;
            return this;
        }

        public DevCycleLocalOptionsBuilder eventsApiBaseUrl(String eventsApiBaseUrl) {
            this.eventsApiBaseUrl = eventsApiBaseUrl;
            return this;
        }

        public DevCycleLocalOptionsBuilder eventFlushIntervalMS(int eventFlushIntervalMS) {
            this.eventFlushIntervalMS = eventFlushIntervalMS;
            return this;
        }

        public DevCycleLocalOptionsBuilder flushEventQueueSize(int flushEventQueueSize) {
            this.flushEventQueueSize = flushEventQueueSize;
            return this;
        }

        public DevCycleLocalOptionsBuilder maxEventQueueSize(int maxEventQueueSize) {
            this.maxEventQueueSize = maxEventQueueSize;
            return this;
        }

        public DevCycleLocalOptionsBuilder eventRequestChunkSize(int eventRequestChunkSize) {
            this.eventRequestChunkSize = eventRequestChunkSize;
            return this;
        }

        public DevCycleLocalOptionsBuilder disableAutomaticEventLogging(boolean disableAutomaticEventLogging) {
            this.disableAutomaticEventLogging = disableAutomaticEventLogging;
            return this;
        }

        public DevCycleLocalOptionsBuilder disableCustomEventLogging(boolean disableCustomEventLogging) {
            this.disableCustomEventLogging = disableCustomEventLogging;
            return this;
        }

        public DevCycleLocalOptionsBuilder customLogger(IDevCycleLogger customLogger) {
            this.customLogger = customLogger;
            return this;
        }

        public DevCycleLocalOptionsBuilder restOptions(IRestOptions restOptions) {
            this.restOptions = restOptions;
            return this;
        }

        @Deprecated
        public DevCycleLocalOptionsBuilder enableBetaRealtimeUpdates(boolean enableBetaRealtimeUpdates) {
            this.enableBetaRealtimeUpdates = enableBetaRealtimeUpdates;
            return this;
        }

        public DevCycleLocalOptionsBuilder disableRealtimeUpdates(boolean disableRealtimeUpdates) {
            this.disableRealtimeUpdates = disableRealtimeUpdates;
            return this;
        }

        public DevCycleLocalOptions build() {
            return new DevCycleLocalOptions(this.configRequestTimeoutMs, this.configPollingIntervalMs, this.configPollingIntervalMS, this.configCdnBaseUrl, this.eventsApiBaseUrl, this.eventFlushIntervalMS, this.flushEventQueueSize, this.maxEventQueueSize, this.eventRequestChunkSize, this.disableAutomaticEventLogging, this.disableCustomEventLogging, this.customLogger, this.restOptions, this.enableBetaRealtimeUpdates, this.disableRealtimeUpdates);
        }

        public String toString() {
            return "DevCycleLocalOptions.DevCycleLocalOptionsBuilder(configRequestTimeoutMs=" + this.configRequestTimeoutMs + ", configPollingIntervalMs=" + this.configPollingIntervalMs + ", configPollingIntervalMS=" + this.configPollingIntervalMS + ", configCdnBaseUrl=" + this.configCdnBaseUrl + ", eventsApiBaseUrl=" + this.eventsApiBaseUrl + ", eventFlushIntervalMS=" + this.eventFlushIntervalMS + ", flushEventQueueSize=" + this.flushEventQueueSize + ", maxEventQueueSize=" + this.maxEventQueueSize + ", eventRequestChunkSize=" + this.eventRequestChunkSize + ", disableAutomaticEventLogging=" + this.disableAutomaticEventLogging + ", disableCustomEventLogging=" + this.disableCustomEventLogging + ", customLogger=" + this.customLogger + ", restOptions=" + this.restOptions + ", enableBetaRealtimeUpdates=" + this.enableBetaRealtimeUpdates + ", disableRealtimeUpdates=" + this.disableRealtimeUpdates + ")";
        }
    }
}

