/*
 * Decompiled with CFR 0.152.
 */
package com.devcycle.sdk.server.common.model;

import com.devcycle.sdk.server.common.model.EvalReason;
import com.devcycle.sdk.server.common.model.Variable;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BaseVariable {
    @Schema(required=true, description="unique database id")
    @JsonProperty(value="_id")
    private String id;
    @Schema(required=true, description="Unique key by Project, can be used in the SDK / API to reference by 'key' rather than _id.")
    private String key;
    @Schema(required=true, description="Variable type")
    private Variable.TypeEnum type;
    @Schema(required=true, description="Variable value can be a string, number, boolean, or JSON")
    private Object value;
    @Schema(description="Evaluation reason")
    private EvalReason eval;
    @Schema(description="Feature ID")
    @JsonProperty(value="_feature")
    private String featureId;

    public static BaseVariableBuilder builder() {
        return new BaseVariableBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public Variable.TypeEnum getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public EvalReason getEval() {
        return this.eval;
    }

    public String getFeatureId() {
        return this.featureId;
    }

    @JsonProperty(value="_id")
    public void setId(String id) {
        this.id = id;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setType(Variable.TypeEnum type) {
        this.type = type;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setEval(EvalReason eval) {
        this.eval = eval;
    }

    @JsonProperty(value="_feature")
    public void setFeatureId(String featureId) {
        this.featureId = featureId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseVariable)) {
            return false;
        }
        BaseVariable other = (BaseVariable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        Variable.TypeEnum this$type = this.getType();
        Variable.TypeEnum other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        EvalReason this$eval = this.getEval();
        EvalReason other$eval = other.getEval();
        if (this$eval == null ? other$eval != null : !((Object)this$eval).equals(other$eval)) {
            return false;
        }
        String this$featureId = this.getFeatureId();
        String other$featureId = other.getFeatureId();
        return !(this$featureId == null ? other$featureId != null : !this$featureId.equals(other$featureId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseVariable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        Variable.TypeEnum $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        EvalReason $eval = this.getEval();
        result = result * 59 + ($eval == null ? 43 : ((Object)$eval).hashCode());
        String $featureId = this.getFeatureId();
        result = result * 59 + ($featureId == null ? 43 : $featureId.hashCode());
        return result;
    }

    public String toString() {
        return "BaseVariable(id=" + this.getId() + ", key=" + this.getKey() + ", type=" + this.getType() + ", value=" + this.getValue() + ", eval=" + this.getEval() + ", featureId=" + this.getFeatureId() + ")";
    }

    public BaseVariable(String id, String key, Variable.TypeEnum type, Object value, EvalReason eval, String featureId) {
        this.id = id;
        this.key = key;
        this.type = type;
        this.value = value;
        this.eval = eval;
        this.featureId = featureId;
    }

    public BaseVariable() {
    }

    public static class BaseVariableBuilder {
        private String id;
        private String key;
        private Variable.TypeEnum type;
        private Object value;
        private EvalReason eval;
        private String featureId;

        BaseVariableBuilder() {
        }

        @JsonProperty(value="_id")
        public BaseVariableBuilder id(String id) {
            this.id = id;
            return this;
        }

        public BaseVariableBuilder key(String key) {
            this.key = key;
            return this;
        }

        public BaseVariableBuilder type(Variable.TypeEnum type) {
            this.type = type;
            return this;
        }

        public BaseVariableBuilder value(Object value) {
            this.value = value;
            return this;
        }

        public BaseVariableBuilder eval(EvalReason eval) {
            this.eval = eval;
            return this;
        }

        @JsonProperty(value="_feature")
        public BaseVariableBuilder featureId(String featureId) {
            this.featureId = featureId;
            return this;
        }

        public BaseVariable build() {
            return new BaseVariable(this.id, this.key, this.type, this.value, this.eval, this.featureId);
        }

        public String toString() {
            return "BaseVariable.BaseVariableBuilder(id=" + this.id + ", key=" + this.key + ", type=" + this.type + ", value=" + this.value + ", eval=" + this.eval + ", featureId=" + this.featureId + ")";
        }
    }
}

