/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.admin.api;

import com.docusign.admin.client.ApiClient;
import com.docusign.admin.client.ApiException;
import com.docusign.admin.client.ApiResponse;
import com.docusign.admin.client.Configuration;
import com.docusign.admin.client.Pair;
import com.docusign.admin.model.OrganizationAccountSettingsImportResponse;
import com.docusign.admin.model.OrganizationImportResponse;
import com.docusign.admin.model.OrganizationImportsResponse;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public class BulkImportsApi {
    private ApiClient apiClient;

    public BulkImportsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BulkImportsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public OrganizationAccountSettingsImportResponse addBulkAccountSettingsImport(UUID organizationId, byte[] fileCsv) throws ApiException {
        ApiResponse<OrganizationAccountSettingsImportResponse> localVarResponse = this.addBulkAccountSettingsImportWithHttpInfo(organizationId, fileCsv);
        return localVarResponse.getData();
    }

    public ApiResponse<OrganizationAccountSettingsImportResponse> addBulkAccountSettingsImportWithHttpInfo(UUID organizationId, byte[] fileCsv) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling addBulkAccountSettingsImport");
        }
        String localVarPath = "/v2/organizations/{organizationId}/imports/account_settings".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fileCsv != null) {
            localVarFormParams.put("file.csv", fileCsv);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<OrganizationAccountSettingsImportResponse> localVarReturnType = new GenericType<OrganizationAccountSettingsImportResponse>(){};
        OrganizationAccountSettingsImportResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<OrganizationAccountSettingsImportResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public OrganizationImportResponse createBulkImportAddUsersRequest(UUID organizationId, byte[] fileCsv) throws ApiException {
        ApiResponse<OrganizationImportResponse> localVarResponse = this.createBulkImportAddUsersRequestWithHttpInfo(organizationId, fileCsv);
        return localVarResponse.getData();
    }

    public ApiResponse<OrganizationImportResponse> createBulkImportAddUsersRequestWithHttpInfo(UUID organizationId, byte[] fileCsv) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling createBulkImportAddUsersRequest");
        }
        String localVarPath = "/v2/organizations/{organizationId}/imports/bulk_users/add".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fileCsv != null) {
            localVarFormParams.put("file.csv", fileCsv);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<OrganizationImportResponse> localVarReturnType = new GenericType<OrganizationImportResponse>(){};
        OrganizationImportResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<OrganizationImportResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public OrganizationImportResponse createBulkImportCloseUsersRequest(UUID organizationId, byte[] fileCsv) throws ApiException {
        ApiResponse<OrganizationImportResponse> localVarResponse = this.createBulkImportCloseUsersRequestWithHttpInfo(organizationId, fileCsv);
        return localVarResponse.getData();
    }

    public ApiResponse<OrganizationImportResponse> createBulkImportCloseUsersRequestWithHttpInfo(UUID organizationId, byte[] fileCsv) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling createBulkImportCloseUsersRequest");
        }
        String localVarPath = "/v2/organizations/{organizationId}/imports/bulk_users/close".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fileCsv != null) {
            localVarFormParams.put("file.csv", fileCsv);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<OrganizationImportResponse> localVarReturnType = new GenericType<OrganizationImportResponse>(){};
        OrganizationImportResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<OrganizationImportResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public OrganizationImportResponse createBulkImportExternalCloseUsersRequest(UUID organizationId) throws ApiException {
        ApiResponse<OrganizationImportResponse> localVarResponse = this.createBulkImportExternalCloseUsersRequestWithHttpInfo(organizationId);
        return localVarResponse.getData();
    }

    public ApiResponse<OrganizationImportResponse> createBulkImportExternalCloseUsersRequestWithHttpInfo(UUID organizationId) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling createBulkImportExternalCloseUsersRequest");
        }
        String localVarPath = "/v2/organizations/{organizationId}/imports/bulk_users/close_external".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<OrganizationImportResponse> localVarReturnType = new GenericType<OrganizationImportResponse>(){};
        OrganizationImportResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<OrganizationImportResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public OrganizationImportResponse createBulkImportSingleAccountAddUsersRequest(UUID organizationId, UUID accountId, byte[] fileCsv) throws ApiException {
        ApiResponse<OrganizationImportResponse> localVarResponse = this.createBulkImportSingleAccountAddUsersRequestWithHttpInfo(organizationId, accountId, fileCsv);
        return localVarResponse.getData();
    }

    public ApiResponse<OrganizationImportResponse> createBulkImportSingleAccountAddUsersRequestWithHttpInfo(UUID organizationId, UUID accountId, byte[] fileCsv) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling createBulkImportSingleAccountAddUsersRequest");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createBulkImportSingleAccountAddUsersRequest");
        }
        String localVarPath = "/v2/organizations/{organizationId}/accounts/{accountId}/imports/bulk_users/add".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fileCsv != null) {
            localVarFormParams.put("file.csv", fileCsv);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<OrganizationImportResponse> localVarReturnType = new GenericType<OrganizationImportResponse>(){};
        OrganizationImportResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<OrganizationImportResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public OrganizationImportResponse createBulkImportSingleAccountUpdateUsersRequest(UUID organizationId, UUID accountId, byte[] fileCsv) throws ApiException {
        ApiResponse<OrganizationImportResponse> localVarResponse = this.createBulkImportSingleAccountUpdateUsersRequestWithHttpInfo(organizationId, accountId, fileCsv);
        return localVarResponse.getData();
    }

    public ApiResponse<OrganizationImportResponse> createBulkImportSingleAccountUpdateUsersRequestWithHttpInfo(UUID organizationId, UUID accountId, byte[] fileCsv) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling createBulkImportSingleAccountUpdateUsersRequest");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createBulkImportSingleAccountUpdateUsersRequest");
        }
        String localVarPath = "/v2/organizations/{organizationId}/accounts/{accountId}/imports/bulk_users/update".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fileCsv != null) {
            localVarFormParams.put("file.csv", fileCsv);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<OrganizationImportResponse> localVarReturnType = new GenericType<OrganizationImportResponse>(){};
        OrganizationImportResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<OrganizationImportResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public OrganizationImportResponse createBulkImportUpdateUsersRequest(UUID organizationId, byte[] fileCsv) throws ApiException {
        ApiResponse<OrganizationImportResponse> localVarResponse = this.createBulkImportUpdateUsersRequestWithHttpInfo(organizationId, fileCsv);
        return localVarResponse.getData();
    }

    public ApiResponse<OrganizationImportResponse> createBulkImportUpdateUsersRequestWithHttpInfo(UUID organizationId, byte[] fileCsv) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling createBulkImportUpdateUsersRequest");
        }
        String localVarPath = "/v2/organizations/{organizationId}/imports/bulk_users/update".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fileCsv != null) {
            localVarFormParams.put("file.csv", fileCsv);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<OrganizationImportResponse> localVarReturnType = new GenericType<OrganizationImportResponse>(){};
        OrganizationImportResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<OrganizationImportResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Object deleteBulkAccountSettingsImport(UUID organizationId, UUID importId) throws ApiException {
        ApiResponse<Object> localVarResponse = this.deleteBulkAccountSettingsImportWithHttpInfo(organizationId, importId);
        return localVarResponse.getData();
    }

    public ApiResponse<Object> deleteBulkAccountSettingsImportWithHttpInfo(UUID organizationId, UUID importId) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling deleteBulkAccountSettingsImport");
        }
        if (importId == null) {
            throw new ApiException(400, "Missing the required parameter 'importId' when calling deleteBulkAccountSettingsImport");
        }
        String localVarPath = "/v2/organizations/{organizationId}/imports/account_settings/{importId}".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{importId\\}", this.apiClient.escapeString(importId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        Object localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Object deleteBulkUserImport(UUID organizationId, UUID importId) throws ApiException {
        ApiResponse<Object> localVarResponse = this.deleteBulkUserImportWithHttpInfo(organizationId, importId);
        return localVarResponse.getData();
    }

    public ApiResponse<Object> deleteBulkUserImportWithHttpInfo(UUID organizationId, UUID importId) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling deleteBulkUserImport");
        }
        if (importId == null) {
            throw new ApiException(400, "Missing the required parameter 'importId' when calling deleteBulkUserImport");
        }
        String localVarPath = "/v2/organizations/{organizationId}/imports/bulk_users/{importId}".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{importId\\}", this.apiClient.escapeString(importId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        Object localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public OrganizationAccountSettingsImportResponse getBulkAccountSettingsImport(UUID organizationId, UUID importId) throws ApiException {
        ApiResponse<OrganizationAccountSettingsImportResponse> localVarResponse = this.getBulkAccountSettingsImportWithHttpInfo(organizationId, importId);
        return localVarResponse.getData();
    }

    public ApiResponse<OrganizationAccountSettingsImportResponse> getBulkAccountSettingsImportWithHttpInfo(UUID organizationId, UUID importId) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling getBulkAccountSettingsImport");
        }
        if (importId == null) {
            throw new ApiException(400, "Missing the required parameter 'importId' when calling getBulkAccountSettingsImport");
        }
        String localVarPath = "/v2/organizations/{organizationId}/imports/account_settings/{importId}".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{importId\\}", this.apiClient.escapeString(importId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<OrganizationAccountSettingsImportResponse> localVarReturnType = new GenericType<OrganizationAccountSettingsImportResponse>(){};
        OrganizationAccountSettingsImportResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<OrganizationAccountSettingsImportResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public List<OrganizationAccountSettingsImportResponse> getBulkAccountSettingsImports(UUID organizationId) throws ApiException {
        ApiResponse<List<OrganizationAccountSettingsImportResponse>> localVarResponse = this.getBulkAccountSettingsImportsWithHttpInfo(organizationId);
        return localVarResponse.getData();
    }

    public ApiResponse<List<OrganizationAccountSettingsImportResponse>> getBulkAccountSettingsImportsWithHttpInfo(UUID organizationId) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling getBulkAccountSettingsImports");
        }
        String localVarPath = "/v2/organizations/{organizationId}/imports/account_settings".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<List<OrganizationAccountSettingsImportResponse>> localVarReturnType = new GenericType<List<OrganizationAccountSettingsImportResponse>>(){};
        List<OrganizationAccountSettingsImportResponse> localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<List<OrganizationAccountSettingsImportResponse>>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Object getBulkUserImportCSV(UUID organizationId, UUID importId) throws ApiException {
        ApiResponse<Object> localVarResponse = this.getBulkUserImportCSVWithHttpInfo(organizationId, importId);
        return localVarResponse.getData();
    }

    public ApiResponse<Object> getBulkUserImportCSVWithHttpInfo(UUID organizationId, UUID importId) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling getBulkUserImportCSV");
        }
        if (importId == null) {
            throw new ApiException(400, "Missing the required parameter 'importId' when calling getBulkUserImportCSV");
        }
        String localVarPath = "/v2/organizations/{organizationId}/imports/bulk_users/{importId}/results_csv".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{importId\\}", this.apiClient.escapeString(importId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/csv"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        Object localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public OrganizationImportResponse getBulkUserImportRequest(UUID organizationId, UUID importId) throws ApiException {
        ApiResponse<OrganizationImportResponse> localVarResponse = this.getBulkUserImportRequestWithHttpInfo(organizationId, importId);
        return localVarResponse.getData();
    }

    public ApiResponse<OrganizationImportResponse> getBulkUserImportRequestWithHttpInfo(UUID organizationId, UUID importId) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling getBulkUserImportRequest");
        }
        if (importId == null) {
            throw new ApiException(400, "Missing the required parameter 'importId' when calling getBulkUserImportRequest");
        }
        String localVarPath = "/v2/organizations/{organizationId}/imports/bulk_users/{importId}".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{importId\\}", this.apiClient.escapeString(importId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<OrganizationImportResponse> localVarReturnType = new GenericType<OrganizationImportResponse>(){};
        OrganizationImportResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<OrganizationImportResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public OrganizationImportsResponse getBulkUserImportRequests(UUID organizationId) throws ApiException {
        ApiResponse<OrganizationImportsResponse> localVarResponse = this.getBulkUserImportRequestsWithHttpInfo(organizationId);
        return localVarResponse.getData();
    }

    public ApiResponse<OrganizationImportsResponse> getBulkUserImportRequestsWithHttpInfo(UUID organizationId) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling getBulkUserImportRequests");
        }
        String localVarPath = "/v2/organizations/{organizationId}/imports/bulk_users".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<OrganizationImportsResponse> localVarReturnType = new GenericType<OrganizationImportsResponse>(){};
        OrganizationImportsResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<OrganizationImportsResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }
}

