/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.admin.api;

import com.docusign.admin.client.ApiClient;
import com.docusign.admin.client.ApiException;
import com.docusign.admin.client.ApiResponse;
import com.docusign.admin.client.Configuration;
import com.docusign.admin.client.Pair;
import com.docusign.admin.model.AddDSGroupAndUsersResponse;
import com.docusign.admin.model.DSGroupAddRequest;
import com.docusign.admin.model.DSGroupAndUsersResponse;
import com.docusign.admin.model.DSGroupListResponse;
import com.docusign.admin.model.DSGroupResponse;
import com.docusign.admin.model.DSGroupUsersAddRequest;
import com.docusign.admin.model.DSGroupUsersRemoveRequest;
import com.docusign.admin.model.RemoveDSGroupUsersResponse;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;

public class DsGroupsApi {
    private ApiClient apiClient;

    public DsGroupsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DsGroupsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public DSGroupResponse addDSGroup(UUID organizationId, UUID accountId, DSGroupAddRequest addRequest) throws ApiException {
        ApiResponse<DSGroupResponse> localVarResponse = this.addDSGroupWithHttpInfo(organizationId, accountId, addRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<DSGroupResponse> addDSGroupWithHttpInfo(UUID organizationId, UUID accountId, DSGroupAddRequest addRequest) throws ApiException {
        DSGroupAddRequest localVarPostBody = addRequest;
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling addDSGroup");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling addDSGroup");
        }
        if (addRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'addRequest' when calling addDSGroup");
        }
        String localVarPath = "/v2.1/organizations/{organizationId}/accounts/{accountId}/dsgroups".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<DSGroupResponse> localVarReturnType = new GenericType<DSGroupResponse>(){};
        DSGroupResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<DSGroupResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public AddDSGroupAndUsersResponse addDSGroupUsers(UUID organizationId, UUID accountId, UUID dsGroupId, DSGroupUsersAddRequest dSGroupUsersAddRequest) throws ApiException {
        ApiResponse<AddDSGroupAndUsersResponse> localVarResponse = this.addDSGroupUsersWithHttpInfo(organizationId, accountId, dsGroupId, dSGroupUsersAddRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<AddDSGroupAndUsersResponse> addDSGroupUsersWithHttpInfo(UUID organizationId, UUID accountId, UUID dsGroupId, DSGroupUsersAddRequest dSGroupUsersAddRequest) throws ApiException {
        DSGroupUsersAddRequest localVarPostBody = dSGroupUsersAddRequest;
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling addDSGroupUsers");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling addDSGroupUsers");
        }
        if (dsGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'dsGroupId' when calling addDSGroupUsers");
        }
        if (dSGroupUsersAddRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'dSGroupUsersAddRequest' when calling addDSGroupUsers");
        }
        String localVarPath = "/v2.1/organizations/{organizationId}/accounts/{accountId}/dsgroups/{dsGroupId}/users".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{dsGroupId\\}", this.apiClient.escapeString(dsGroupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<AddDSGroupAndUsersResponse> localVarReturnType = new GenericType<AddDSGroupAndUsersResponse>(){};
        AddDSGroupAndUsersResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<AddDSGroupAndUsersResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public void deleteDSGroup(UUID organizationId, UUID accountId, UUID dsGroupId) throws ApiException {
        this.deleteDSGroupWithHttpInfo(organizationId, accountId, dsGroupId);
    }

    public ApiResponse<Object> deleteDSGroupWithHttpInfo(UUID organizationId, UUID accountId, UUID dsGroupId) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling deleteDSGroup");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteDSGroup");
        }
        if (dsGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'dsGroupId' when calling deleteDSGroup");
        }
        String localVarPath = "/v2.1/organizations/{organizationId}/accounts/{accountId}/dsgroups/{dsGroupId}".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{dsGroupId\\}", this.apiClient.escapeString(dsGroupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public DSGroupResponse getDSGroup(UUID organizationId, UUID accountId, UUID dsGroupId) throws ApiException {
        ApiResponse<DSGroupResponse> localVarResponse = this.getDSGroupWithHttpInfo(organizationId, accountId, dsGroupId);
        return localVarResponse.getData();
    }

    public ApiResponse<DSGroupResponse> getDSGroupWithHttpInfo(UUID organizationId, UUID accountId, UUID dsGroupId) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling getDSGroup");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getDSGroup");
        }
        if (dsGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'dsGroupId' when calling getDSGroup");
        }
        String localVarPath = "/v2.1/organizations/{organizationId}/accounts/{accountId}/dsgroups/{dsGroupId}".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{dsGroupId\\}", this.apiClient.escapeString(dsGroupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<DSGroupResponse> localVarReturnType = new GenericType<DSGroupResponse>(){};
        DSGroupResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<DSGroupResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public DSGroupAndUsersResponse getDSGroupUsers(UUID organizationId, UUID accountId, UUID dsGroupId) throws ApiException {
        return this.getDSGroupUsers(organizationId, accountId, dsGroupId, null);
    }

    public DSGroupAndUsersResponse getDSGroupUsers(UUID organizationId, UUID accountId, UUID dsGroupId, GetDSGroupUsersOptions options) throws ApiException {
        ApiResponse<DSGroupAndUsersResponse> localVarResponse = this.getDSGroupUsersWithHttpInfo(organizationId, accountId, dsGroupId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<DSGroupAndUsersResponse> getDSGroupUsersWithHttpInfo(UUID organizationId, UUID accountId, UUID dsGroupId, GetDSGroupUsersOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling getDSGroupUsers");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getDSGroupUsers");
        }
        if (dsGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'dsGroupId' when calling getDSGroupUsers");
        }
        String localVarPath = "/v2.1/organizations/{organizationId}/accounts/{accountId}/dsgroups/{dsGroupId}/users".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{dsGroupId\\}", this.apiClient.escapeString(dsGroupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", options.page));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_size", options.pageSize));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<DSGroupAndUsersResponse> localVarReturnType = new GenericType<DSGroupAndUsersResponse>(){};
        DSGroupAndUsersResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<DSGroupAndUsersResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public DSGroupListResponse getDSGroups(UUID organizationId, UUID accountId) throws ApiException {
        return this.getDSGroups(organizationId, accountId, null);
    }

    public DSGroupListResponse getDSGroups(UUID organizationId, UUID accountId, GetDSGroupsOptions options) throws ApiException {
        ApiResponse<DSGroupListResponse> localVarResponse = this.getDSGroupsWithHttpInfo(organizationId, accountId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<DSGroupListResponse> getDSGroupsWithHttpInfo(UUID organizationId, UUID accountId, GetDSGroupsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling getDSGroups");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getDSGroups");
        }
        String localVarPath = "/v2.1/organizations/{organizationId}/accounts/{accountId}/dsgroups".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", options.page));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_size", options.pageSize));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<DSGroupListResponse> localVarReturnType = new GenericType<DSGroupListResponse>(){};
        DSGroupListResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<DSGroupListResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public RemoveDSGroupUsersResponse removeDSGroupUsers(UUID organizationId, UUID accountId, UUID dsGroupId, DSGroupUsersRemoveRequest dSGroupUsersRemoveRequest) throws ApiException {
        ApiResponse<RemoveDSGroupUsersResponse> localVarResponse = this.removeDSGroupUsersWithHttpInfo(organizationId, accountId, dsGroupId, dSGroupUsersRemoveRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<RemoveDSGroupUsersResponse> removeDSGroupUsersWithHttpInfo(UUID organizationId, UUID accountId, UUID dsGroupId, DSGroupUsersRemoveRequest dSGroupUsersRemoveRequest) throws ApiException {
        DSGroupUsersRemoveRequest localVarPostBody = dSGroupUsersRemoveRequest;
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling removeDSGroupUsers");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling removeDSGroupUsers");
        }
        if (dsGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'dsGroupId' when calling removeDSGroupUsers");
        }
        if (dSGroupUsersRemoveRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'dSGroupUsersRemoveRequest' when calling removeDSGroupUsers");
        }
        String localVarPath = "/v2.1/organizations/{organizationId}/accounts/{accountId}/dsgroups/{dsGroupId}/users".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{dsGroupId\\}", this.apiClient.escapeString(dsGroupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<RemoveDSGroupUsersResponse> localVarReturnType = new GenericType<RemoveDSGroupUsersResponse>(){};
        RemoveDSGroupUsersResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<RemoveDSGroupUsersResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public class GetDSGroupsOptions {
        private Integer page = null;
        private Integer pageSize = null;

        public void setPage(Integer page) {
            this.page = page;
        }

        public Integer getPage() {
            return this.page;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }
    }

    public class GetDSGroupUsersOptions {
        private Integer page = null;
        private Integer pageSize = null;

        public void setPage(Integer page) {
            this.page = page;
        }

        public Integer getPage() {
            return this.page;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }
    }
}

