/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.admin.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import java.util.UUID;

public class AssetGroupAccountResponse {
    @JsonProperty(value="assetGroupId")
    private UUID assetGroupId = null;
    @JsonProperty(value="assetGroupName")
    private String assetGroupName = null;
    @JsonProperty(value="accountId")
    private UUID accountId = null;
    @JsonProperty(value="accountName")
    private String accountName = null;
    @JsonProperty(value="externalAccountId")
    private Long externalAccountId = null;
    @JsonProperty(value="compliant")
    private Boolean compliant = null;
    @JsonProperty(value="siteId")
    private Integer siteId = null;
    @JsonProperty(value="siteName")
    private String siteName = null;

    @Schema(example="00000000-0000-0000-0000-000000000000", description="The asset group id that the asset group account belongs to.")
    public UUID getAssetGroupId() {
        return this.assetGroupId;
    }

    @Schema(description="The name of asset group that the asset group account belongs to.")
    public String getAssetGroupName() {
        return this.assetGroupName;
    }

    @Schema(example="00000000-0000-0000-0000-000000000000", description="The account id of the asset group account.")
    public UUID getAccountId() {
        return this.accountId;
    }

    @Schema(description="The account name of the asset group account.")
    public String getAccountName() {
        return this.accountName;
    }

    @Schema(description="The external account id of the asset group account.")
    public Long getExternalAccountId() {
        return this.externalAccountId;
    }

    @Schema(description="The compliant status for the account.")
    public Boolean isCompliant() {
        return this.compliant;
    }

    @Schema(description="The site id of the asset group account.")
    public Integer getSiteId() {
        return this.siteId;
    }

    @Schema(description="The site name of the asset group account.")
    public String getSiteName() {
        return this.siteName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssetGroupAccountResponse assetGroupAccountResponse = (AssetGroupAccountResponse)o;
        return Objects.equals(this.assetGroupId, assetGroupAccountResponse.assetGroupId) && Objects.equals(this.assetGroupName, assetGroupAccountResponse.assetGroupName) && Objects.equals(this.accountId, assetGroupAccountResponse.accountId) && Objects.equals(this.accountName, assetGroupAccountResponse.accountName) && Objects.equals(this.externalAccountId, assetGroupAccountResponse.externalAccountId) && Objects.equals(this.compliant, assetGroupAccountResponse.compliant) && Objects.equals(this.siteId, assetGroupAccountResponse.siteId) && Objects.equals(this.siteName, assetGroupAccountResponse.siteName);
    }

    public int hashCode() {
        return Objects.hash(this.assetGroupId, this.assetGroupName, this.accountId, this.accountName, this.externalAccountId, this.compliant, this.siteId, this.siteName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssetGroupAccountResponse {\n");
        sb.append("    assetGroupId: ").append(this.toIndentedString(this.assetGroupId)).append("\n");
        sb.append("    assetGroupName: ").append(this.toIndentedString(this.assetGroupName)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    accountName: ").append(this.toIndentedString(this.accountName)).append("\n");
        sb.append("    externalAccountId: ").append(this.toIndentedString(this.externalAccountId)).append("\n");
        sb.append("    compliant: ").append(this.toIndentedString(this.compliant)).append("\n");
        sb.append("    siteId: ").append(this.toIndentedString(this.siteId)).append("\n");
        sb.append("    siteName: ").append(this.toIndentedString(this.siteName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

