package com.docusign.admin.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

/** DSGroupAddRequest. */
public class DSGroupAddRequest implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("group_name")
  private String groupName = null;

  @JsonProperty("description")
  private String description = null;

  /**
   * groupName.
   *
   * @return DSGroupAddRequest
   */
  public DSGroupAddRequest groupName(String groupName) {
    this.groupName = groupName;
    return this;
  }

  /**
   * Get groupName.
   *
   * @return groupName
   */
  @Schema(required = true, description = "")
  public String getGroupName() {
    return groupName;
  }

  /** setGroupName. */
  public void setGroupName(String groupName) {
    this.groupName = groupName;
  }

  /**
   * description.
   *
   * @return DSGroupAddRequest
   */
  public DSGroupAddRequest description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Get description.
   *
   * @return description
   */
  @Schema(description = "")
  public String getDescription() {
    return description;
  }

  /** setDescription. */
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * Compares objects.
   *
   * @return true or false depending on comparison result.
   */
  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DSGroupAddRequest dsGroupAddRequest = (DSGroupAddRequest) o;
    return Objects.equals(this.groupName, dsGroupAddRequest.groupName)
        && Objects.equals(this.description, dsGroupAddRequest.description);
  }

  /** Returns the HashCode. */
  @Override
  public int hashCode() {
    return Objects.hash(groupName, description);
  }

  /** Converts the given object to string. */
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DSGroupAddRequest {\n");

    sb.append("    groupName: ").append(toIndentedString(groupName)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
