/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.api;

import com.docusign.esign.client.ApiClient;
import com.docusign.esign.client.ApiException;
import com.docusign.esign.client.Configuration;
import com.docusign.esign.client.Pair;
import com.docusign.esign.model.ConsoleViewRequest;
import com.docusign.esign.model.CorrectViewRequest;
import com.docusign.esign.model.CustomFields;
import com.docusign.esign.model.CustomFieldsEnvelope;
import com.docusign.esign.model.DocumentFieldsInformation;
import com.docusign.esign.model.DocumentTemplateList;
import com.docusign.esign.model.EmailSettings;
import com.docusign.esign.model.Envelope;
import com.docusign.esign.model.EnvelopeAuditEventResponse;
import com.docusign.esign.model.EnvelopeDefinition;
import com.docusign.esign.model.EnvelopeDocumentsResult;
import com.docusign.esign.model.EnvelopeIdsRequest;
import com.docusign.esign.model.EnvelopeSummary;
import com.docusign.esign.model.EnvelopeUpdateSummary;
import com.docusign.esign.model.EnvelopesInformation;
import com.docusign.esign.model.LockInformation;
import com.docusign.esign.model.LockRequest;
import com.docusign.esign.model.Notification;
import com.docusign.esign.model.RecipientViewRequest;
import com.docusign.esign.model.Recipients;
import com.docusign.esign.model.RecipientsUpdateSummary;
import com.docusign.esign.model.ReturnUrlRequest;
import com.docusign.esign.model.Tabs;
import com.docusign.esign.model.TemplateInformation;
import com.docusign.esign.model.ViewLinkRequest;
import com.docusign.esign.model.ViewUrl;
import com.sun.jersey.api.client.GenericType;
import java.util.ArrayList;
import java.util.HashMap;

public class EnvelopesApi {
    private ApiClient apiClient;

    public EnvelopesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EnvelopesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public DocumentTemplateList applyTemplate(String accountId, String envelopeId, DocumentTemplateList documentTemplateList) throws ApiException {
        DocumentTemplateList localVarPostBody = documentTemplateList;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling applyTemplate");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling applyTemplate");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/templates".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<DocumentTemplateList> localVarReturnType = new GenericType<DocumentTemplateList>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DocumentTemplateList applyTemplateToDocument(String accountId, String envelopeId, String documentId, DocumentTemplateList documentTemplateList) throws ApiException {
        DocumentTemplateList localVarPostBody = documentTemplateList;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling applyTemplateToDocument");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling applyTemplateToDocument");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling applyTemplateToDocument");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/templates".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<DocumentTemplateList> localVarReturnType = new GenericType<DocumentTemplateList>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ViewUrl createConsoleView(String accountId, ConsoleViewRequest consoleViewRequest) throws ApiException {
        ConsoleViewRequest localVarPostBody = consoleViewRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createConsoleView");
        }
        String localVarPath = "/v2/accounts/{accountId}/views/console".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<ViewUrl> localVarReturnType = new GenericType<ViewUrl>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ViewUrl createCorrectView(String accountId, String envelopeId, CorrectViewRequest correctViewRequest) throws ApiException {
        CorrectViewRequest localVarPostBody = correctViewRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createCorrectView");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createCorrectView");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/views/correct".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<ViewUrl> localVarReturnType = new GenericType<ViewUrl>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CustomFields createCustomFields(String accountId, String envelopeId, CustomFields customFields) throws ApiException {
        CustomFields localVarPostBody = customFields;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createCustomFields");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createCustomFields");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/custom_fields".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<CustomFields> localVarReturnType = new GenericType<CustomFields>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DocumentFieldsInformation createDocumentFields(String accountId, String envelopeId, String documentId, DocumentFieldsInformation documentFieldsInformation) throws ApiException {
        DocumentFieldsInformation localVarPostBody = documentFieldsInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createDocumentFields");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createDocumentFields");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling createDocumentFields");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/fields".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<DocumentFieldsInformation> localVarReturnType = new GenericType<DocumentFieldsInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ViewUrl createEditView(String accountId, String envelopeId, ReturnUrlRequest returnUrlRequest) throws ApiException {
        ReturnUrlRequest localVarPostBody = returnUrlRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createEditView");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createEditView");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/views/edit".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<ViewUrl> localVarReturnType = new GenericType<ViewUrl>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EmailSettings createEmailSettings(String accountId, String envelopeId, EmailSettings emailSettings) throws ApiException {
        EmailSettings localVarPostBody = emailSettings;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createEmailSettings");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createEmailSettings");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/email_settings".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<EmailSettings> localVarReturnType = new GenericType<EmailSettings>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EnvelopeSummary createEnvelope(String accountId, EnvelopeDefinition envelopeDefinition) throws ApiException {
        return this.createEnvelope(accountId, envelopeDefinition, null);
    }

    public EnvelopeSummary createEnvelope(String accountId, EnvelopeDefinition envelopeDefinition, CreateEnvelopeOptions options) throws ApiException {
        EnvelopeDefinition localVarPostBody = envelopeDefinition;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createEnvelope");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "completed_documents_only", options.completedDocumentsOnly));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "merge_roles_on_draft", options.mergeRolesOnDraft));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "cdse_mode", options.cdseMode));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<EnvelopeSummary> localVarReturnType = new GenericType<EnvelopeSummary>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public LockInformation createLock(String accountId, String envelopeId, LockRequest lockRequest) throws ApiException {
        LockRequest localVarPostBody = lockRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createLock");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createLock");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/lock".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<LockInformation> localVarReturnType = new GenericType<LockInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Recipients createRecipient(String accountId, String envelopeId, Recipients recipients) throws ApiException {
        Recipients localVarPostBody = recipients;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createRecipient");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createRecipient");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<Recipients> localVarReturnType = new GenericType<Recipients>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ViewUrl createRecipientView(String accountId, String envelopeId, RecipientViewRequest recipientViewRequest) throws ApiException {
        RecipientViewRequest localVarPostBody = recipientViewRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createRecipientView");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createRecipientView");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/views/recipient".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<ViewUrl> localVarReturnType = new GenericType<ViewUrl>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ViewUrl createSenderView(String accountId, String envelopeId, ReturnUrlRequest returnUrlRequest) throws ApiException {
        ReturnUrlRequest localVarPostBody = returnUrlRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createSenderView");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createSenderView");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/views/sender".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<ViewUrl> localVarReturnType = new GenericType<ViewUrl>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Tabs createTabs(String accountId, String envelopeId, String recipientId, Tabs tabs) throws ApiException {
        Tabs localVarPostBody = tabs;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createTabs");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createTabs");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling createTabs");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/tabs".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<Tabs> localVarReturnType = new GenericType<Tabs>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ViewUrl createViewLink(String accountId, String envelopeId, ViewLinkRequest viewLinkRequest) throws ApiException {
        ViewLinkRequest localVarPostBody = viewLinkRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createViewLink");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createViewLink");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/views/viewlink".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<ViewUrl> localVarReturnType = new GenericType<ViewUrl>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CustomFields deleteCustomFields(String accountId, String envelopeId, CustomFields customFields) throws ApiException {
        CustomFields localVarPostBody = customFields;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteCustomFields");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteCustomFields");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/custom_fields".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<CustomFields> localVarReturnType = new GenericType<CustomFields>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DocumentFieldsInformation deleteDocumentFields(String accountId, String envelopeId, String documentId, DocumentFieldsInformation documentFieldsInformation) throws ApiException {
        DocumentFieldsInformation localVarPostBody = documentFieldsInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteDocumentFields");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteDocumentFields");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling deleteDocumentFields");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/fields".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<DocumentFieldsInformation> localVarReturnType = new GenericType<DocumentFieldsInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteDocumentPage(String accountId, String envelopeId, String documentId, String pageNumber) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteDocumentPage");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteDocumentPage");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling deleteDocumentPage");
        }
        if (pageNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'pageNumber' when calling deleteDocumentPage");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages/{pageNumber}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString())).replaceAll("\\{pageNumber\\}", this.apiClient.escapeString(pageNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public EnvelopeDocumentsResult deleteDocuments(String accountId, String envelopeId, EnvelopeDefinition envelopeDefinition) throws ApiException {
        EnvelopeDefinition localVarPostBody = envelopeDefinition;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteDocuments");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteDocuments");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<EnvelopeDocumentsResult> localVarReturnType = new GenericType<EnvelopeDocumentsResult>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EmailSettings deleteEmailSettings(String accountId, String envelopeId) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteEmailSettings");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteEmailSettings");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/email_settings".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<EmailSettings> localVarReturnType = new GenericType<EmailSettings>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public LockInformation deleteLock(String accountId, String envelopeId) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteLock");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteLock");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/lock".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<LockInformation> localVarReturnType = new GenericType<LockInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Recipients deleteRecipient(String accountId, String envelopeId, String recipientId) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteRecipient");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteRecipient");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling deleteRecipient");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<Recipients> localVarReturnType = new GenericType<Recipients>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Recipients deleteRecipients(String accountId, String envelopeId, Recipients recipients) throws ApiException {
        Recipients localVarPostBody = recipients;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteRecipients");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteRecipients");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<Recipients> localVarReturnType = new GenericType<Recipients>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Tabs deleteTabs(String accountId, String envelopeId, String recipientId, Tabs tabs) throws ApiException {
        Tabs localVarPostBody = tabs;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteTabs");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteTabs");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling deleteTabs");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/tabs".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<Tabs> localVarReturnType = new GenericType<Tabs>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteTemplatesFromDocument(String accountId, String envelopeId, String documentId, String templateId) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteTemplatesFromDocument");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteTemplatesFromDocument");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling deleteTemplatesFromDocument");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling deleteTemplatesFromDocument");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/templates/{templateId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteViewLink(String accountId, String envelopeId) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteViewLink");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteViewLink");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/views/viewlink".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public byte[] getDocument(String accountId, String envelopeId, String documentId) throws ApiException {
        return this.getDocument(accountId, envelopeId, documentId, null);
    }

    public byte[] getDocument(String accountId, String envelopeId, String documentId, GetDocumentOptions options) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getDocument");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getDocument");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling getDocument");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "watermark", options.watermark));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "recipient_id", options.recipientId));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "encoding", options.encoding));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "certificate", options.certificate));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "language", options.language));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "encrypt", options.encrypt));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "show_changes", options.showChanges));
        }
        String[] localVarAccepts = new String[]{"application/pdf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<byte[]> localVarReturnType = new GenericType<byte[]>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EmailSettings getEmailSettings(String accountId, String envelopeId) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getEmailSettings");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getEmailSettings");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/email_settings".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<EmailSettings> localVarReturnType = new GenericType<EmailSettings>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Envelope getEnvelope(String accountId, String envelopeId) throws ApiException {
        return this.getEnvelope(accountId, envelopeId, null);
    }

    public Envelope getEnvelope(String accountId, String envelopeId, GetEnvelopeOptions options) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getEnvelope");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getEnvelope");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", options.include));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<Envelope> localVarReturnType = new GenericType<Envelope>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public LockInformation getLock(String accountId, String envelopeId) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getLock");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getLock");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/lock".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<LockInformation> localVarReturnType = new GenericType<LockInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Notification getNotificationSettings(String accountId, String envelopeId) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getNotificationSettings");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getNotificationSettings");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/notification".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<Notification> localVarReturnType = new GenericType<Notification>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EnvelopeAuditEventResponse listAuditEvents(String accountId, String envelopeId) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listAuditEvents");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling listAuditEvents");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/audit_events".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<EnvelopeAuditEventResponse> localVarReturnType = new GenericType<EnvelopeAuditEventResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CustomFieldsEnvelope listCustomFields(String accountId, String envelopeId) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listCustomFields");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling listCustomFields");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/custom_fields".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<CustomFieldsEnvelope> localVarReturnType = new GenericType<CustomFieldsEnvelope>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DocumentFieldsInformation listDocumentFields(String accountId, String envelopeId, String documentId) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listDocumentFields");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling listDocumentFields");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling listDocumentFields");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/fields".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<DocumentFieldsInformation> localVarReturnType = new GenericType<DocumentFieldsInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EnvelopeDocumentsResult listDocuments(String accountId, String envelopeId) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listDocuments");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling listDocuments");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<EnvelopeDocumentsResult> localVarReturnType = new GenericType<EnvelopeDocumentsResult>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Recipients listRecipients(String accountId, String envelopeId) throws ApiException {
        return this.listRecipients(accountId, envelopeId, null);
    }

    public Recipients listRecipients(String accountId, String envelopeId, ListRecipientsOptions options) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listRecipients");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling listRecipients");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include_metadata", options.includeMetadata));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include_tabs", options.includeTabs));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<Recipients> localVarReturnType = new GenericType<Recipients>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EnvelopesInformation listStatus(String accountId, EnvelopeIdsRequest envelopeIdsRequest) throws ApiException {
        EnvelopeIdsRequest localVarPostBody = envelopeIdsRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listStatus");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/status".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<EnvelopesInformation> localVarReturnType = new GenericType<EnvelopesInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EnvelopesInformation listStatusChanges(String accountId) throws ApiException {
        return this.listStatusChanges(accountId, null);
    }

    public EnvelopesInformation listStatusChanges(String accountId, ListStatusChangesOptions options) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listStatusChanges");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "transaction_ids", options.transactionIds));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "folder_ids", options.folderIds));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "envelope_ids", options.envelopeIds));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "powerformids", options.powerformids));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_position", options.startPosition));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "status", options.status));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from_to_status", options.fromToStatus));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order", options.order));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "user_filter", options.userFilter));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "user_id", options.userId));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "user_name", options.userName));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", options.count));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "custom_field", options.customField));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "email", options.email));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "to_date", options.toDate));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "search_text", options.searchText));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "exclude", options.exclude));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ac_status", options.acStatus));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order_by", options.orderBy));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "folder_types", options.folderTypes));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "block", options.block));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", options.include));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "intersecting_folder_ids", options.intersectingFolderIds));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from_date", options.fromDate));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<EnvelopesInformation> localVarReturnType = new GenericType<EnvelopesInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Tabs listTabs(String accountId, String envelopeId, String recipientId) throws ApiException {
        return this.listTabs(accountId, envelopeId, recipientId, null);
    }

    public Tabs listTabs(String accountId, String envelopeId, String recipientId, ListTabsOptions options) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listTabs");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling listTabs");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling listTabs");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/tabs".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include_metadata", options.includeMetadata));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<Tabs> localVarReturnType = new GenericType<Tabs>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public TemplateInformation listTemplates(String accountId, String envelopeId) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listTemplates");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling listTemplates");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/templates".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<TemplateInformation> localVarReturnType = new GenericType<TemplateInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public TemplateInformation listTemplatesForDocument(String accountId, String envelopeId, String documentId) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listTemplatesForDocument");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling listTemplatesForDocument");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling listTemplatesForDocument");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/templates".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<TemplateInformation> localVarReturnType = new GenericType<TemplateInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EnvelopeUpdateSummary update(String accountId, String envelopeId, Envelope envelope) throws ApiException {
        return this.update(accountId, envelopeId, envelope, null);
    }

    public EnvelopeUpdateSummary update(String accountId, String envelopeId, Envelope envelope, UpdateOptions options) throws ApiException {
        Envelope localVarPostBody = envelope;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling update");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling update");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "advanced_update", options.advancedUpdate));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "resend_envelope", options.resendEnvelope));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<EnvelopeUpdateSummary> localVarReturnType = new GenericType<EnvelopeUpdateSummary>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CustomFields updateCustomFields(String accountId, String envelopeId, CustomFields customFields) throws ApiException {
        CustomFields localVarPostBody = customFields;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateCustomFields");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateCustomFields");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/custom_fields".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<CustomFields> localVarReturnType = new GenericType<CustomFields>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DocumentFieldsInformation updateDocumentFields(String accountId, String envelopeId, String documentId, DocumentFieldsInformation documentFieldsInformation) throws ApiException {
        DocumentFieldsInformation localVarPostBody = documentFieldsInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateDocumentFields");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateDocumentFields");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling updateDocumentFields");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/fields".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<DocumentFieldsInformation> localVarReturnType = new GenericType<DocumentFieldsInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EnvelopeDocumentsResult updateDocuments(String accountId, String envelopeId, EnvelopeDefinition envelopeDefinition) throws ApiException {
        return this.updateDocuments(accountId, envelopeId, envelopeDefinition, null);
    }

    public EnvelopeDocumentsResult updateDocuments(String accountId, String envelopeId, EnvelopeDefinition envelopeDefinition, UpdateDocumentsOptions options) throws ApiException {
        EnvelopeDefinition localVarPostBody = envelopeDefinition;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateDocuments");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateDocuments");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apply_document_fields", options.applyDocumentFields));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<EnvelopeDocumentsResult> localVarReturnType = new GenericType<EnvelopeDocumentsResult>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EmailSettings updateEmailSettings(String accountId, String envelopeId, EmailSettings emailSettings) throws ApiException {
        EmailSettings localVarPostBody = emailSettings;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateEmailSettings");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateEmailSettings");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/email_settings".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<EmailSettings> localVarReturnType = new GenericType<EmailSettings>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public LockInformation updateLock(String accountId, String envelopeId, LockRequest lockRequest) throws ApiException {
        LockRequest localVarPostBody = lockRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateLock");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateLock");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/lock".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<LockInformation> localVarReturnType = new GenericType<LockInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RecipientsUpdateSummary updateRecipients(String accountId, String envelopeId, Recipients recipients) throws ApiException {
        Recipients localVarPostBody = recipients;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateRecipients");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateRecipients");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<RecipientsUpdateSummary> localVarReturnType = new GenericType<RecipientsUpdateSummary>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Tabs updateTabs(String accountId, String envelopeId, String recipientId, Tabs tabs) throws ApiException {
        Tabs localVarPostBody = tabs;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateTabs");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateTabs");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling updateTabs");
        }
        String localVarPath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/tabs".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<Tabs> localVarReturnType = new GenericType<Tabs>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public class UpdateDocumentsOptions {
        private String applyDocumentFields = null;

        public void setApplyDocumentFields(String applyDocumentFields) {
            this.applyDocumentFields = applyDocumentFields;
        }

        public String getApplyDocumentFields() {
            return this.applyDocumentFields;
        }
    }

    public class UpdateOptions {
        private String advancedUpdate = null;
        private String resendEnvelope = null;

        public void setAdvancedUpdate(String advancedUpdate) {
            this.advancedUpdate = advancedUpdate;
        }

        public String getAdvancedUpdate() {
            return this.advancedUpdate;
        }

        public void setResendEnvelope(String resendEnvelope) {
            this.resendEnvelope = resendEnvelope;
        }

        public String getResendEnvelope() {
            return this.resendEnvelope;
        }
    }

    public class ListTabsOptions {
        private String includeMetadata = null;

        public void setIncludeMetadata(String includeMetadata) {
            this.includeMetadata = includeMetadata;
        }

        public String getIncludeMetadata() {
            return this.includeMetadata;
        }
    }

    public class ListStatusChangesOptions {
        private String transactionIds = null;
        private String folderIds = null;
        private String envelopeIds = null;
        private String powerformids = null;
        private String startPosition = null;
        private String status = null;
        private String fromToStatus = null;
        private String order = null;
        private String userFilter = null;
        private String userId = null;
        private String userName = null;
        private String count = null;
        private String customField = null;
        private String email = null;
        private String toDate = null;
        private String searchText = null;
        private String exclude = null;
        private String acStatus = null;
        private String orderBy = null;
        private String folderTypes = null;
        private String block = null;
        private String include = null;
        private String intersectingFolderIds = null;
        private String fromDate = null;

        public void setTransactionIds(String transactionIds) {
            this.transactionIds = transactionIds;
        }

        public String getTransactionIds() {
            return this.transactionIds;
        }

        public void setFolderIds(String folderIds) {
            this.folderIds = folderIds;
        }

        public String getFolderIds() {
            return this.folderIds;
        }

        public void setEnvelopeIds(String envelopeIds) {
            this.envelopeIds = envelopeIds;
        }

        public String getEnvelopeIds() {
            return this.envelopeIds;
        }

        public void setPowerformids(String powerformids) {
            this.powerformids = powerformids;
        }

        public String getPowerformids() {
            return this.powerformids;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getStartPosition() {
            return this.startPosition;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }

        public void setFromToStatus(String fromToStatus) {
            this.fromToStatus = fromToStatus;
        }

        public String getFromToStatus() {
            return this.fromToStatus;
        }

        public void setOrder(String order) {
            this.order = order;
        }

        public String getOrder() {
            return this.order;
        }

        public void setUserFilter(String userFilter) {
            this.userFilter = userFilter;
        }

        public String getUserFilter() {
            return this.userFilter;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getUserId() {
            return this.userId;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setCount(String count) {
            this.count = count;
        }

        public String getCount() {
            return this.count;
        }

        public void setCustomField(String customField) {
            this.customField = customField;
        }

        public String getCustomField() {
            return this.customField;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getEmail() {
            return this.email;
        }

        public void setToDate(String toDate) {
            this.toDate = toDate;
        }

        public String getToDate() {
            return this.toDate;
        }

        public void setSearchText(String searchText) {
            this.searchText = searchText;
        }

        public String getSearchText() {
            return this.searchText;
        }

        public void setExclude(String exclude) {
            this.exclude = exclude;
        }

        public String getExclude() {
            return this.exclude;
        }

        public void setAcStatus(String acStatus) {
            this.acStatus = acStatus;
        }

        public String getAcStatus() {
            return this.acStatus;
        }

        public void setOrderBy(String orderBy) {
            this.orderBy = orderBy;
        }

        public String getOrderBy() {
            return this.orderBy;
        }

        public void setFolderTypes(String folderTypes) {
            this.folderTypes = folderTypes;
        }

        public String getFolderTypes() {
            return this.folderTypes;
        }

        public void setBlock(String block) {
            this.block = block;
        }

        public String getBlock() {
            return this.block;
        }

        public void setInclude(String include) {
            this.include = include;
        }

        public String getInclude() {
            return this.include;
        }

        public void setIntersectingFolderIds(String intersectingFolderIds) {
            this.intersectingFolderIds = intersectingFolderIds;
        }

        public String getIntersectingFolderIds() {
            return this.intersectingFolderIds;
        }

        public void setFromDate(String fromDate) {
            this.fromDate = fromDate;
        }

        public String getFromDate() {
            return this.fromDate;
        }
    }

    public class ListRecipientsOptions {
        private String includeMetadata = null;
        private String includeTabs = null;

        public void setIncludeMetadata(String includeMetadata) {
            this.includeMetadata = includeMetadata;
        }

        public String getIncludeMetadata() {
            return this.includeMetadata;
        }

        public void setIncludeTabs(String includeTabs) {
            this.includeTabs = includeTabs;
        }

        public String getIncludeTabs() {
            return this.includeTabs;
        }
    }

    public class GetEnvelopeOptions {
        private String include = null;

        public void setInclude(String include) {
            this.include = include;
        }

        public String getInclude() {
            return this.include;
        }
    }

    public class GetDocumentOptions {
        private String watermark = null;
        private String recipientId = null;
        private String encoding = null;
        private String certificate = null;
        private String language = null;
        private String encrypt = null;
        private String showChanges = null;

        public void setWatermark(String watermark) {
            this.watermark = watermark;
        }

        public String getWatermark() {
            return this.watermark;
        }

        public void setRecipientId(String recipientId) {
            this.recipientId = recipientId;
        }

        public String getRecipientId() {
            return this.recipientId;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        public String getCertificate() {
            return this.certificate;
        }

        public void setLanguage(String language) {
            this.language = language;
        }

        public String getLanguage() {
            return this.language;
        }

        public void setEncrypt(String encrypt) {
            this.encrypt = encrypt;
        }

        public String getEncrypt() {
            return this.encrypt;
        }

        public void setShowChanges(String showChanges) {
            this.showChanges = showChanges;
        }

        public String getShowChanges() {
            return this.showChanges;
        }
    }

    public class CreateEnvelopeOptions {
        private String completedDocumentsOnly = null;
        private String mergeRolesOnDraft = null;
        private String cdseMode = null;

        public void setCompletedDocumentsOnly(String completedDocumentsOnly) {
            this.completedDocumentsOnly = completedDocumentsOnly;
        }

        public String getCompletedDocumentsOnly() {
            return this.completedDocumentsOnly;
        }

        public void setMergeRolesOnDraft(String mergeRolesOnDraft) {
            this.mergeRolesOnDraft = mergeRolesOnDraft;
        }

        public String getMergeRolesOnDraft() {
            return this.mergeRolesOnDraft;
        }

        public void setCdseMode(String cdseMode) {
            this.cdseMode = cdseMode;
        }

        public String getCdseMode() {
            return this.cdseMode;
        }
    }
}

