/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.MatchBox;
import com.docusign.esign.model.NameValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Document {
    private String documentId = null;
    private String uri = null;
    private String remoteUrl = null;
    private String name = null;
    private String password = null;
    private String transformPdfFields = null;
    private String fileExtension = null;
    private List<MatchBox> matchBoxes = new ArrayList<MatchBox>();
    private String order = null;
    private String pages = null;
    private List<NameValue> documentFields = new ArrayList<NameValue>();
    private String encryptedWithKeyManager = null;
    private String documentBase64 = null;
    private String applyAnchorTabs = null;

    public Document documentId(String documentId) {
        this.documentId = documentId;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.")
    @JsonProperty(value="documentId")
    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public Document uri(String uri) {
        this.uri = uri;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="uri")
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public Document remoteUrl(String remoteUrl) {
        this.remoteUrl = remoteUrl;
        return this;
    }

    @ApiModelProperty(example="null", value="The file id from the cloud storage service where the document is located. This information is returned using [ML:GET /folders] or [ML:/folders/{folderid}]. ")
    @JsonProperty(value="remoteUrl")
    public String getRemoteUrl() {
        return this.remoteUrl;
    }

    public void setRemoteUrl(String remoteUrl) {
        this.remoteUrl = remoteUrl;
    }

    public Document name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Document password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="password")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Document transformPdfFields(String transformPdfFields) {
        this.transformPdfFields = transformPdfFields;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, PDF form field data is transformed into document tab values when the PDF form field name matches the DocuSign custom tab tabLabel. The resulting PDF form data is also returned in the PDF meta data when requesting the document PDF. See the [ML:Transform PDF Fields] section for more information about how fields are transformed into DocuSign tabs. ")
    @JsonProperty(value="transformPdfFields")
    public String getTransformPdfFields() {
        return this.transformPdfFields;
    }

    public void setTransformPdfFields(String transformPdfFields) {
        this.transformPdfFields = transformPdfFields;
    }

    public Document fileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
        return this;
    }

    @ApiModelProperty(example="null", value="The file extension type of the document. If the document is not a PDF it is converted to a PDF.\n ")
    @JsonProperty(value="fileExtension")
    public String getFileExtension() {
        return this.fileExtension;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public Document matchBoxes(List<MatchBox> matchBoxes) {
        this.matchBoxes = matchBoxes;
        return this;
    }

    @ApiModelProperty(example="null", value="Matchboxes define areas in a document for document matching when you are creating envelopes. They are only used when you upload and edit a template. \n\nA matchbox consists of 5 elements:\n\n* pageNumber - The document page number  on which the matchbox will appear. \n* xPosition - The x position of the matchbox on a page. \n* yPosition - The y position of the matchbox on a page.\n* width - The width of the matchbox. \n* height - The height of the matchbox. \n")
    @JsonProperty(value="matchBoxes")
    public List<MatchBox> getMatchBoxes() {
        return this.matchBoxes;
    }

    public void setMatchBoxes(List<MatchBox> matchBoxes) {
        this.matchBoxes = matchBoxes;
    }

    public Document order(String order) {
        this.order = order;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="order")
    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public Document pages(String pages) {
        this.pages = pages;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="pages")
    public String getPages() {
        return this.pages;
    }

    public void setPages(String pages) {
        this.pages = pages;
    }

    public Document documentFields(List<NameValue> documentFields) {
        this.documentFields = documentFields;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="documentFields")
    public List<NameValue> getDocumentFields() {
        return this.documentFields;
    }

    public void setDocumentFields(List<NameValue> documentFields) {
        this.documentFields = documentFields;
    }

    public Document encryptedWithKeyManager(String encryptedWithKeyManager) {
        this.encryptedWithKeyManager = encryptedWithKeyManager;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, the document is been already encrypted by the sender for use with the DocuSign Key Manager Security Appliance.\n ")
    @JsonProperty(value="encryptedWithKeyManager")
    public String getEncryptedWithKeyManager() {
        return this.encryptedWithKeyManager;
    }

    public void setEncryptedWithKeyManager(String encryptedWithKeyManager) {
        this.encryptedWithKeyManager = encryptedWithKeyManager;
    }

    public Document documentBase64(String documentBase64) {
        this.documentBase64 = documentBase64;
        return this;
    }

    @ApiModelProperty(example="null", value="The document\u2019s bytes. This field can be used to include a base64 version of the document bytes within an envelope definition instead of sending the document using a multi-part HTTP request. The maximum document size is smaller if this field is used due to the overhead of the base64 encoding.")
    @JsonProperty(value="documentBase64")
    public String getDocumentBase64() {
        return this.documentBase64;
    }

    public void setDocumentBase64(String documentBase64) {
        this.documentBase64 = documentBase64;
    }

    public Document applyAnchorTabs(String applyAnchorTabs) {
        this.applyAnchorTabs = applyAnchorTabs;
        return this;
    }

    @ApiModelProperty(example="null", value="Reserved: TBD")
    @JsonProperty(value="applyAnchorTabs")
    public String getApplyAnchorTabs() {
        return this.applyAnchorTabs;
    }

    public void setApplyAnchorTabs(String applyAnchorTabs) {
        this.applyAnchorTabs = applyAnchorTabs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Document document = (Document)o;
        return Objects.equals(this.documentId, document.documentId) && Objects.equals(this.uri, document.uri) && Objects.equals(this.remoteUrl, document.remoteUrl) && Objects.equals(this.name, document.name) && Objects.equals(this.password, document.password) && Objects.equals(this.transformPdfFields, document.transformPdfFields) && Objects.equals(this.fileExtension, document.fileExtension) && Objects.equals(this.matchBoxes, document.matchBoxes) && Objects.equals(this.order, document.order) && Objects.equals(this.pages, document.pages) && Objects.equals(this.documentFields, document.documentFields) && Objects.equals(this.encryptedWithKeyManager, document.encryptedWithKeyManager) && Objects.equals(this.documentBase64, document.documentBase64) && Objects.equals(this.applyAnchorTabs, document.applyAnchorTabs);
    }

    public int hashCode() {
        return Objects.hash(this.documentId, this.uri, this.remoteUrl, this.name, this.password, this.transformPdfFields, this.fileExtension, this.matchBoxes, this.order, this.pages, this.documentFields, this.encryptedWithKeyManager, this.documentBase64, this.applyAnchorTabs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Document {\n");
        sb.append("    documentId: ").append(this.toIndentedString(this.documentId)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("    remoteUrl: ").append(this.toIndentedString(this.remoteUrl)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    transformPdfFields: ").append(this.toIndentedString(this.transformPdfFields)).append("\n");
        sb.append("    fileExtension: ").append(this.toIndentedString(this.fileExtension)).append("\n");
        sb.append("    matchBoxes: ").append(this.toIndentedString(this.matchBoxes)).append("\n");
        sb.append("    order: ").append(this.toIndentedString(this.order)).append("\n");
        sb.append("    pages: ").append(this.toIndentedString(this.pages)).append("\n");
        sb.append("    documentFields: ").append(this.toIndentedString(this.documentFields)).append("\n");
        sb.append("    encryptedWithKeyManager: ").append(this.toIndentedString(this.encryptedWithKeyManager)).append("\n");
        sb.append("    documentBase64: ").append(this.toIndentedString(this.documentBase64)).append("\n");
        sb.append("    applyAnchorTabs: ").append(this.toIndentedString(this.applyAnchorTabs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

