/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.CustomFields;
import com.docusign.esign.model.EmailSettings;
import com.docusign.esign.model.LockInformation;
import com.docusign.esign.model.Notification;
import com.docusign.esign.model.Recipients;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class Envelope {
    private String transactionId = null;
    private String status = null;
    private String documentsUri = null;
    private String recipientsUri = null;
    private String asynchronous = null;
    private String envelopeUri = null;
    private String emailSubject = null;
    private String emailBlurb = null;
    private String envelopeId = null;
    private String signingLocation = null;
    private String customFieldsUri = null;
    private CustomFields customFields = null;
    private String autoNavigation = null;
    private String envelopeIdStamping = null;
    private String authoritativeCopy = null;
    private Notification notification = null;
    private String notificationUri = null;
    private String enforceSignerVisibility = null;
    private String enableWetSign = null;
    private String allowMarkup = null;
    private String allowReassign = null;
    private String createdDateTime = null;
    private String lastModifiedDateTime = null;
    private String deliveredDateTime = null;
    private String initialSentDateTime = null;
    private String sentDateTime = null;
    private String completedDateTime = null;
    private String voidedDateTime = null;
    private String voidedReason = null;
    private String deletedDateTime = null;
    private String declinedDateTime = null;
    private String statusChangedDateTime = null;
    private String documentsCombinedUri = null;
    private String certificateUri = null;
    private String templatesUri = null;
    private String messageLock = null;
    private String recipientsLock = null;
    private Recipients recipients = null;
    private String brandLock = null;
    private String brandId = null;
    private String useDisclosure = null;
    private EmailSettings emailSettings = null;
    private String purgeState = null;
    private LockInformation lockInformation = null;
    private String is21CFRPart11 = null;
    private String isSignatureProviderEnvelope = null;

    public Envelope transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @ApiModelProperty(example="null", value=" Used to identify an envelope. The id is a sender-generated value and is valid in the DocuSign system for 7 days. It is recommended that a transaction ID is used for offline signing to ensure that an envelope is not sent multiple times. The `transactionId` property can be used determine an envelope's status (i.e. was it created or not) in cases where the internet connection was lost before the envelope status was returned.")
    @JsonProperty(value="transactionId")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public Envelope status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates the envelope status. Valid values are:\n\n* sent - The envelope is sent to the recipients. \n*created - The envelope is saved as a draft and can be modified and sent later.")
    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Envelope documentsUri(String documentsUri) {
        this.documentsUri = documentsUri;
        return this;
    }

    @ApiModelProperty(example="null", value="Contains a URI for an endpoint that you can use to retrieve the documents.")
    @JsonProperty(value="documentsUri")
    public String getDocumentsUri() {
        return this.documentsUri;
    }

    public void setDocumentsUri(String documentsUri) {
        this.documentsUri = documentsUri;
    }

    public Envelope recipientsUri(String recipientsUri) {
        this.recipientsUri = recipientsUri;
        return this;
    }

    @ApiModelProperty(example="null", value="Contains a URI for an endpoint that you can use to retrieve the recipients.")
    @JsonProperty(value="recipientsUri")
    public String getRecipientsUri() {
        return this.recipientsUri;
    }

    public void setRecipientsUri(String recipientsUri) {
        this.recipientsUri = recipientsUri;
    }

    public Envelope asynchronous(String asynchronous) {
        this.asynchronous = asynchronous;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, the envelope is queued for processing and the value of the `status` property is set to 'Processing'. Additionally, get status calls return 'Processing' until completed.")
    @JsonProperty(value="asynchronous")
    public String getAsynchronous() {
        return this.asynchronous;
    }

    public void setAsynchronous(String asynchronous) {
        this.asynchronous = asynchronous;
    }

    public Envelope envelopeUri(String envelopeUri) {
        this.envelopeUri = envelopeUri;
        return this;
    }

    @ApiModelProperty(example="null", value="Contains a URI for an endpoint that you can use to retrieve the envelope or envelopes.")
    @JsonProperty(value="envelopeUri")
    public String getEnvelopeUri() {
        return this.envelopeUri;
    }

    public void setEnvelopeUri(String envelopeUri) {
        this.envelopeUri = envelopeUri;
    }

    public Envelope emailSubject(String emailSubject) {
        this.emailSubject = emailSubject;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies the subject of the email that is sent to all recipients.\n\nSee [ML:Template Email Subject Merge Fields] for information about adding merge field information to the email subject.")
    @JsonProperty(value="emailSubject")
    public String getEmailSubject() {
        return this.emailSubject;
    }

    public void setEmailSubject(String emailSubject) {
        this.emailSubject = emailSubject;
    }

    public Envelope emailBlurb(String emailBlurb) {
        this.emailBlurb = emailBlurb;
        return this;
    }

    @ApiModelProperty(example="null", value="This is the same as the email body. If specified it is included in email body for all envelope recipients.")
    @JsonProperty(value="emailBlurb")
    public String getEmailBlurb() {
        return this.emailBlurb;
    }

    public void setEmailBlurb(String emailBlurb) {
        this.emailBlurb = emailBlurb;
    }

    public Envelope envelopeId(String envelopeId) {
        this.envelopeId = envelopeId;
        return this;
    }

    @ApiModelProperty(example="null", value="The envelope ID of the envelope status that failed to post.")
    @JsonProperty(value="envelopeId")
    public String getEnvelopeId() {
        return this.envelopeId;
    }

    public void setEnvelopeId(String envelopeId) {
        this.envelopeId = envelopeId;
    }

    public Envelope signingLocation(String signingLocation) {
        this.signingLocation = signingLocation;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies the physical location where the signing takes place. It can have two enumeration values; InPerson and Online. The default value is Online.")
    @JsonProperty(value="signingLocation")
    public String getSigningLocation() {
        return this.signingLocation;
    }

    public void setSigningLocation(String signingLocation) {
        this.signingLocation = signingLocation;
    }

    public Envelope customFieldsUri(String customFieldsUri) {
        this.customFieldsUri = customFieldsUri;
        return this;
    }

    @ApiModelProperty(example="null", value="Contains a URI for an endpoint that you can use to retrieve the custom fields.")
    @JsonProperty(value="customFieldsUri")
    public String getCustomFieldsUri() {
        return this.customFieldsUri;
    }

    public void setCustomFieldsUri(String customFieldsUri) {
        this.customFieldsUri = customFieldsUri;
    }

    public Envelope customFields(CustomFields customFields) {
        this.customFields = customFields;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="customFields")
    public CustomFields getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(CustomFields customFields) {
        this.customFields = customFields;
    }

    public Envelope autoNavigation(String autoNavigation) {
        this.autoNavigation = autoNavigation;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="autoNavigation")
    public String getAutoNavigation() {
        return this.autoNavigation;
    }

    public void setAutoNavigation(String autoNavigation) {
        this.autoNavigation = autoNavigation;
    }

    public Envelope envelopeIdStamping(String envelopeIdStamping) {
        this.envelopeIdStamping = envelopeIdStamping;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, Envelope ID Stamping is enabled.")
    @JsonProperty(value="envelopeIdStamping")
    public String getEnvelopeIdStamping() {
        return this.envelopeIdStamping;
    }

    public void setEnvelopeIdStamping(String envelopeIdStamping) {
        this.envelopeIdStamping = envelopeIdStamping;
    }

    public Envelope authoritativeCopy(String authoritativeCopy) {
        this.authoritativeCopy = authoritativeCopy;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies the Authoritative copy feature. If set to true the Authoritative copy feature is enabled.")
    @JsonProperty(value="authoritativeCopy")
    public String getAuthoritativeCopy() {
        return this.authoritativeCopy;
    }

    public void setAuthoritativeCopy(String authoritativeCopy) {
        this.authoritativeCopy = authoritativeCopy;
    }

    public Envelope notification(Notification notification) {
        this.notification = notification;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="notification")
    public Notification getNotification() {
        return this.notification;
    }

    public void setNotification(Notification notification) {
        this.notification = notification;
    }

    public Envelope notificationUri(String notificationUri) {
        this.notificationUri = notificationUri;
        return this;
    }

    @ApiModelProperty(example="null", value="Contains a URI for an endpoint that you can use to retrieve the notifications.")
    @JsonProperty(value="notificationUri")
    public String getNotificationUri() {
        return this.notificationUri;
    }

    public void setNotificationUri(String notificationUri) {
        this.notificationUri = notificationUri;
    }

    public Envelope enforceSignerVisibility(String enforceSignerVisibility) {
        this.enforceSignerVisibility = enforceSignerVisibility;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, documents with tabs can only be viewed by signers that have a tab on that document. Recipients that have an administrative role (Agent, Editor, or Intermediaries) or informational role (Certified Deliveries or Carbon Copies) can always see all the documents in an envelope, unless they are specifically excluded using this setting when an envelope is sent. Documents that do not have tabs are always visible to all recipients, unless they are specifically excluded using this setting when an envelope is sent.\n\nYour account must have Document Visibility enabled to use this.")
    @JsonProperty(value="enforceSignerVisibility")
    public String getEnforceSignerVisibility() {
        return this.enforceSignerVisibility;
    }

    public void setEnforceSignerVisibility(String enforceSignerVisibility) {
        this.enforceSignerVisibility = enforceSignerVisibility;
    }

    public Envelope enableWetSign(String enableWetSign) {
        this.enableWetSign = enableWetSign;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, the signer is allowed to print the document and sign it on paper.")
    @JsonProperty(value="enableWetSign")
    public String getEnableWetSign() {
        return this.enableWetSign;
    }

    public void setEnableWetSign(String enableWetSign) {
        this.enableWetSign = enableWetSign;
    }

    public Envelope allowMarkup(String allowMarkup) {
        this.allowMarkup = allowMarkup;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, Document Markup is enabled for envelope. Account must have Document Markup enabled to use this")
    @JsonProperty(value="allowMarkup")
    public String getAllowMarkup() {
        return this.allowMarkup;
    }

    public void setAllowMarkup(String allowMarkup) {
        this.allowMarkup = allowMarkup;
    }

    public Envelope allowReassign(String allowReassign) {
        this.allowReassign = allowReassign;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, the recipient can redirect an envelope to a more appropriate recipient.")
    @JsonProperty(value="allowReassign")
    public String getAllowReassign() {
        return this.allowReassign;
    }

    public void setAllowReassign(String allowReassign) {
        this.allowReassign = allowReassign;
    }

    public Envelope createdDateTime(String createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates the date and time the item was created.")
    @JsonProperty(value="createdDateTime")
    public String getCreatedDateTime() {
        return this.createdDateTime;
    }

    public void setCreatedDateTime(String createdDateTime) {
        this.createdDateTime = createdDateTime;
    }

    public Envelope lastModifiedDateTime(String lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The date and time the item was last modified.")
    @JsonProperty(value="lastModifiedDateTime")
    public String getLastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public void setLastModifiedDateTime(String lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
    }

    public Envelope deliveredDateTime(String deliveredDateTime) {
        this.deliveredDateTime = deliveredDateTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Reserved: For DocuSign use only.")
    @JsonProperty(value="deliveredDateTime")
    public String getDeliveredDateTime() {
        return this.deliveredDateTime;
    }

    public void setDeliveredDateTime(String deliveredDateTime) {
        this.deliveredDateTime = deliveredDateTime;
    }

    public Envelope initialSentDateTime(String initialSentDateTime) {
        this.initialSentDateTime = initialSentDateTime;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="initialSentDateTime")
    public String getInitialSentDateTime() {
        return this.initialSentDateTime;
    }

    public void setInitialSentDateTime(String initialSentDateTime) {
        this.initialSentDateTime = initialSentDateTime;
    }

    public Envelope sentDateTime(String sentDateTime) {
        this.sentDateTime = sentDateTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The date and time the envelope was sent.")
    @JsonProperty(value="sentDateTime")
    public String getSentDateTime() {
        return this.sentDateTime;
    }

    public void setSentDateTime(String sentDateTime) {
        this.sentDateTime = sentDateTime;
    }

    public Envelope completedDateTime(String completedDateTime) {
        this.completedDateTime = completedDateTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies the date and time this item was completed.")
    @JsonProperty(value="completedDateTime")
    public String getCompletedDateTime() {
        return this.completedDateTime;
    }

    public void setCompletedDateTime(String completedDateTime) {
        this.completedDateTime = completedDateTime;
    }

    public Envelope voidedDateTime(String voidedDateTime) {
        this.voidedDateTime = voidedDateTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The date and time the envelope or template was voided.")
    @JsonProperty(value="voidedDateTime")
    public String getVoidedDateTime() {
        return this.voidedDateTime;
    }

    public void setVoidedDateTime(String voidedDateTime) {
        this.voidedDateTime = voidedDateTime;
    }

    public Envelope voidedReason(String voidedReason) {
        this.voidedReason = voidedReason;
        return this;
    }

    @ApiModelProperty(example="null", value="The reason the envelope or template was voided.")
    @JsonProperty(value="voidedReason")
    public String getVoidedReason() {
        return this.voidedReason;
    }

    public void setVoidedReason(String voidedReason) {
        this.voidedReason = voidedReason;
    }

    public Envelope deletedDateTime(String deletedDateTime) {
        this.deletedDateTime = deletedDateTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies the data and time the item was deleted.")
    @JsonProperty(value="deletedDateTime")
    public String getDeletedDateTime() {
        return this.deletedDateTime;
    }

    public void setDeletedDateTime(String deletedDateTime) {
        this.deletedDateTime = deletedDateTime;
    }

    public Envelope declinedDateTime(String declinedDateTime) {
        this.declinedDateTime = declinedDateTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The date and time the recipient declined the document.")
    @JsonProperty(value="declinedDateTime")
    public String getDeclinedDateTime() {
        return this.declinedDateTime;
    }

    public void setDeclinedDateTime(String declinedDateTime) {
        this.declinedDateTime = declinedDateTime;
    }

    public Envelope statusChangedDateTime(String statusChangedDateTime) {
        this.statusChangedDateTime = statusChangedDateTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The data and time the status changed.")
    @JsonProperty(value="statusChangedDateTime")
    public String getStatusChangedDateTime() {
        return this.statusChangedDateTime;
    }

    public void setStatusChangedDateTime(String statusChangedDateTime) {
        this.statusChangedDateTime = statusChangedDateTime;
    }

    public Envelope documentsCombinedUri(String documentsCombinedUri) {
        this.documentsCombinedUri = documentsCombinedUri;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="documentsCombinedUri")
    public String getDocumentsCombinedUri() {
        return this.documentsCombinedUri;
    }

    public void setDocumentsCombinedUri(String documentsCombinedUri) {
        this.documentsCombinedUri = documentsCombinedUri;
    }

    public Envelope certificateUri(String certificateUri) {
        this.certificateUri = certificateUri;
        return this;
    }

    @ApiModelProperty(example="null", value="Retrieves a URI for an endpoint that allows you to easily retrieve certificate information.")
    @JsonProperty(value="certificateUri")
    public String getCertificateUri() {
        return this.certificateUri;
    }

    public void setCertificateUri(String certificateUri) {
        this.certificateUri = certificateUri;
    }

    public Envelope templatesUri(String templatesUri) {
        this.templatesUri = templatesUri;
        return this;
    }

    @ApiModelProperty(example="null", value="Contains a URI for an endpoint which you can use to retrieve the templates.")
    @JsonProperty(value="templatesUri")
    public String getTemplatesUri() {
        return this.templatesUri;
    }

    public void setTemplatesUri(String templatesUri) {
        this.templatesUri = templatesUri;
    }

    public Envelope messageLock(String messageLock) {
        this.messageLock = messageLock;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, prevents senders from changing the contents of `emailBlurb` and `emailSubject` properties for the envelope. \n\nAdditionally, this prevents users from making changes to the contents of `emailBlurb` and `emailSubject` properties when correcting envelopes. \n\nHowever, if the `messageLock` node is set to true**** and the `emailSubject` property is empty, senders and correctors are able to add a subject to the envelope.")
    @JsonProperty(value="messageLock")
    public String getMessageLock() {
        return this.messageLock;
    }

    public void setMessageLock(String messageLock) {
        this.messageLock = messageLock;
    }

    public Envelope recipientsLock(String recipientsLock) {
        this.recipientsLock = recipientsLock;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, prevents senders from changing, correcting, or deleting the recipient information for the envelope.")
    @JsonProperty(value="recipientsLock")
    public String getRecipientsLock() {
        return this.recipientsLock;
    }

    public void setRecipientsLock(String recipientsLock) {
        this.recipientsLock = recipientsLock;
    }

    public Envelope recipients(Recipients recipients) {
        this.recipients = recipients;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="recipients")
    public Recipients getRecipients() {
        return this.recipients;
    }

    public void setRecipients(Recipients recipients) {
        this.recipients = recipients;
    }

    public Envelope brandLock(String brandLock) {
        this.brandLock = brandLock;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="brandLock")
    public String getBrandLock() {
        return this.brandLock;
    }

    public void setBrandLock(String brandLock) {
        this.brandLock = brandLock;
    }

    public Envelope brandId(String brandId) {
        this.brandId = brandId;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="brandId")
    public String getBrandId() {
        return this.brandId;
    }

    public void setBrandId(String brandId) {
        this.brandId = brandId;
    }

    public Envelope useDisclosure(String useDisclosure) {
        this.useDisclosure = useDisclosure;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, the disclosure is shown to recipients in accordance with the account\u2019s Electronic Record and Signature Disclosure frequency setting. When set to **false**, the Electronic Record and Signature Disclosure is not shown to any envelope recipients. \n\nIf the `useDisclosure` property is not set, then the account's normal disclosure setting is used and the value of the `useDisclosure` property is not returned in responses when getting envelope information.")
    @JsonProperty(value="useDisclosure")
    public String getUseDisclosure() {
        return this.useDisclosure;
    }

    public void setUseDisclosure(String useDisclosure) {
        this.useDisclosure = useDisclosure;
    }

    public Envelope emailSettings(EmailSettings emailSettings) {
        this.emailSettings = emailSettings;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="emailSettings")
    public EmailSettings getEmailSettings() {
        return this.emailSettings;
    }

    public void setEmailSettings(EmailSettings emailSettings) {
        this.emailSettings = emailSettings;
    }

    public Envelope purgeState(String purgeState) {
        this.purgeState = purgeState;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="purgeState")
    public String getPurgeState() {
        return this.purgeState;
    }

    public void setPurgeState(String purgeState) {
        this.purgeState = purgeState;
    }

    public Envelope lockInformation(LockInformation lockInformation) {
        this.lockInformation = lockInformation;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="lockInformation")
    public LockInformation getLockInformation() {
        return this.lockInformation;
    }

    public void setLockInformation(LockInformation lockInformation) {
        this.lockInformation = lockInformation;
    }

    public Envelope is21CFRPart11(String is21CFRPart11) {
        this.is21CFRPart11 = is21CFRPart11;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, indicates that this module is enabled on the account.")
    @JsonProperty(value="is21CFRPart11")
    public String getIs21CFRPart11() {
        return this.is21CFRPart11;
    }

    public void setIs21CFRPart11(String is21CFRPart11) {
        this.is21CFRPart11 = is21CFRPart11;
    }

    public Envelope isSignatureProviderEnvelope(String isSignatureProviderEnvelope) {
        this.isSignatureProviderEnvelope = isSignatureProviderEnvelope;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="isSignatureProviderEnvelope")
    public String getIsSignatureProviderEnvelope() {
        return this.isSignatureProviderEnvelope;
    }

    public void setIsSignatureProviderEnvelope(String isSignatureProviderEnvelope) {
        this.isSignatureProviderEnvelope = isSignatureProviderEnvelope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Envelope envelope = (Envelope)o;
        return Objects.equals(this.transactionId, envelope.transactionId) && Objects.equals(this.status, envelope.status) && Objects.equals(this.documentsUri, envelope.documentsUri) && Objects.equals(this.recipientsUri, envelope.recipientsUri) && Objects.equals(this.asynchronous, envelope.asynchronous) && Objects.equals(this.envelopeUri, envelope.envelopeUri) && Objects.equals(this.emailSubject, envelope.emailSubject) && Objects.equals(this.emailBlurb, envelope.emailBlurb) && Objects.equals(this.envelopeId, envelope.envelopeId) && Objects.equals(this.signingLocation, envelope.signingLocation) && Objects.equals(this.customFieldsUri, envelope.customFieldsUri) && Objects.equals(this.customFields, envelope.customFields) && Objects.equals(this.autoNavigation, envelope.autoNavigation) && Objects.equals(this.envelopeIdStamping, envelope.envelopeIdStamping) && Objects.equals(this.authoritativeCopy, envelope.authoritativeCopy) && Objects.equals(this.notification, envelope.notification) && Objects.equals(this.notificationUri, envelope.notificationUri) && Objects.equals(this.enforceSignerVisibility, envelope.enforceSignerVisibility) && Objects.equals(this.enableWetSign, envelope.enableWetSign) && Objects.equals(this.allowMarkup, envelope.allowMarkup) && Objects.equals(this.allowReassign, envelope.allowReassign) && Objects.equals(this.createdDateTime, envelope.createdDateTime) && Objects.equals(this.lastModifiedDateTime, envelope.lastModifiedDateTime) && Objects.equals(this.deliveredDateTime, envelope.deliveredDateTime) && Objects.equals(this.initialSentDateTime, envelope.initialSentDateTime) && Objects.equals(this.sentDateTime, envelope.sentDateTime) && Objects.equals(this.completedDateTime, envelope.completedDateTime) && Objects.equals(this.voidedDateTime, envelope.voidedDateTime) && Objects.equals(this.voidedReason, envelope.voidedReason) && Objects.equals(this.deletedDateTime, envelope.deletedDateTime) && Objects.equals(this.declinedDateTime, envelope.declinedDateTime) && Objects.equals(this.statusChangedDateTime, envelope.statusChangedDateTime) && Objects.equals(this.documentsCombinedUri, envelope.documentsCombinedUri) && Objects.equals(this.certificateUri, envelope.certificateUri) && Objects.equals(this.templatesUri, envelope.templatesUri) && Objects.equals(this.messageLock, envelope.messageLock) && Objects.equals(this.recipientsLock, envelope.recipientsLock) && Objects.equals(this.recipients, envelope.recipients) && Objects.equals(this.brandLock, envelope.brandLock) && Objects.equals(this.brandId, envelope.brandId) && Objects.equals(this.useDisclosure, envelope.useDisclosure) && Objects.equals(this.emailSettings, envelope.emailSettings) && Objects.equals(this.purgeState, envelope.purgeState) && Objects.equals(this.lockInformation, envelope.lockInformation) && Objects.equals(this.is21CFRPart11, envelope.is21CFRPart11) && Objects.equals(this.isSignatureProviderEnvelope, envelope.isSignatureProviderEnvelope);
    }

    public int hashCode() {
        return Objects.hash(this.transactionId, this.status, this.documentsUri, this.recipientsUri, this.asynchronous, this.envelopeUri, this.emailSubject, this.emailBlurb, this.envelopeId, this.signingLocation, this.customFieldsUri, this.customFields, this.autoNavigation, this.envelopeIdStamping, this.authoritativeCopy, this.notification, this.notificationUri, this.enforceSignerVisibility, this.enableWetSign, this.allowMarkup, this.allowReassign, this.createdDateTime, this.lastModifiedDateTime, this.deliveredDateTime, this.initialSentDateTime, this.sentDateTime, this.completedDateTime, this.voidedDateTime, this.voidedReason, this.deletedDateTime, this.declinedDateTime, this.statusChangedDateTime, this.documentsCombinedUri, this.certificateUri, this.templatesUri, this.messageLock, this.recipientsLock, this.recipients, this.brandLock, this.brandId, this.useDisclosure, this.emailSettings, this.purgeState, this.lockInformation, this.is21CFRPart11, this.isSignatureProviderEnvelope);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Envelope {\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    documentsUri: ").append(this.toIndentedString(this.documentsUri)).append("\n");
        sb.append("    recipientsUri: ").append(this.toIndentedString(this.recipientsUri)).append("\n");
        sb.append("    asynchronous: ").append(this.toIndentedString(this.asynchronous)).append("\n");
        sb.append("    envelopeUri: ").append(this.toIndentedString(this.envelopeUri)).append("\n");
        sb.append("    emailSubject: ").append(this.toIndentedString(this.emailSubject)).append("\n");
        sb.append("    emailBlurb: ").append(this.toIndentedString(this.emailBlurb)).append("\n");
        sb.append("    envelopeId: ").append(this.toIndentedString(this.envelopeId)).append("\n");
        sb.append("    signingLocation: ").append(this.toIndentedString(this.signingLocation)).append("\n");
        sb.append("    customFieldsUri: ").append(this.toIndentedString(this.customFieldsUri)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    autoNavigation: ").append(this.toIndentedString(this.autoNavigation)).append("\n");
        sb.append("    envelopeIdStamping: ").append(this.toIndentedString(this.envelopeIdStamping)).append("\n");
        sb.append("    authoritativeCopy: ").append(this.toIndentedString(this.authoritativeCopy)).append("\n");
        sb.append("    notification: ").append(this.toIndentedString(this.notification)).append("\n");
        sb.append("    notificationUri: ").append(this.toIndentedString(this.notificationUri)).append("\n");
        sb.append("    enforceSignerVisibility: ").append(this.toIndentedString(this.enforceSignerVisibility)).append("\n");
        sb.append("    enableWetSign: ").append(this.toIndentedString(this.enableWetSign)).append("\n");
        sb.append("    allowMarkup: ").append(this.toIndentedString(this.allowMarkup)).append("\n");
        sb.append("    allowReassign: ").append(this.toIndentedString(this.allowReassign)).append("\n");
        sb.append("    createdDateTime: ").append(this.toIndentedString(this.createdDateTime)).append("\n");
        sb.append("    lastModifiedDateTime: ").append(this.toIndentedString(this.lastModifiedDateTime)).append("\n");
        sb.append("    deliveredDateTime: ").append(this.toIndentedString(this.deliveredDateTime)).append("\n");
        sb.append("    initialSentDateTime: ").append(this.toIndentedString(this.initialSentDateTime)).append("\n");
        sb.append("    sentDateTime: ").append(this.toIndentedString(this.sentDateTime)).append("\n");
        sb.append("    completedDateTime: ").append(this.toIndentedString(this.completedDateTime)).append("\n");
        sb.append("    voidedDateTime: ").append(this.toIndentedString(this.voidedDateTime)).append("\n");
        sb.append("    voidedReason: ").append(this.toIndentedString(this.voidedReason)).append("\n");
        sb.append("    deletedDateTime: ").append(this.toIndentedString(this.deletedDateTime)).append("\n");
        sb.append("    declinedDateTime: ").append(this.toIndentedString(this.declinedDateTime)).append("\n");
        sb.append("    statusChangedDateTime: ").append(this.toIndentedString(this.statusChangedDateTime)).append("\n");
        sb.append("    documentsCombinedUri: ").append(this.toIndentedString(this.documentsCombinedUri)).append("\n");
        sb.append("    certificateUri: ").append(this.toIndentedString(this.certificateUri)).append("\n");
        sb.append("    templatesUri: ").append(this.toIndentedString(this.templatesUri)).append("\n");
        sb.append("    messageLock: ").append(this.toIndentedString(this.messageLock)).append("\n");
        sb.append("    recipientsLock: ").append(this.toIndentedString(this.recipientsLock)).append("\n");
        sb.append("    recipients: ").append(this.toIndentedString(this.recipients)).append("\n");
        sb.append("    brandLock: ").append(this.toIndentedString(this.brandLock)).append("\n");
        sb.append("    brandId: ").append(this.toIndentedString(this.brandId)).append("\n");
        sb.append("    useDisclosure: ").append(this.toIndentedString(this.useDisclosure)).append("\n");
        sb.append("    emailSettings: ").append(this.toIndentedString(this.emailSettings)).append("\n");
        sb.append("    purgeState: ").append(this.toIndentedString(this.purgeState)).append("\n");
        sb.append("    lockInformation: ").append(this.toIndentedString(this.lockInformation)).append("\n");
        sb.append("    is21CFRPart11: ").append(this.toIndentedString(this.is21CFRPart11)).append("\n");
        sb.append("    isSignatureProviderEnvelope: ").append(this.toIndentedString(this.isSignatureProviderEnvelope)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

