/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class OfflineAttributes {
    private String deviceName = null;
    private String deviceModel = null;
    private String gpsLatitude = null;
    private String gpsLongitude = null;
    private String accountEsignId = null;
    private String offlineSigningHash = null;

    public OfflineAttributes deviceName(String deviceName) {
        this.deviceName = deviceName;
        return this;
    }

    @ApiModelProperty(example="null", value="A string containing information about the type of device used for offline signing.")
    @JsonProperty(value="deviceName")
    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public OfflineAttributes deviceModel(String deviceModel) {
        this.deviceModel = deviceModel;
        return this;
    }

    @ApiModelProperty(example="null", value="A string containing information about the model of the device used for offline signing.")
    @JsonProperty(value="deviceModel")
    public String getDeviceModel() {
        return this.deviceModel;
    }

    public void setDeviceModel(String deviceModel) {
        this.deviceModel = deviceModel;
    }

    public OfflineAttributes gpsLatitude(String gpsLatitude) {
        this.gpsLatitude = gpsLatitude;
        return this;
    }

    @ApiModelProperty(example="null", value="A string containing the latitude of the device location at the time of signing.")
    @JsonProperty(value="gpsLatitude")
    public String getGpsLatitude() {
        return this.gpsLatitude;
    }

    public void setGpsLatitude(String gpsLatitude) {
        this.gpsLatitude = gpsLatitude;
    }

    public OfflineAttributes gpsLongitude(String gpsLongitude) {
        this.gpsLongitude = gpsLongitude;
        return this;
    }

    @ApiModelProperty(example="null", value="A string containing the longitude of the device location at the time of signing.")
    @JsonProperty(value="gpsLongitude")
    public String getGpsLongitude() {
        return this.gpsLongitude;
    }

    public void setGpsLongitude(String gpsLongitude) {
        this.gpsLongitude = gpsLongitude;
    }

    public OfflineAttributes accountEsignId(String accountEsignId) {
        this.accountEsignId = accountEsignId;
        return this;
    }

    @ApiModelProperty(example="null", value="A GUID identifying the account associated with the consumer disclosure")
    @JsonProperty(value="accountEsignId")
    public String getAccountEsignId() {
        return this.accountEsignId;
    }

    public void setAccountEsignId(String accountEsignId) {
        this.accountEsignId = accountEsignId;
    }

    public OfflineAttributes offlineSigningHash(String offlineSigningHash) {
        this.offlineSigningHash = offlineSigningHash;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="offlineSigningHash")
    public String getOfflineSigningHash() {
        return this.offlineSigningHash;
    }

    public void setOfflineSigningHash(String offlineSigningHash) {
        this.offlineSigningHash = offlineSigningHash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OfflineAttributes offlineAttributes = (OfflineAttributes)o;
        return Objects.equals(this.deviceName, offlineAttributes.deviceName) && Objects.equals(this.deviceModel, offlineAttributes.deviceModel) && Objects.equals(this.gpsLatitude, offlineAttributes.gpsLatitude) && Objects.equals(this.gpsLongitude, offlineAttributes.gpsLongitude) && Objects.equals(this.accountEsignId, offlineAttributes.accountEsignId) && Objects.equals(this.offlineSigningHash, offlineAttributes.offlineSigningHash);
    }

    public int hashCode() {
        return Objects.hash(this.deviceName, this.deviceModel, this.gpsLatitude, this.gpsLongitude, this.accountEsignId, this.offlineSigningHash);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OfflineAttributes {\n");
        sb.append("    deviceName: ").append(this.toIndentedString(this.deviceName)).append("\n");
        sb.append("    deviceModel: ").append(this.toIndentedString(this.deviceModel)).append("\n");
        sb.append("    gpsLatitude: ").append(this.toIndentedString(this.gpsLatitude)).append("\n");
        sb.append("    gpsLongitude: ").append(this.toIndentedString(this.gpsLongitude)).append("\n");
        sb.append("    accountEsignId: ").append(this.toIndentedString(this.accountEsignId)).append("\n");
        sb.append("    offlineSigningHash: ").append(this.toIndentedString(this.offlineSigningHash)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

