/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.api;

import com.docusign.esign.client.ApiClient;
import com.docusign.esign.client.ApiException;
import com.docusign.esign.client.Configuration;
import com.docusign.esign.client.Pair;
import com.docusign.esign.model.AccountInformation;
import com.docusign.esign.model.AccountSettingsInformation;
import com.docusign.esign.model.AccountSharedAccess;
import com.docusign.esign.model.AccountSignatureProviders;
import com.docusign.esign.model.BillingChargeResponse;
import com.docusign.esign.model.Brand;
import com.docusign.esign.model.BrandResources;
import com.docusign.esign.model.BrandResourcesList;
import com.docusign.esign.model.BrandsRequest;
import com.docusign.esign.model.BrandsResponse;
import com.docusign.esign.model.CaptiveRecipientInformation;
import com.docusign.esign.model.ConsumerDisclosure;
import com.docusign.esign.model.CustomFields;
import com.docusign.esign.model.ENoteConfiguration;
import com.docusign.esign.model.FileTypeList;
import com.docusign.esign.model.NewAccountDefinition;
import com.docusign.esign.model.NewAccountSummary;
import com.docusign.esign.model.PermissionProfile;
import com.docusign.esign.model.PermissionProfileInformation;
import com.docusign.esign.model.PostTransactionsRequest;
import com.docusign.esign.model.PostTransactionsResponse;
import com.docusign.esign.model.ProvisioningInformation;
import com.docusign.esign.model.RecipientNamesResponse;
import com.docusign.esign.model.TabAccountSettings;
import com.sun.jersey.api.client.GenericType;
import java.util.ArrayList;
import java.util.HashMap;

public class AccountsApi {
    private ApiClient apiClient;

    public AccountsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AccountsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public NewAccountSummary create(NewAccountDefinition newAccountDefinition) throws ApiException {
        return this.create(newAccountDefinition, null);
    }

    public NewAccountSummary create(NewAccountDefinition newAccountDefinition, CreateOptions options) throws ApiException {
        NewAccountDefinition postBody = newAccountDefinition;
        String path = "/v2/accounts".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "preview_billing_plan", options.previewBillingPlan));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<NewAccountSummary> returnType = new GenericType<NewAccountSummary>(){};
        return this.apiClient.invokeAPI(path, "POST", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public ProvisioningInformation getProvisioning() throws ApiException {
        Object postBody = null;
        String path = "/v2/accounts/provisioning".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<ProvisioningInformation> returnType = new GenericType<ProvisioningInformation>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public AccountInformation getAccountInformation(String accountId) throws ApiException {
        return this.getAccountInformation(accountId, null);
    }

    public AccountInformation getAccountInformation(String accountId, GetAccountInformationOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getAccountInformation");
        }
        String path = "/v2/accounts/{accountId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "include_account_settings", options.includeAccountSettings));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<AccountInformation> returnType = new GenericType<AccountInformation>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public void delete(String accountId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling delete");
        }
        String path = "/v2/accounts/{accountId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(path, "DELETE", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, null);
    }

    public BillingChargeResponse getBillingCharges(String accountId) throws ApiException {
        return this.getBillingCharges(accountId, null);
    }

    public BillingChargeResponse getBillingCharges(String accountId, GetBillingChargesOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getBillingCharges");
        }
        String path = "/v2/accounts/{accountId}/billing_charges".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "include_charges", options.includeCharges));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<BillingChargeResponse> returnType = new GenericType<BillingChargeResponse>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public BrandsResponse listBrands(String accountId) throws ApiException {
        return this.listBrands(accountId, null);
    }

    public BrandsResponse listBrands(String accountId, ListBrandsOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listBrands");
        }
        String path = "/v2/accounts/{accountId}/brands".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "exclude_distributor_brand", options.excludeDistributorBrand));
            queryParams.addAll(this.apiClient.parameterToPairs("", "include_logos", options.includeLogos));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<BrandsResponse> returnType = new GenericType<BrandsResponse>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public BrandsResponse createBrand(String accountId, Brand brand) throws ApiException {
        Brand postBody = brand;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createBrand");
        }
        String path = "/v2/accounts/{accountId}/brands".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<BrandsResponse> returnType = new GenericType<BrandsResponse>(){};
        return this.apiClient.invokeAPI(path, "POST", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public BrandsResponse deleteBrands(String accountId, BrandsRequest brandsRequest) throws ApiException {
        BrandsRequest postBody = brandsRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteBrands");
        }
        String path = "/v2/accounts/{accountId}/brands".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<BrandsResponse> returnType = new GenericType<BrandsResponse>(){};
        return this.apiClient.invokeAPI(path, "DELETE", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public Brand getBrand(String accountId, String brandId) throws ApiException {
        return this.getBrand(accountId, brandId, null);
    }

    public Brand getBrand(String accountId, String brandId, GetBrandOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getBrand");
        }
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling getBrand");
        }
        String path = "/v2/accounts/{accountId}/brands/{brandId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "include_external_references", options.includeExternalReferences));
            queryParams.addAll(this.apiClient.parameterToPairs("", "include_logos", options.includeLogos));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<Brand> returnType = new GenericType<Brand>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public Brand updateBrand(String accountId, String brandId, Brand brand) throws ApiException {
        Brand postBody = brand;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateBrand");
        }
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling updateBrand");
        }
        String path = "/v2/accounts/{accountId}/brands/{brandId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<Brand> returnType = new GenericType<Brand>(){};
        return this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public void deleteBrand(String accountId, String brandId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteBrand");
        }
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling deleteBrand");
        }
        String path = "/v2/accounts/{accountId}/brands/{brandId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(path, "DELETE", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, null);
    }

    public void getBrandLogoByType(String accountId, String brandId, String logoType) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getBrandLogoByType");
        }
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling getBrandLogoByType");
        }
        if (logoType == null) {
            throw new ApiException(400, "Missing the required parameter 'logoType' when calling getBrandLogoByType");
        }
        String path = "/v2/accounts/{accountId}/brands/{brandId}/logos/{logoType}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{logoType\\}", this.apiClient.escapeString(logoType.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, null);
    }

    public void updateBrandLogoByType(String accountId, String brandId, String logoType) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateBrandLogoByType");
        }
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling updateBrandLogoByType");
        }
        if (logoType == null) {
            throw new ApiException(400, "Missing the required parameter 'logoType' when calling updateBrandLogoByType");
        }
        String path = "/v2/accounts/{accountId}/brands/{brandId}/logos/{logoType}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{logoType\\}", this.apiClient.escapeString(logoType.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, null);
    }

    public void deleteBrandLogoByType(String accountId, String brandId, String logoType) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteBrandLogoByType");
        }
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling deleteBrandLogoByType");
        }
        if (logoType == null) {
            throw new ApiException(400, "Missing the required parameter 'logoType' when calling deleteBrandLogoByType");
        }
        String path = "/v2/accounts/{accountId}/brands/{brandId}/logos/{logoType}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{logoType\\}", this.apiClient.escapeString(logoType.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(path, "DELETE", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, null);
    }

    public BrandResourcesList getBrandResources(String accountId, String brandId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getBrandResources");
        }
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling getBrandResources");
        }
        String path = "/v2/accounts/{accountId}/brands/{brandId}/resources".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<BrandResourcesList> returnType = new GenericType<BrandResourcesList>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public void getBrandResourcesByContentType(String accountId, String brandId, String resourceContentType) throws ApiException {
        this.getBrandResourcesByContentType(accountId, brandId, resourceContentType, null);
    }

    public void getBrandResourcesByContentType(String accountId, String brandId, String resourceContentType, GetBrandResourcesByContentTypeOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getBrandResourcesByContentType");
        }
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling getBrandResourcesByContentType");
        }
        if (resourceContentType == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceContentType' when calling getBrandResourcesByContentType");
        }
        String path = "/v2/accounts/{accountId}/brands/{brandId}/resources/{resourceContentType}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{resourceContentType\\}", this.apiClient.escapeString(resourceContentType.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "langcode", options.langcode));
            queryParams.addAll(this.apiClient.parameterToPairs("", "return_master", options.returnMaster));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, null);
    }

    public BrandResources updateBrandResourcesByContentType(String accountId, String brandId, String resourceContentType) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateBrandResourcesByContentType");
        }
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling updateBrandResourcesByContentType");
        }
        if (resourceContentType == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceContentType' when calling updateBrandResourcesByContentType");
        }
        String path = "/v2/accounts/{accountId}/brands/{brandId}/resources/{resourceContentType}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{resourceContentType\\}", this.apiClient.escapeString(resourceContentType.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<BrandResources> returnType = new GenericType<BrandResources>(){};
        return this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public CaptiveRecipientInformation deleteCaptiveRecipient(String accountId, String recipientPart, CaptiveRecipientInformation captiveRecipientInformation) throws ApiException {
        CaptiveRecipientInformation postBody = captiveRecipientInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteCaptiveRecipient");
        }
        if (recipientPart == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientPart' when calling deleteCaptiveRecipient");
        }
        String path = "/v2/accounts/{accountId}/captive_recipients/{recipientPart}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{recipientPart\\}", this.apiClient.escapeString(recipientPart.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<CaptiveRecipientInformation> returnType = new GenericType<CaptiveRecipientInformation>(){};
        return this.apiClient.invokeAPI(path, "DELETE", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public ConsumerDisclosure getConsumerDisclosureDefault(String accountId) throws ApiException {
        return this.getConsumerDisclosureDefault(accountId, null);
    }

    public ConsumerDisclosure getConsumerDisclosureDefault(String accountId, GetConsumerDisclosureDefaultOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getConsumerDisclosureDefault");
        }
        String path = "/v2/accounts/{accountId}/consumer_disclosure".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "langCode", options.langCode));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<ConsumerDisclosure> returnType = new GenericType<ConsumerDisclosure>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public ConsumerDisclosure getConsumerDisclosure(String accountId, String langCode) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getConsumerDisclosure");
        }
        if (langCode == null) {
            throw new ApiException(400, "Missing the required parameter 'langCode' when calling getConsumerDisclosure");
        }
        String path = "/v2/accounts/{accountId}/consumer_disclosure/{langCode}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{langCode\\}", this.apiClient.escapeString(langCode.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<ConsumerDisclosure> returnType = new GenericType<ConsumerDisclosure>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public CustomFields listCustomFields(String accountId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listCustomFields");
        }
        String path = "/v2/accounts/{accountId}/custom_fields".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<CustomFields> returnType = new GenericType<CustomFields>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public PostTransactionsResponse createEMortgageTransaction(String accountId, PostTransactionsRequest postTransactionsRequest) throws ApiException {
        PostTransactionsRequest postBody = postTransactionsRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createEMortgageTransaction");
        }
        String path = "/v2/accounts/{accountId}/eMortgage/transactions".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<PostTransactionsResponse> returnType = new GenericType<PostTransactionsResponse>(){};
        return this.apiClient.invokeAPI(path, "POST", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public PermissionProfileInformation listPermissions(String accountId) throws ApiException {
        return this.listPermissions(accountId, null);
    }

    public PermissionProfileInformation listPermissions(String accountId, ListPermissionsOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listPermissions");
        }
        String path = "/v2/accounts/{accountId}/permission_profiles".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "include", options.include));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<PermissionProfileInformation> returnType = new GenericType<PermissionProfileInformation>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public PermissionProfile createPermissionProfile(String accountId, PermissionProfile permissionProfile) throws ApiException {
        return this.createPermissionProfile(accountId, permissionProfile, null);
    }

    public PermissionProfile createPermissionProfile(String accountId, PermissionProfile permissionProfile, CreatePermissionProfileOptions options) throws ApiException {
        PermissionProfile postBody = permissionProfile;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createPermissionProfile");
        }
        String path = "/v2/accounts/{accountId}/permission_profiles".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "include", options.include));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<PermissionProfile> returnType = new GenericType<PermissionProfile>(){};
        return this.apiClient.invokeAPI(path, "POST", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public PermissionProfile getPermissionProfile(String accountId, String permissionProfileId) throws ApiException {
        return this.getPermissionProfile(accountId, permissionProfileId, null);
    }

    public PermissionProfile getPermissionProfile(String accountId, String permissionProfileId, GetPermissionProfileOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getPermissionProfile");
        }
        if (permissionProfileId == null) {
            throw new ApiException(400, "Missing the required parameter 'permissionProfileId' when calling getPermissionProfile");
        }
        String path = "/v2/accounts/{accountId}/permission_profiles/{permissionProfileId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{permissionProfileId\\}", this.apiClient.escapeString(permissionProfileId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "include", options.include));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<PermissionProfile> returnType = new GenericType<PermissionProfile>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public PermissionProfile updatePermissionProfile(String accountId, String permissionProfileId, PermissionProfile permissionProfile) throws ApiException {
        return this.updatePermissionProfile(accountId, permissionProfileId, permissionProfile, null);
    }

    public PermissionProfile updatePermissionProfile(String accountId, String permissionProfileId, PermissionProfile permissionProfile, UpdatePermissionProfileOptions options) throws ApiException {
        PermissionProfile postBody = permissionProfile;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updatePermissionProfile");
        }
        if (permissionProfileId == null) {
            throw new ApiException(400, "Missing the required parameter 'permissionProfileId' when calling updatePermissionProfile");
        }
        String path = "/v2/accounts/{accountId}/permission_profiles/{permissionProfileId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{permissionProfileId\\}", this.apiClient.escapeString(permissionProfileId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "include", options.include));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<PermissionProfile> returnType = new GenericType<PermissionProfile>(){};
        return this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public void deletePermissionProfile(String accountId, String permissionProfileId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deletePermissionProfile");
        }
        if (permissionProfileId == null) {
            throw new ApiException(400, "Missing the required parameter 'permissionProfileId' when calling deletePermissionProfile");
        }
        String path = "/v2/accounts/{accountId}/permission_profiles/{permissionProfileId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{permissionProfileId\\}", this.apiClient.escapeString(permissionProfileId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(path, "DELETE", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, null);
    }

    public RecipientNamesResponse listRecipientNamesByEmail(String accountId) throws ApiException {
        return this.listRecipientNamesByEmail(accountId, null);
    }

    public RecipientNamesResponse listRecipientNamesByEmail(String accountId, ListRecipientNamesByEmailOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listRecipientNamesByEmail");
        }
        String path = "/v2/accounts/{accountId}/recipient_names".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "email", options.email));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<RecipientNamesResponse> returnType = new GenericType<RecipientNamesResponse>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public AccountSettingsInformation listSettings(String accountId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listSettings");
        }
        String path = "/v2/accounts/{accountId}/settings".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<AccountSettingsInformation> returnType = new GenericType<AccountSettingsInformation>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public void updateSettings(String accountId, AccountSettingsInformation accountSettingsInformation) throws ApiException {
        AccountSettingsInformation postBody = accountSettingsInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateSettings");
        }
        String path = "/v2/accounts/{accountId}/settings".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, null);
    }

    public ENoteConfiguration getENoteConfiguration(String accountId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getENoteConfiguration");
        }
        String path = "/v2/accounts/{accountId}/settings/enote_configuration".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<ENoteConfiguration> returnType = new GenericType<ENoteConfiguration>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public ENoteConfiguration updateENoteConfiguration(String accountId, ENoteConfiguration eNoteConfiguration) throws ApiException {
        ENoteConfiguration postBody = eNoteConfiguration;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateENoteConfiguration");
        }
        String path = "/v2/accounts/{accountId}/settings/enote_configuration".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<ENoteConfiguration> returnType = new GenericType<ENoteConfiguration>(){};
        return this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public void deleteENoteConfiguration(String accountId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteENoteConfiguration");
        }
        String path = "/v2/accounts/{accountId}/settings/enote_configuration".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(path, "DELETE", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, null);
    }

    public TabAccountSettings getAccountTabSettings(String accountId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getAccountTabSettings");
        }
        String path = "/v2/accounts/{accountId}/settings/tabs".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<TabAccountSettings> returnType = new GenericType<TabAccountSettings>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public TabAccountSettings updateAccountTabSettings(String accountId, TabAccountSettings tabAccountSettings) throws ApiException {
        TabAccountSettings postBody = tabAccountSettings;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateAccountTabSettings");
        }
        String path = "/v2/accounts/{accountId}/settings/tabs".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<TabAccountSettings> returnType = new GenericType<TabAccountSettings>(){};
        return this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public AccountSharedAccess listSharedAccess(String accountId) throws ApiException {
        return this.listSharedAccess(accountId, null);
    }

    public AccountSharedAccess listSharedAccess(String accountId, ListSharedAccessOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listSharedAccess");
        }
        String path = "/v2/accounts/{accountId}/shared_access".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "count", options.count));
            queryParams.addAll(this.apiClient.parameterToPairs("", "envelopes_not_shared_user_status", options.envelopesNotSharedUserStatus));
            queryParams.addAll(this.apiClient.parameterToPairs("", "folder_ids", options.folderIds));
            queryParams.addAll(this.apiClient.parameterToPairs("", "item_type", options.itemType));
            queryParams.addAll(this.apiClient.parameterToPairs("", "search_text", options.searchText));
            queryParams.addAll(this.apiClient.parameterToPairs("", "shared", options.shared));
            queryParams.addAll(this.apiClient.parameterToPairs("", "start_position", options.startPosition));
            queryParams.addAll(this.apiClient.parameterToPairs("", "user_ids", options.userIds));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<AccountSharedAccess> returnType = new GenericType<AccountSharedAccess>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public AccountSharedAccess updateSharedAccess(String accountId, AccountSharedAccess accountSharedAccess) throws ApiException {
        return this.updateSharedAccess(accountId, accountSharedAccess, null);
    }

    public AccountSharedAccess updateSharedAccess(String accountId, AccountSharedAccess accountSharedAccess, UpdateSharedAccessOptions options) throws ApiException {
        AccountSharedAccess postBody = accountSharedAccess;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateSharedAccess");
        }
        String path = "/v2/accounts/{accountId}/shared_access".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "item_type", options.itemType));
            queryParams.addAll(this.apiClient.parameterToPairs("", "user_ids", options.userIds));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<AccountSharedAccess> returnType = new GenericType<AccountSharedAccess>(){};
        return this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public AccountSignatureProviders listSignatureProviders(String accountId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listSignatureProviders");
        }
        String path = "/v2/accounts/{accountId}/signatureProviders".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<AccountSignatureProviders> returnType = new GenericType<AccountSignatureProviders>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public FileTypeList listUnsupportedFileTypes(String accountId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listUnsupportedFileTypes");
        }
        String path = "/v2/accounts/{accountId}/unsupported_file_types".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<FileTypeList> returnType = new GenericType<FileTypeList>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public class UpdateSharedAccessOptions {
        private String itemType = null;
        private String userIds = null;

        public void setItemType(String itemType) {
            this.itemType = itemType;
        }

        public String getItemType() {
            return this.itemType;
        }

        public void setUserIds(String userIds) {
            this.userIds = userIds;
        }

        public String getUserIds() {
            return this.userIds;
        }
    }

    public class ListSharedAccessOptions {
        private String count = null;
        private String envelopesNotSharedUserStatus = null;
        private String folderIds = null;
        private String itemType = null;
        private String searchText = null;
        private String shared = null;
        private String startPosition = null;
        private String userIds = null;

        public void setCount(String count) {
            this.count = count;
        }

        public String getCount() {
            return this.count;
        }

        public void setEnvelopesNotSharedUserStatus(String envelopesNotSharedUserStatus) {
            this.envelopesNotSharedUserStatus = envelopesNotSharedUserStatus;
        }

        public String getEnvelopesNotSharedUserStatus() {
            return this.envelopesNotSharedUserStatus;
        }

        public void setFolderIds(String folderIds) {
            this.folderIds = folderIds;
        }

        public String getFolderIds() {
            return this.folderIds;
        }

        public void setItemType(String itemType) {
            this.itemType = itemType;
        }

        public String getItemType() {
            return this.itemType;
        }

        public void setSearchText(String searchText) {
            this.searchText = searchText;
        }

        public String getSearchText() {
            return this.searchText;
        }

        public void setShared(String shared) {
            this.shared = shared;
        }

        public String getShared() {
            return this.shared;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getStartPosition() {
            return this.startPosition;
        }

        public void setUserIds(String userIds) {
            this.userIds = userIds;
        }

        public String getUserIds() {
            return this.userIds;
        }
    }

    public class ListRecipientNamesByEmailOptions {
        private String email = null;

        public void setEmail(String email) {
            this.email = email;
        }

        public String getEmail() {
            return this.email;
        }
    }

    public class UpdatePermissionProfileOptions {
        private String include = null;

        public void setInclude(String include) {
            this.include = include;
        }

        public String getInclude() {
            return this.include;
        }
    }

    public class GetPermissionProfileOptions {
        private String include = null;

        public void setInclude(String include) {
            this.include = include;
        }

        public String getInclude() {
            return this.include;
        }
    }

    public class CreatePermissionProfileOptions {
        private String include = null;

        public void setInclude(String include) {
            this.include = include;
        }

        public String getInclude() {
            return this.include;
        }
    }

    public class ListPermissionsOptions {
        private String include = null;

        public void setInclude(String include) {
            this.include = include;
        }

        public String getInclude() {
            return this.include;
        }
    }

    public class GetConsumerDisclosureDefaultOptions {
        private String langCode = null;

        public void setLangCode(String langCode) {
            this.langCode = langCode;
        }

        public String getLangCode() {
            return this.langCode;
        }
    }

    public class GetBrandResourcesByContentTypeOptions {
        private String langcode = null;
        private String returnMaster = null;

        public void setLangcode(String langcode) {
            this.langcode = langcode;
        }

        public String getLangcode() {
            return this.langcode;
        }

        public void setReturnMaster(String returnMaster) {
            this.returnMaster = returnMaster;
        }

        public String getReturnMaster() {
            return this.returnMaster;
        }
    }

    public class GetBrandOptions {
        private String includeExternalReferences = null;
        private String includeLogos = null;

        public void setIncludeExternalReferences(String includeExternalReferences) {
            this.includeExternalReferences = includeExternalReferences;
        }

        public String getIncludeExternalReferences() {
            return this.includeExternalReferences;
        }

        public void setIncludeLogos(String includeLogos) {
            this.includeLogos = includeLogos;
        }

        public String getIncludeLogos() {
            return this.includeLogos;
        }
    }

    public class ListBrandsOptions {
        private String excludeDistributorBrand = null;
        private String includeLogos = null;

        public void setExcludeDistributorBrand(String excludeDistributorBrand) {
            this.excludeDistributorBrand = excludeDistributorBrand;
        }

        public String getExcludeDistributorBrand() {
            return this.excludeDistributorBrand;
        }

        public void setIncludeLogos(String includeLogos) {
            this.includeLogos = includeLogos;
        }

        public String getIncludeLogos() {
            return this.includeLogos;
        }
    }

    public class GetBillingChargesOptions {
        private String includeCharges = null;

        public void setIncludeCharges(String includeCharges) {
            this.includeCharges = includeCharges;
        }

        public String getIncludeCharges() {
            return this.includeCharges;
        }
    }

    public class GetAccountInformationOptions {
        private String includeAccountSettings = null;

        public void setIncludeAccountSettings(String includeAccountSettings) {
            this.includeAccountSettings = includeAccountSettings;
        }

        public String getIncludeAccountSettings() {
            return this.includeAccountSettings;
        }
    }

    public class CreateOptions {
        private String previewBillingPlan = null;

        public void setPreviewBillingPlan(String previewBillingPlan) {
            this.previewBillingPlan = previewBillingPlan;
        }

        public String getPreviewBillingPlan() {
            return this.previewBillingPlan;
        }
    }
}

