/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.api;

import com.docusign.esign.client.ApiClient;
import com.docusign.esign.client.ApiException;
import com.docusign.esign.client.Configuration;
import com.docusign.esign.client.Pair;
import com.docusign.esign.model.CloudStorageProviders;
import com.docusign.esign.model.ExternalFolder;
import com.sun.jersey.api.client.GenericType;
import java.util.ArrayList;
import java.util.HashMap;

public class CloudStorageApi {
    private ApiClient apiClient;

    public CloudStorageApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CloudStorageApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CloudStorageProviders listProviders(String accountId, String userId) throws ApiException {
        return this.listProviders(accountId, userId, null);
    }

    public CloudStorageProviders listProviders(String accountId, String userId, ListProvidersOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listProviders");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listProviders");
        }
        String path = "/v2/accounts/{accountId}/users/{userId}/cloud_storage".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "redirectUrl", options.redirectUrl));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<CloudStorageProviders> returnType = new GenericType<CloudStorageProviders>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public CloudStorageProviders createProvider(String accountId, String userId, CloudStorageProviders cloudStorageProviders) throws ApiException {
        CloudStorageProviders postBody = cloudStorageProviders;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createProvider");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling createProvider");
        }
        String path = "/v2/accounts/{accountId}/users/{userId}/cloud_storage".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<CloudStorageProviders> returnType = new GenericType<CloudStorageProviders>(){};
        return this.apiClient.invokeAPI(path, "POST", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public CloudStorageProviders deleteProviders(String accountId, String userId, CloudStorageProviders cloudStorageProviders) throws ApiException {
        CloudStorageProviders postBody = cloudStorageProviders;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteProviders");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling deleteProviders");
        }
        String path = "/v2/accounts/{accountId}/users/{userId}/cloud_storage".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<CloudStorageProviders> returnType = new GenericType<CloudStorageProviders>(){};
        return this.apiClient.invokeAPI(path, "DELETE", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public CloudStorageProviders getProvider(String accountId, String userId, String serviceId) throws ApiException {
        return this.getProvider(accountId, userId, serviceId, null);
    }

    public CloudStorageProviders getProvider(String accountId, String userId, String serviceId, GetProviderOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getProvider");
        }
        if (serviceId == null) {
            throw new ApiException(400, "Missing the required parameter 'serviceId' when calling getProvider");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getProvider");
        }
        String path = "/v2/accounts/{accountId}/users/{userId}/cloud_storage/{serviceId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{serviceId\\}", this.apiClient.escapeString(serviceId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "redirectUrl", options.redirectUrl));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<CloudStorageProviders> returnType = new GenericType<CloudStorageProviders>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public CloudStorageProviders deleteProvider(String accountId, String userId, String serviceId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteProvider");
        }
        if (serviceId == null) {
            throw new ApiException(400, "Missing the required parameter 'serviceId' when calling deleteProvider");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling deleteProvider");
        }
        String path = "/v2/accounts/{accountId}/users/{userId}/cloud_storage/{serviceId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{serviceId\\}", this.apiClient.escapeString(serviceId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<CloudStorageProviders> returnType = new GenericType<CloudStorageProviders>(){};
        return this.apiClient.invokeAPI(path, "DELETE", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public ExternalFolder listFolders(String accountId, String userId, String serviceId) throws ApiException {
        return this.listFolders(accountId, userId, serviceId, null);
    }

    public ExternalFolder listFolders(String accountId, String userId, String serviceId, ListFoldersOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listFolders");
        }
        if (serviceId == null) {
            throw new ApiException(400, "Missing the required parameter 'serviceId' when calling listFolders");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listFolders");
        }
        String path = "/v2/accounts/{accountId}/users/{userId}/cloud_storage/{serviceId}/folders".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{serviceId\\}", this.apiClient.escapeString(serviceId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "cloud_storage_folder_path", options.cloudStorageFolderPath));
            queryParams.addAll(this.apiClient.parameterToPairs("", "count", options.count));
            queryParams.addAll(this.apiClient.parameterToPairs("", "order", options.order));
            queryParams.addAll(this.apiClient.parameterToPairs("", "order_by", options.orderBy));
            queryParams.addAll(this.apiClient.parameterToPairs("", "search_text", options.searchText));
            queryParams.addAll(this.apiClient.parameterToPairs("", "start_position", options.startPosition));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<ExternalFolder> returnType = new GenericType<ExternalFolder>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public ExternalFolder list(String accountId, String userId, String serviceId, String folderId) throws ApiException {
        return this.list(accountId, userId, serviceId, folderId, null);
    }

    public ExternalFolder list(String accountId, String userId, String serviceId, String folderId, ListOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling list");
        }
        if (folderId == null) {
            throw new ApiException(400, "Missing the required parameter 'folderId' when calling list");
        }
        if (serviceId == null) {
            throw new ApiException(400, "Missing the required parameter 'serviceId' when calling list");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling list");
        }
        String path = "/v2/accounts/{accountId}/users/{userId}/cloud_storage/{serviceId}/folders/{folderId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{serviceId\\}", this.apiClient.escapeString(serviceId.toString())).replaceAll("\\{folderId\\}", this.apiClient.escapeString(folderId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "cloud_storage_folder_path", options.cloudStorageFolderPath));
            queryParams.addAll(this.apiClient.parameterToPairs("", "count", options.count));
            queryParams.addAll(this.apiClient.parameterToPairs("", "order", options.order));
            queryParams.addAll(this.apiClient.parameterToPairs("", "order_by", options.orderBy));
            queryParams.addAll(this.apiClient.parameterToPairs("", "search_text", options.searchText));
            queryParams.addAll(this.apiClient.parameterToPairs("", "start_position", options.startPosition));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<ExternalFolder> returnType = new GenericType<ExternalFolder>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public class ListOptions {
        private String cloudStorageFolderPath = null;
        private String count = null;
        private String order = null;
        private String orderBy = null;
        private String searchText = null;
        private String startPosition = null;

        public void setCloudStorageFolderPath(String cloudStorageFolderPath) {
            this.cloudStorageFolderPath = cloudStorageFolderPath;
        }

        public String getCloudStorageFolderPath() {
            return this.cloudStorageFolderPath;
        }

        public void setCount(String count) {
            this.count = count;
        }

        public String getCount() {
            return this.count;
        }

        public void setOrder(String order) {
            this.order = order;
        }

        public String getOrder() {
            return this.order;
        }

        public void setOrderBy(String orderBy) {
            this.orderBy = orderBy;
        }

        public String getOrderBy() {
            return this.orderBy;
        }

        public void setSearchText(String searchText) {
            this.searchText = searchText;
        }

        public String getSearchText() {
            return this.searchText;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getStartPosition() {
            return this.startPosition;
        }
    }

    public class ListFoldersOptions {
        private String cloudStorageFolderPath = null;
        private String count = null;
        private String order = null;
        private String orderBy = null;
        private String searchText = null;
        private String startPosition = null;

        public void setCloudStorageFolderPath(String cloudStorageFolderPath) {
            this.cloudStorageFolderPath = cloudStorageFolderPath;
        }

        public String getCloudStorageFolderPath() {
            return this.cloudStorageFolderPath;
        }

        public void setCount(String count) {
            this.count = count;
        }

        public String getCount() {
            return this.count;
        }

        public void setOrder(String order) {
            this.order = order;
        }

        public String getOrder() {
            return this.order;
        }

        public void setOrderBy(String orderBy) {
            this.orderBy = orderBy;
        }

        public String getOrderBy() {
            return this.orderBy;
        }

        public void setSearchText(String searchText) {
            this.searchText = searchText;
        }

        public String getSearchText() {
            return this.searchText;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getStartPosition() {
            return this.startPosition;
        }
    }

    public class GetProviderOptions {
        private String redirectUrl = null;

        public void setRedirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
        }

        public String getRedirectUrl() {
            return this.redirectUrl;
        }
    }

    public class ListProvidersOptions {
        private String redirectUrl = null;

        public void setRedirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
        }

        public String getRedirectUrl() {
            return this.redirectUrl;
        }
    }
}

